/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.collection.PredicatedCollection;
import org.apache.commons.collections4.functors.TruePredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicatedCollectionTest<E>
extends AbstractCollectionTest<E> {
    protected Predicate<E> truePredicate = TruePredicate.truePredicate();
    protected Predicate<E> testPredicate = new Predicate<E>(){

        public boolean evaluate(E o) {
            return o instanceof String;
        }
    };

    public PredicatedCollectionTest(String name) {
        super(name);
    }

    protected Collection<E> decorateCollection(Collection<E> collection, Predicate<E> predicate) {
        return PredicatedCollection.predicatedCollection(collection, predicate);
    }

    @Override
    public Collection<E> makeObject() {
        return this.decorateCollection(new ArrayList(), this.truePredicate);
    }

    @Override
    public Collection<E> makeConfirmedCollection() {
        return new ArrayList();
    }

    @Override
    public E[] getFullElements() {
        return new Object[]{"1", "3", "5", "7", "2", "4", "6"};
    }

    @Override
    public Collection<E> makeFullCollection() {
        ArrayList<E> list = new ArrayList<E>();
        list.addAll(Arrays.asList(this.getFullElements()));
        return this.decorateCollection(list, this.truePredicate);
    }

    @Override
    public Collection<E> makeConfirmedFullCollection() {
        ArrayList<E> list = new ArrayList<E>();
        list.addAll(Arrays.asList(this.getFullElements()));
        return list;
    }

    public Collection<E> makeTestCollection() {
        return this.decorateCollection(new ArrayList(), this.testPredicate);
    }

    public void testIllegalAdd() {
        Collection<Integer> c = this.makeTestCollection();
        Integer i = 3;
        try {
            c.add(i);
            PredicatedCollectionTest.fail((String)"Integer should fail string predicate.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        PredicatedCollectionTest.assertTrue((String)"Collection shouldn't contain illegal element", (!c.contains(i) ? 1 : 0) != 0);
    }

    public void testIllegalAddAll() {
        Collection c = this.makeTestCollection();
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add("one");
        elements.add("two");
        elements.add(3);
        elements.add("four");
        try {
            c.addAll(elements);
            PredicatedCollectionTest.fail((String)"Integer should fail string predicate.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        PredicatedCollectionTest.assertTrue((String)"Collection shouldn't contain illegal element", (!c.contains("one") ? 1 : 0) != 0);
        PredicatedCollectionTest.assertTrue((String)"Collection shouldn't contain illegal element", (!c.contains("two") ? 1 : 0) != 0);
        PredicatedCollectionTest.assertTrue((String)"Collection shouldn't contain illegal element", (!c.contains(3) ? 1 : 0) != 0);
        PredicatedCollectionTest.assertTrue((String)"Collection shouldn't contain illegal element", (!c.contains("four") ? 1 : 0) != 0);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

