/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.comparators;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.comparators.AbstractComparatorTest;
import org.apache.commons.collections4.comparators.BooleanComparator;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanComparatorTest
extends AbstractComparatorTest<Boolean> {
    public BooleanComparatorTest(String testName) {
        super(testName);
    }

    @Override
    public Comparator<Boolean> makeObject() {
        return new BooleanComparator();
    }

    @Override
    public List<Boolean> getComparableObjectsOrdered() {
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        list.add(new Boolean(false));
        list.add(Boolean.FALSE);
        list.add(new Boolean(false));
        list.add(Boolean.TRUE);
        list.add(new Boolean(true));
        list.add(true);
        return list;
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Test
    public void testConstructors() {
        this.allTests(false, new BooleanComparator());
        this.allTests(false, new BooleanComparator(false));
        this.allTests(true, new BooleanComparator(true));
    }

    @Test
    public void testStaticFactoryMethods() {
        this.allTests(false, BooleanComparator.getFalseFirstComparator());
        this.allTests(false, BooleanComparator.booleanComparator((boolean)false));
        this.allTests(true, BooleanComparator.getTrueFirstComparator());
        this.allTests(true, BooleanComparator.booleanComparator((boolean)true));
    }

    @Test
    public void testEqualsCompatibleInstance() {
        BooleanComparatorTest.assertEquals((Object)new BooleanComparator(), (Object)new BooleanComparator(false));
        BooleanComparatorTest.assertEquals((Object)new BooleanComparator(false), (Object)new BooleanComparator(false));
        BooleanComparatorTest.assertEquals((Object)new BooleanComparator(false), (Object)BooleanComparator.getFalseFirstComparator());
        BooleanComparatorTest.assertSame((Object)BooleanComparator.getFalseFirstComparator(), (Object)BooleanComparator.booleanComparator((boolean)false));
        BooleanComparatorTest.assertEquals((Object)new BooleanComparator(true), (Object)new BooleanComparator(true));
        BooleanComparatorTest.assertEquals((Object)new BooleanComparator(true), (Object)BooleanComparator.getTrueFirstComparator());
        BooleanComparatorTest.assertSame((Object)BooleanComparator.getTrueFirstComparator(), (Object)BooleanComparator.booleanComparator((boolean)true));
        BooleanComparatorTest.assertTrue((!new BooleanComparator().equals((Object)new BooleanComparator(true)) ? 1 : 0) != 0);
        BooleanComparatorTest.assertTrue((!new BooleanComparator(true).equals((Object)new BooleanComparator(false)) ? 1 : 0) != 0);
    }

    protected void allTests(boolean trueFirst, BooleanComparator comp) {
        this.orderIndependentTests(comp);
        if (trueFirst) {
            this.trueFirstTests(comp);
        } else {
            this.falseFirstTests(comp);
        }
    }

    protected void trueFirstTests(BooleanComparator comp) {
        BooleanComparatorTest.assertNotNull((Object)comp);
        BooleanComparatorTest.assertEquals((int)0, (int)comp.compare(Boolean.valueOf(true), Boolean.valueOf(true)));
        BooleanComparatorTest.assertEquals((int)0, (int)comp.compare(Boolean.valueOf(false), Boolean.valueOf(false)));
        BooleanComparatorTest.assertTrue((comp.compare(Boolean.valueOf(false), Boolean.valueOf(true)) > 0 ? 1 : 0) != 0);
        BooleanComparatorTest.assertTrue((comp.compare(Boolean.valueOf(true), Boolean.valueOf(false)) < 0 ? 1 : 0) != 0);
    }

    protected void falseFirstTests(BooleanComparator comp) {
        BooleanComparatorTest.assertNotNull((Object)comp);
        BooleanComparatorTest.assertEquals((int)0, (int)comp.compare(Boolean.valueOf(true), Boolean.valueOf(true)));
        BooleanComparatorTest.assertEquals((int)0, (int)comp.compare(Boolean.valueOf(false), Boolean.valueOf(false)));
        BooleanComparatorTest.assertTrue((comp.compare(Boolean.valueOf(false), Boolean.valueOf(true)) < 0 ? 1 : 0) != 0);
        BooleanComparatorTest.assertTrue((comp.compare(Boolean.valueOf(true), Boolean.valueOf(false)) > 0 ? 1 : 0) != 0);
    }

    protected void orderIndependentTests(BooleanComparator comp) {
        this.nullArgumentTests(comp);
    }

    protected void nullArgumentTests(BooleanComparator comp) {
        BooleanComparatorTest.assertNotNull((Object)comp);
        try {
            comp.compare(null, null);
            BooleanComparatorTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            comp.compare(Boolean.TRUE, null);
            BooleanComparatorTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            comp.compare(Boolean.FALSE, null);
            BooleanComparatorTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            comp.compare(null, Boolean.TRUE);
            BooleanComparatorTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            comp.compare(null, Boolean.FALSE);
            BooleanComparatorTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

