/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.functors;

import org.apache.commons.collections4.Predicate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPredicateTest {
    protected Object cObject;
    protected String cString;
    protected Integer cInteger;

    @Before
    public void initialiseTestObjects() throws Exception {
        this.cObject = new Object();
        this.cString = "Hello";
        this.cInteger = 6;
    }

    @Test
    public void predicateSanityTests() throws Exception {
        Predicate<?> predicate = this.generatePredicate();
        Assert.assertNotNull(predicate);
    }

    protected abstract Predicate<?> generatePredicate();

    protected <T> void assertFalse(Predicate<T> predicate, T testObject) {
        Assert.assertFalse((boolean)predicate.evaluate(testObject));
    }

    protected <T> void assertTrue(Predicate<T> predicate, T testObject) {
        Assert.assertTrue((boolean)predicate.evaluate(testObject));
    }
}

