/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.functors;

import java.io.IOException;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.FunctorException;
import org.apache.commons.collections4.functors.AbstractClosureTest;
import org.apache.commons.collections4.functors.CatchAndRethrowClosure;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatchAndRethrowClosureTest
extends AbstractClosureTest {
    private static <T> Closure<T> generateIOExceptionClosure() {
        return new CatchAndRethrowClosure<T>(){

            protected void executeAndThrow(T input) throws IOException {
                throw new IOException();
            }
        };
    }

    private static <T> Closure<T> generateNullPointerExceptionClosure() {
        return new CatchAndRethrowClosure<T>(){

            protected void executeAndThrow(T input) {
                throw new NullPointerException();
            }
        };
    }

    private static <T> Closure<T> generateNoExceptionClosure() {
        return new CatchAndRethrowClosure<T>(){

            protected void executeAndThrow(T input) {
            }
        };
    }

    @Override
    protected <T> Closure<T> generateClosure() {
        return CatchAndRethrowClosureTest.generateNoExceptionClosure();
    }

    @Test
    public void testThrowingClosure() {
        Closure closure = CatchAndRethrowClosureTest.generateNoExceptionClosure();
        try {
            closure.execute((Object)0);
        }
        catch (FunctorException ex) {
            Assert.fail();
        }
        catch (RuntimeException ex) {
            Assert.fail();
        }
        closure = CatchAndRethrowClosureTest.generateIOExceptionClosure();
        try {
            closure.execute((Object)0);
            Assert.fail();
        }
        catch (FunctorException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof IOException));
        }
        catch (RuntimeException ex) {
            Assert.fail();
        }
        closure = CatchAndRethrowClosureTest.generateNullPointerExceptionClosure();
        try {
            closure.execute((Object)0);
            Assert.fail();
        }
        catch (FunctorException ex) {
            Assert.fail();
        }
        catch (RuntimeException ex) {
            Assert.assertTrue((boolean)(ex instanceof NullPointerException));
        }
    }
}

