/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapIteratorTest<K, V>
extends AbstractIteratorTest<K> {
    public AbstractMapIteratorTest(String testName) {
        super(testName);
    }

    public abstract MapIterator<K, V> makeEmptyIterator();

    public abstract MapIterator<K, V> makeObject();

    public abstract Map<K, V> getMap();

    public abstract Map<K, V> getConfirmedMap();

    public boolean supportsSetValue() {
        return true;
    }

    public boolean isGetStructuralModify() {
        return false;
    }

    public V[] addSetValues() {
        return new Object[]{"A", "B"};
    }

    public void testEmptyMapIterator() {
        if (!this.supportsEmptyIterator()) {
            return;
        }
        MapIterator<K, V> it = this.makeEmptyIterator();
        AbstractMapIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
        try {
            it.next();
            AbstractMapIteratorTest.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        try {
            it.getKey();
            AbstractMapIteratorTest.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        try {
            it.getValue();
            AbstractMapIteratorTest.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        if (!this.supportsSetValue()) {
            try {
                it.setValue(this.addSetValues()[0]);
                AbstractMapIteratorTest.fail();
            }
            catch (UnsupportedOperationException ex) {
            }
            catch (IllegalStateException ex) {}
        } else {
            try {
                it.setValue(this.addSetValues()[0]);
                AbstractMapIteratorTest.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void testFullMapIterator() {
        if (!this.supportsFullIterator()) {
            return;
        }
        MapIterator<K, V> it = this.makeObject();
        Map<K, V> map = this.getMap();
        AbstractMapIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        AbstractMapIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        HashSet<Object> set = new HashSet<Object>();
        while (it.hasNext()) {
            Object key = it.next();
            AbstractMapIteratorTest.assertSame((String)"it.next() should equals getKey()", (Object)key, (Object)it.getKey());
            AbstractMapIteratorTest.assertTrue((String)"Key must be in map", (boolean)map.containsKey(key));
            AbstractMapIteratorTest.assertTrue((String)"Key must be unique", (boolean)set.add(key));
            Object value = it.getValue();
            if (!this.isGetStructuralModify()) {
                AbstractMapIteratorTest.assertSame((String)"Value must be mapped to key", map.get(key), (Object)value);
            }
            AbstractMapIteratorTest.assertTrue((String)"Value must be in map", (boolean)map.containsValue(value));
            this.verify();
        }
    }

    public void testMapIteratorSet() {
        if (!this.supportsFullIterator()) {
            return;
        }
        V newValue = this.addSetValues()[0];
        V newValue2 = this.addSetValues().length == 1 ? this.addSetValues()[0] : this.addSetValues()[1];
        MapIterator<K, V> it = this.makeObject();
        Map<K, V> map = this.getMap();
        Map<Object, V> confirmed = this.getConfirmedMap();
        AbstractMapIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        Object key = it.next();
        Object value = it.getValue();
        if (!this.supportsSetValue()) {
            try {
                it.setValue(newValue);
                AbstractMapIteratorTest.fail();
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            return;
        }
        Object old = it.setValue(newValue);
        confirmed.put(key, newValue);
        AbstractMapIteratorTest.assertSame((String)"Key must not change after setValue", (Object)key, (Object)it.getKey());
        AbstractMapIteratorTest.assertSame((String)"Value must be changed after setValue", newValue, (Object)it.getValue());
        AbstractMapIteratorTest.assertSame((String)"setValue must return old value", (Object)value, (Object)old);
        AbstractMapIteratorTest.assertEquals((String)"Map must contain key", (boolean)true, (boolean)map.containsKey(key));
        AbstractMapIteratorTest.assertEquals((String)"Map must not contain old value", (boolean)confirmed.containsValue(old), (boolean)map.containsValue(old));
        AbstractMapIteratorTest.assertEquals((String)"Map must contain new value", (boolean)true, (boolean)map.containsValue(newValue));
        this.verify();
        it.setValue(newValue);
        confirmed.put(key, newValue);
        AbstractMapIteratorTest.assertSame((String)"Key must not change after setValue", (Object)key, (Object)it.getKey());
        AbstractMapIteratorTest.assertSame((String)"Value must be changed after setValue", newValue, (Object)it.getValue());
        this.verify();
        it.setValue(newValue2);
        confirmed.put(key, newValue2);
        AbstractMapIteratorTest.assertSame((String)"Key must not change after setValue", (Object)key, (Object)it.getKey());
        AbstractMapIteratorTest.assertSame((String)"Value must be changed after setValue", newValue2, (Object)it.getValue());
        this.verify();
    }

    @Override
    public void testRemove() {
        MapIterator<K, V> it = this.makeObject();
        Map<K, V> map = this.getMap();
        Map<K, V> confirmed = this.getConfirmedMap();
        AbstractMapIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        Object key = it.next();
        if (!this.supportsRemove()) {
            try {
                it.remove();
                AbstractMapIteratorTest.fail();
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            return;
        }
        it.remove();
        confirmed.remove(key);
        AbstractMapIteratorTest.assertEquals((boolean)false, (boolean)map.containsKey(key));
        this.verify();
        try {
            it.remove();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        this.verify();
    }

    public void testMapIteratorSetRemoveSet() {
        if (!this.supportsSetValue() || !this.supportsRemove()) {
            return;
        }
        V newValue = this.addSetValues()[0];
        MapIterator<K, V> it = this.makeObject();
        Map<K, V> confirmed = this.getConfirmedMap();
        AbstractMapIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        Object key = it.next();
        it.setValue(newValue);
        it.remove();
        confirmed.remove(key);
        this.verify();
        try {
            it.setValue(newValue);
            AbstractMapIteratorTest.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        this.verify();
    }

    public void testMapIteratorRemoveGetKey() {
        if (!this.supportsRemove()) {
            return;
        }
        MapIterator<K, V> it = this.makeObject();
        Map<K, V> confirmed = this.getConfirmedMap();
        AbstractMapIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        Object key = it.next();
        it.remove();
        confirmed.remove(key);
        this.verify();
        try {
            it.getKey();
            AbstractMapIteratorTest.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        this.verify();
    }

    public void testMapIteratorRemoveGetValue() {
        if (!this.supportsRemove()) {
            return;
        }
        MapIterator<K, V> it = this.makeObject();
        Map<K, V> confirmed = this.getConfirmedMap();
        AbstractMapIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        Object key = it.next();
        it.remove();
        confirmed.remove(key);
        this.verify();
        try {
            it.getValue();
            AbstractMapIteratorTest.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        this.verify();
    }
}

