/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.ArrayIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIteratorTest<E>
extends AbstractIteratorTest<E> {
    protected String[] testArray = new String[]{"One", "Two", "Three"};

    public ArrayIteratorTest(String testName) {
        super(testName);
    }

    @Override
    public ArrayIterator<E> makeEmptyIterator() {
        return new ArrayIterator((Object)new Object[0]);
    }

    @Override
    public ArrayIterator<E> makeObject() {
        return new ArrayIterator((Object)this.testArray);
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    public void testIterator() {
        ArrayIterator<E> iter = this.makeObject();
        for (String testValue : this.testArray) {
            Object iterValue = iter.next();
            ArrayIteratorTest.assertEquals((String)"Iteration value is correct", (Object)testValue, iterValue);
        }
        ArrayIteratorTest.assertTrue((String)"Iterator should now be empty", (!iter.hasNext() ? 1 : 0) != 0);
        try {
            iter.next();
        }
        catch (Exception e) {
            ArrayIteratorTest.assertTrue((String)"NoSuchElementException must be thrown", (boolean)e.getClass().equals(new NoSuchElementException().getClass()));
        }
    }

    public void testNullArray() {
        try {
            new ArrayIterator(null);
            ArrayIteratorTest.fail((String)"Constructor should throw a NullPointerException when constructed with a null array");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testReset() {
        ArrayIterator<E> it = this.makeObject();
        it.next();
        it.reset();
        ArrayIteratorTest.assertEquals((Object)"One", (Object)it.next());
    }
}

