/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.apache.commons.collections4.iterators.LoopingListIterator;

public class LoopingListIteratorTest
extends TestCase {
    public void testConstructorEx() throws Exception {
        try {
            new LoopingListIterator(null);
            LoopingListIteratorTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testLooping0() throws Exception {
        ArrayList list = new ArrayList();
        LoopingListIterator loop = new LoopingListIterator(list);
        LoopingListIteratorTest.assertFalse((boolean)loop.hasNext());
        LoopingListIteratorTest.assertFalse((boolean)loop.hasPrevious());
        try {
            loop.next();
            LoopingListIteratorTest.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        try {
            loop.previous();
            LoopingListIteratorTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testLooping1() throws Exception {
        List<String> list = Arrays.asList("a");
        LoopingListIterator loop = new LoopingListIterator(list);
        LoopingListIteratorTest.assertTrue((boolean)loop.hasNext());
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingListIteratorTest.assertTrue((boolean)loop.hasNext());
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingListIteratorTest.assertTrue((boolean)loop.hasNext());
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingListIteratorTest.assertTrue((boolean)loop.hasPrevious());
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.previous()));
        LoopingListIteratorTest.assertTrue((boolean)loop.hasPrevious());
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.previous()));
        LoopingListIteratorTest.assertTrue((boolean)loop.hasPrevious());
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.previous()));
    }

    public void testLooping2() throws Exception {
        List<String> list = Arrays.asList("a", "b");
        LoopingListIterator loop = new LoopingListIterator(list);
        LoopingListIteratorTest.assertTrue((boolean)loop.hasNext());
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingListIteratorTest.assertTrue((boolean)loop.hasNext());
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.next()));
        LoopingListIteratorTest.assertTrue((boolean)loop.hasNext());
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        loop.reset();
        LoopingListIteratorTest.assertTrue((boolean)loop.hasPrevious());
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.previous()));
        LoopingListIteratorTest.assertTrue((boolean)loop.hasPrevious());
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.previous()));
        LoopingListIteratorTest.assertTrue((boolean)loop.hasPrevious());
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.previous()));
    }

    public void testJoggingNotOverBoundary() {
        List<String> list = Arrays.asList("a", "b");
        LoopingListIterator loop = new LoopingListIterator(list);
        loop.reset();
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.previous()));
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.previous()));
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.next()));
    }

    public void testJoggingOverBoundary() {
        List<String> list = Arrays.asList("a", "b");
        LoopingListIterator loop = new LoopingListIterator(list);
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.previous()));
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.previous()));
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.previous()));
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.previous()));
    }

    public void testRemovingElementsAndIteratingForward() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("a", "b", "c"));
        LoopingListIterator loop = new LoopingListIterator(list);
        LoopingListIteratorTest.assertTrue((boolean)loop.hasNext());
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        loop.remove();
        LoopingListIteratorTest.assertEquals((int)2, (int)list.size());
        LoopingListIteratorTest.assertTrue((boolean)loop.hasNext());
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.next()));
        loop.remove();
        LoopingListIteratorTest.assertEquals((int)1, (int)list.size());
        LoopingListIteratorTest.assertTrue((boolean)loop.hasNext());
        LoopingListIteratorTest.assertEquals((String)"c", (String)((String)loop.next()));
        loop.remove();
        LoopingListIteratorTest.assertEquals((int)0, (int)list.size());
        LoopingListIteratorTest.assertFalse((boolean)loop.hasNext());
        try {
            loop.next();
            LoopingListIteratorTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemovingElementsAndIteratingBackwards() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("a", "b", "c"));
        LoopingListIterator loop = new LoopingListIterator(list);
        LoopingListIteratorTest.assertTrue((boolean)loop.hasPrevious());
        LoopingListIteratorTest.assertEquals((String)"c", (String)((String)loop.previous()));
        loop.remove();
        LoopingListIteratorTest.assertEquals((int)2, (int)list.size());
        LoopingListIteratorTest.assertTrue((boolean)loop.hasPrevious());
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.previous()));
        loop.remove();
        LoopingListIteratorTest.assertEquals((int)1, (int)list.size());
        LoopingListIteratorTest.assertTrue((boolean)loop.hasPrevious());
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.previous()));
        loop.remove();
        LoopingListIteratorTest.assertEquals((int)0, (int)list.size());
        LoopingListIteratorTest.assertFalse((boolean)loop.hasPrevious());
        try {
            loop.previous();
            LoopingListIteratorTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testReset() {
        List<String> list = Arrays.asList("a", "b", "c");
        LoopingListIterator loop = new LoopingListIterator(list);
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.next()));
        loop.reset();
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        loop.reset();
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"c", (String)((String)loop.next()));
        loop.reset();
        LoopingListIteratorTest.assertEquals((String)"c", (String)((String)loop.previous()));
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.previous()));
        loop.reset();
        LoopingListIteratorTest.assertEquals((String)"c", (String)((String)loop.previous()));
        loop.reset();
        LoopingListIteratorTest.assertEquals((String)"c", (String)((String)loop.previous()));
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.previous()));
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.previous()));
    }

    public void testAdd() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("b", "e", "f"));
        LoopingListIterator loop = new LoopingListIterator(list);
        loop.add((Object)"a");
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.next()));
        loop.reset();
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.next()));
        loop.add((Object)"c");
        LoopingListIteratorTest.assertEquals((String)"e", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"e", (String)((String)loop.previous()));
        LoopingListIteratorTest.assertEquals((String)"c", (String)((String)loop.previous()));
        LoopingListIteratorTest.assertEquals((String)"c", (String)((String)loop.next()));
        loop.add((Object)"d");
        loop.reset();
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"c", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"d", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"e", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"f", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        list = new ArrayList<String>(Arrays.asList("b", "e", "f"));
        loop = new LoopingListIterator(list);
        loop.add((Object)"a");
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.previous()));
        loop.reset();
        LoopingListIteratorTest.assertEquals((String)"f", (String)((String)loop.previous()));
        LoopingListIteratorTest.assertEquals((String)"e", (String)((String)loop.previous()));
        loop.add((Object)"d");
        LoopingListIteratorTest.assertEquals((String)"d", (String)((String)loop.previous()));
        loop.add((Object)"c");
        LoopingListIteratorTest.assertEquals((String)"c", (String)((String)loop.previous()));
        loop.reset();
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"c", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"d", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"e", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"f", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
    }

    public void testNextAndPreviousIndex() {
        List<String> list = Arrays.asList("a", "b", "c");
        LoopingListIterator loop = new LoopingListIterator(list);
        LoopingListIteratorTest.assertEquals((int)0, (int)loop.nextIndex());
        LoopingListIteratorTest.assertEquals((int)2, (int)loop.previousIndex());
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((int)1, (int)loop.nextIndex());
        LoopingListIteratorTest.assertEquals((int)0, (int)loop.previousIndex());
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.previous()));
        LoopingListIteratorTest.assertEquals((int)0, (int)loop.nextIndex());
        LoopingListIteratorTest.assertEquals((int)2, (int)loop.previousIndex());
        LoopingListIteratorTest.assertEquals((String)"c", (String)((String)loop.previous()));
        LoopingListIteratorTest.assertEquals((int)2, (int)loop.nextIndex());
        LoopingListIteratorTest.assertEquals((int)1, (int)loop.previousIndex());
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.previous()));
        LoopingListIteratorTest.assertEquals((int)1, (int)loop.nextIndex());
        LoopingListIteratorTest.assertEquals((int)0, (int)loop.previousIndex());
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.previous()));
        LoopingListIteratorTest.assertEquals((int)0, (int)loop.nextIndex());
        LoopingListIteratorTest.assertEquals((int)2, (int)loop.previousIndex());
    }

    public void testSet() {
        List<String> list = Arrays.asList("q", "r", "z");
        LoopingListIterator loop = new LoopingListIterator(list);
        LoopingListIteratorTest.assertEquals((String)"z", (String)((String)loop.previous()));
        loop.set((Object)"c");
        loop.reset();
        LoopingListIteratorTest.assertEquals((String)"q", (String)((String)loop.next()));
        loop.set((Object)"a");
        LoopingListIteratorTest.assertEquals((String)"r", (String)((String)loop.next()));
        loop.set((Object)"b");
        loop.reset();
        LoopingListIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"b", (String)((String)loop.next()));
        LoopingListIteratorTest.assertEquals((String)"c", (String)((String)loop.next()));
    }
}

