/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.Iterator;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.NodeListIterator;
import org.easymock.EasyMock;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeListIteratorTest
extends AbstractIteratorTest<Node> {
    private Node[] nodes;
    private boolean createIteratorWithStandardConstr = true;

    public NodeListIteratorTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.createIteratorWithStandardConstr = true;
        Node node1 = (Node)EasyMock.createMock(Element.class);
        Node node2 = (Node)EasyMock.createMock(Element.class);
        Node node3 = (Node)EasyMock.createMock(Text.class);
        Node node4 = (Node)EasyMock.createMock(Element.class);
        this.nodes = new Node[]{node1, node2, node3, node4};
        EasyMock.replay((Object[])new Object[]{node1});
        EasyMock.replay((Object[])new Object[]{node2});
        EasyMock.replay((Object[])new Object[]{node3});
        EasyMock.replay((Object[])new Object[]{node4});
    }

    @Override
    public Iterator<Node> makeEmptyIterator() {
        NodeList emptyNodeList = new NodeList(){

            public Node item(int index) {
                throw new IndexOutOfBoundsException();
            }

            public int getLength() {
                return 0;
            }
        };
        if (this.createIteratorWithStandardConstr) {
            return new NodeListIterator(emptyNodeList);
        }
        Node parentNode = (Node)EasyMock.createMock(Node.class);
        EasyMock.expect((Object)parentNode.getChildNodes()).andStubReturn((Object)emptyNodeList);
        EasyMock.replay((Object[])new Object[]{parentNode});
        return new NodeListIterator(parentNode);
    }

    @Override
    public Iterator<Node> makeObject() {
        NodeList nodeList = new NodeList(){

            public Node item(int index) {
                return NodeListIteratorTest.this.nodes[index];
            }

            public int getLength() {
                return NodeListIteratorTest.this.nodes.length;
            }
        };
        return new NodeListIterator(nodeList);
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    public void testNullConstructor() {
        try {
            new NodeListIterator((Node)null);
            NodeListIteratorTest.fail((String)"IllegalArgumentException expected!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEmptyIteratorWithNodeConstructor() {
        this.createIteratorWithStandardConstr = false;
        this.testEmptyIterator();
    }

    public void testFullIteratorWithNodeConstructor() {
        this.createIteratorWithStandardConstr = false;
        this.testFullIterator();
    }
}

