/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.SingletonIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonIteratorTest<E>
extends AbstractIteratorTest<E> {
    private static final Object testValue = "foo";

    public SingletonIteratorTest(String testName) {
        super(testName);
    }

    @Override
    public SingletonIterator<E> makeEmptyIterator() {
        SingletonIterator<E> iter = this.makeObject();
        iter.next();
        iter.remove();
        iter.reset();
        return iter;
    }

    @Override
    public SingletonIterator<E> makeObject() {
        return new SingletonIterator(testValue);
    }

    @Override
    public boolean supportsRemove() {
        return true;
    }

    @Override
    public boolean supportsEmptyIterator() {
        return true;
    }

    public void testIterator() {
        SingletonIterator<E> iter = this.makeObject();
        SingletonIteratorTest.assertTrue((String)"Iterator has a first item", (boolean)iter.hasNext());
        Object iterValue = iter.next();
        SingletonIteratorTest.assertEquals((String)"Iteration value is correct", (Object)testValue, iterValue);
        SingletonIteratorTest.assertTrue((String)"Iterator should now be empty", (!iter.hasNext() ? 1 : 0) != 0);
        try {
            iter.next();
        }
        catch (Exception e) {
            SingletonIteratorTest.assertTrue((String)"NoSuchElementException must be thrown", (boolean)e.getClass().equals(new NoSuchElementException().getClass()));
        }
    }

    public void testSingletonIteratorRemove() {
        SingletonIterator iter = new SingletonIterator((Object)"xyzzy");
        SingletonIteratorTest.assertTrue((boolean)iter.hasNext());
        SingletonIteratorTest.assertEquals((Object)"xyzzy", (Object)iter.next());
        iter.remove();
        iter.reset();
        SingletonIteratorTest.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
    }

    public void testReset() {
        SingletonIterator<E> it = this.makeObject();
        SingletonIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        SingletonIteratorTest.assertEquals((Object)testValue, (Object)it.next());
        SingletonIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
        it.reset();
        SingletonIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        SingletonIteratorTest.assertEquals((Object)testValue, (Object)it.next());
        SingletonIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
        it.reset();
        it.reset();
        SingletonIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
    }
}

