/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.UniqueFilterIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueFilterIteratorTest<E>
extends AbstractIteratorTest<E> {
    protected String[] testArray = new String[]{"One", "Two", "Three", "Four", "Five", "Six"};
    protected List<E> list1 = null;

    public UniqueFilterIteratorTest(String testName) {
        super(testName);
    }

    public void setUp() {
        this.list1 = new ArrayList();
        this.list1.add("One");
        this.list1.add("Two");
        this.list1.add("Three");
        this.list1.add("Two");
        this.list1.add("One");
        this.list1.add("Four");
        this.list1.add("Five");
        this.list1.add("Five");
        this.list1.add("Six");
        this.list1.add("Five");
    }

    @Override
    public UniqueFilterIterator<E> makeEmptyIterator() {
        ArrayList list = new ArrayList();
        return new UniqueFilterIterator(list.iterator());
    }

    @Override
    public UniqueFilterIterator<E> makeObject() {
        Iterator<E> i = this.list1.iterator();
        return new UniqueFilterIterator(i);
    }

    public void testIterator() {
        UniqueFilterIterator<E> iter = this.makeObject();
        for (String testValue : this.testArray) {
            Object iterValue = iter.next();
            UniqueFilterIteratorTest.assertEquals((String)"Iteration value is correct", (Object)testValue, iterValue);
        }
        UniqueFilterIteratorTest.assertTrue((String)"Iterator should now be empty", (!iter.hasNext() ? 1 : 0) != 0);
        try {
            iter.next();
        }
        catch (Exception e) {
            UniqueFilterIteratorTest.assertTrue((String)"NoSuchElementException must be thrown", (boolean)e.getClass().equals(new NoSuchElementException().getClass()));
        }
    }
}

