/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.keyvalue;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.collections4.KeyValue;
import org.apache.commons.collections4.keyvalue.DefaultKeyValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultKeyValueTest<K, V>
extends TestCase {
    private final String key = "name";
    private final String value = "duke";

    protected DefaultKeyValue<K, V> makeDefaultKeyValue() {
        return new DefaultKeyValue(null, null);
    }

    protected DefaultKeyValue<K, V> makeDefaultKeyValue(K key, V value) {
        return new DefaultKeyValue(key, value);
    }

    public void testAccessorsAndMutators() {
        DefaultKeyValue<K, V> kv = this.makeDefaultKeyValue();
        kv.setKey((Object)"name");
        DefaultKeyValueTest.assertTrue((kv.getKey() == "name" ? 1 : 0) != 0);
        kv.setValue((Object)"duke");
        DefaultKeyValueTest.assertTrue((kv.getValue() == "duke" ? 1 : 0) != 0);
        kv.setKey(null);
        DefaultKeyValueTest.assertTrue((kv.getKey() == null ? 1 : 0) != 0);
        kv.setValue(null);
        DefaultKeyValueTest.assertTrue((kv.getValue() == null ? 1 : 0) != 0);
    }

    public void testSelfReferenceHandling() {
        DefaultKeyValue<K, V> kv = this.makeDefaultKeyValue();
        try {
            kv.setKey(kv);
            DefaultKeyValueTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            DefaultKeyValueTest.assertTrue((kv.getKey() == null && kv.getValue() == null ? 1 : 0) != 0);
        }
        try {
            kv.setValue(kv);
            DefaultKeyValueTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            DefaultKeyValueTest.assertTrue((kv.getKey() == null && kv.getValue() == null ? 1 : 0) != 0);
        }
    }

    public void testConstructors() {
        DefaultKeyValue kv = new DefaultKeyValue();
        DefaultKeyValueTest.assertTrue((kv.getKey() == null && kv.getValue() == null ? 1 : 0) != 0);
        kv = new DefaultKeyValue((Object)"name", (Object)"duke");
        DefaultKeyValueTest.assertTrue((kv.getKey() == "name" && kv.getValue() == "duke" ? 1 : 0) != 0);
        DefaultKeyValue kv2 = new DefaultKeyValue((KeyValue)kv);
        DefaultKeyValueTest.assertTrue((kv2.getKey() == "name" && kv2.getValue() == "duke" ? 1 : 0) != 0);
        kv.setKey(null);
        kv.setValue(null);
        DefaultKeyValueTest.assertTrue((kv2.getKey() == "name" && kv2.getValue() == "duke" ? 1 : 0) != 0);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "duke");
        Map.Entry entry = map.entrySet().iterator().next();
        kv = new DefaultKeyValue(entry);
        DefaultKeyValueTest.assertTrue((kv.getKey() == "name" && kv.getValue() == "duke" ? 1 : 0) != 0);
        entry.setValue(null);
        DefaultKeyValueTest.assertTrue((kv.getValue() == "duke" ? 1 : 0) != 0);
    }

    public void testEqualsAndHashCode() {
        DefaultKeyValue<String, String> kv = this.makeDefaultKeyValue("name", "duke");
        DefaultKeyValue<String, String> kv2 = this.makeDefaultKeyValue("name", "duke");
        DefaultKeyValueTest.assertTrue((boolean)kv.equals(kv));
        DefaultKeyValueTest.assertTrue((boolean)kv.equals(kv2));
        DefaultKeyValueTest.assertTrue((kv.hashCode() == kv2.hashCode() ? 1 : 0) != 0);
        kv = this.makeDefaultKeyValue(null, null);
        kv2 = this.makeDefaultKeyValue(null, null);
        DefaultKeyValueTest.assertTrue((boolean)kv.equals(kv));
        DefaultKeyValueTest.assertTrue((boolean)kv.equals(kv2));
        DefaultKeyValueTest.assertTrue((kv.hashCode() == kv2.hashCode() ? 1 : 0) != 0);
    }

    public void testToString() {
        DefaultKeyValue<String, String> kv = this.makeDefaultKeyValue("name", "duke");
        DefaultKeyValueTest.assertTrue((boolean)kv.toString().equals(kv.getKey() + "=" + kv.getValue()));
        kv = this.makeDefaultKeyValue(null, null);
        DefaultKeyValueTest.assertTrue((boolean)kv.toString().equals(kv.getKey() + "=" + kv.getValue()));
    }

    public void testToMapEntry() {
        DefaultKeyValue<String, String> kv = this.makeDefaultKeyValue("name", "duke");
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(kv.getKey(), kv.getValue());
        Map.Entry entry = map.entrySet().iterator().next();
        DefaultKeyValueTest.assertTrue((boolean)entry.equals(kv.toMapEntry()));
        DefaultKeyValueTest.assertTrue((entry.hashCode() == kv.hashCode() ? 1 : 0) != 0);
    }
}

