/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.keyvalue;

import java.util.Map;
import org.apache.commons.collections4.keyvalue.AbstractMapEntryTest;
import org.apache.commons.collections4.keyvalue.DefaultKeyValue;
import org.apache.commons.collections4.keyvalue.DefaultMapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMapEntryTest<K, V>
extends AbstractMapEntryTest<K, V> {
    @Override
    public Map.Entry<K, V> makeMapEntry() {
        return new DefaultMapEntry(null, null);
    }

    @Override
    public Map.Entry<K, V> makeMapEntry(K key, V value) {
        return new DefaultMapEntry(key, value);
    }

    @Override
    public void testConstructors() {
        DefaultMapEntry entry = new DefaultMapEntry((Object)"name", (Object)"duke");
        DefaultMapEntryTest.assertSame((Object)"name", entry.getKey());
        DefaultMapEntryTest.assertSame((Object)"duke", entry.getValue());
        DefaultKeyValue pair = new DefaultKeyValue((Object)"name", (Object)"duke");
        DefaultMapEntryTest.assertSame((Object)"name", (Object)pair.getKey());
        DefaultMapEntryTest.assertSame((Object)"duke", (Object)pair.getValue());
        DefaultMapEntry entry2 = new DefaultMapEntry((Map.Entry)entry);
        DefaultMapEntryTest.assertSame((Object)"name", entry2.getKey());
        DefaultMapEntryTest.assertSame((Object)"duke", entry2.getValue());
        entry.setValue(null);
        DefaultMapEntryTest.assertSame((Object)"duke", entry2.getValue());
    }

    @Override
    public void testSelfReferenceHandling() {
        Map.Entry<K, Map.Entry<K, V>> entry = this.makeMapEntry();
        try {
            entry.setValue(entry);
            DefaultMapEntryTest.assertSame(entry, entry.getValue());
        }
        catch (Exception e) {
            DefaultMapEntryTest.fail((String)"This Map.Entry implementation supports value self-reference.");
        }
    }
}

