/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.list.AbstractListTest;
import org.apache.commons.collections4.list.GrowthList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrowthListTest<E>
extends AbstractListTest<E> {
    public GrowthListTest(String testName) {
        super(testName);
    }

    @Override
    public List<E> makeObject() {
        return new GrowthList();
    }

    @Override
    public List<E> makeFullCollection() {
        ArrayList list = new ArrayList();
        list.addAll(Arrays.asList(this.getFullElements()));
        return GrowthList.growthList(list);
    }

    public void testGrowthAdd() {
        Integer one = 1;
        GrowthList grower = new GrowthList();
        GrowthListTest.assertEquals((int)0, (int)grower.size());
        grower.add(1, (Object)one);
        GrowthListTest.assertEquals((int)2, (int)grower.size());
        GrowthListTest.assertEquals(null, (Object)grower.get(0));
        GrowthListTest.assertEquals((Object)one, (Object)grower.get(1));
    }

    public void testGrowthAddAll() {
        Integer one = 1;
        Integer two = 2;
        ArrayList<Integer> coll = new ArrayList<Integer>();
        coll.add(one);
        coll.add(two);
        GrowthList grower = new GrowthList();
        GrowthListTest.assertEquals((int)0, (int)grower.size());
        grower.addAll(1, coll);
        GrowthListTest.assertEquals((int)3, (int)grower.size());
        GrowthListTest.assertEquals(null, (Object)grower.get(0));
        GrowthListTest.assertEquals((Object)one, (Object)grower.get(1));
        GrowthListTest.assertEquals((Object)two, (Object)grower.get(2));
    }

    public void testGrowthSet1() {
        Integer one = 1;
        GrowthList grower = new GrowthList();
        GrowthListTest.assertEquals((int)0, (int)grower.size());
        grower.set(1, (Object)one);
        GrowthListTest.assertEquals((int)2, (int)grower.size());
        GrowthListTest.assertEquals(null, (Object)grower.get(0));
        GrowthListTest.assertEquals((Object)one, (Object)grower.get(1));
    }

    public void testGrowthSet2() {
        Integer one = 1;
        GrowthList grower = new GrowthList();
        GrowthListTest.assertEquals((int)0, (int)grower.size());
        grower.set(0, (Object)one);
        GrowthListTest.assertEquals((int)1, (int)grower.size());
        GrowthListTest.assertEquals((Object)one, (Object)grower.get(0));
    }

    @Override
    public void testListAddByIndexBoundsChecking() {
        Object element = this.getOtherElements()[0];
        try {
            Collection list = this.makeObject();
            list.add(-1, element);
            GrowthListTest.fail((String)"List.add should throw IndexOutOfBoundsException [-1]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public void testListAddByIndexBoundsChecking2() {
        Object element = this.getOtherElements()[0];
        try {
            Collection list = this.makeFullCollection();
            list.add(-1, element);
            GrowthListTest.fail((String)"List.add should throw IndexOutOfBoundsException [-1]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public void testListSetByIndexBoundsChecking() {
        Collection list = this.makeObject();
        Object element = this.getOtherElements()[0];
        try {
            list.set(-1, element);
            GrowthListTest.fail((String)"List.set should throw IndexOutOfBoundsException [-1]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public void testListSetByIndexBoundsChecking2() {
        Collection list = this.makeFullCollection();
        Object element = this.getOtherElements()[0];
        try {
            list.set(-1, element);
            GrowthListTest.fail((String)"List.set should throw IndexOutOfBoundsException [-1]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

