/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections4.collection.TransformedCollectionTest;
import org.apache.commons.collections4.list.AbstractListTest;
import org.apache.commons.collections4.list.TransformedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformedListTest<E>
extends AbstractListTest<E> {
    public TransformedListTest(String testName) {
        super(testName);
    }

    @Override
    public List<E> makeConfirmedCollection() {
        return new ArrayList();
    }

    @Override
    public List<E> makeConfirmedFullCollection() {
        ArrayList list = new ArrayList();
        list.addAll(Arrays.asList(this.getFullElements()));
        return list;
    }

    @Override
    public List<E> makeObject() {
        return TransformedList.transformingList(new ArrayList(), TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    @Override
    public List<E> makeFullCollection() {
        ArrayList list = new ArrayList();
        list.addAll(Arrays.asList(this.getFullElements()));
        return TransformedList.transformingList(list, TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    public void testTransformedList() {
        int i;
        TransformedList list = TransformedList.transformingList(new ArrayList(), TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedListTest.assertEquals((int)0, (int)list.size());
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        for (i = 0; i < els.length; ++i) {
            list.add(els[i]);
            TransformedListTest.assertEquals((int)(i + 1), (int)list.size());
            TransformedListTest.assertEquals((boolean)true, (boolean)list.contains(Integer.valueOf((String)els[i])));
            TransformedListTest.assertEquals((boolean)false, (boolean)list.contains(els[i]));
        }
        TransformedListTest.assertEquals((boolean)false, (boolean)list.remove(els[0]));
        TransformedListTest.assertEquals((boolean)true, (boolean)list.remove(Integer.valueOf((String)els[0])));
        list.clear();
        for (i = 0; i < els.length; ++i) {
            list.add(0, els[i]);
            TransformedListTest.assertEquals((int)(i + 1), (int)list.size());
            TransformedListTest.assertEquals((Object)Integer.valueOf((String)els[i]), list.get(0));
        }
        list.set(0, "22");
        TransformedListTest.assertEquals((Object)22, list.get(0));
        ListIterator<String> it = list.listIterator();
        it.next();
        it.set("33");
        TransformedListTest.assertEquals((Object)33, list.get(0));
        it.add("44");
        TransformedListTest.assertEquals((Object)44, list.get(1));
        ArrayList<String> adds = new ArrayList<String>();
        adds.add("1");
        adds.add("2");
        list.clear();
        list.addAll(adds);
        TransformedListTest.assertEquals((Object)1, list.get(0));
        TransformedListTest.assertEquals((Object)2, list.get(1));
        adds.clear();
        adds.add("3");
        list.addAll(1, adds);
        TransformedListTest.assertEquals((Object)1, list.get(0));
        TransformedListTest.assertEquals((Object)3, list.get(1));
        TransformedListTest.assertEquals((Object)2, list.get(2));
    }

    public void testTransformedList_decorateTransform() {
        Object[] els;
        ArrayList<Object> originalList = new ArrayList<Object>();
        for (Object el : els = new Object[]{"1", "3", "5", "7", "2", "4", "6"}) {
            originalList.add(el);
        }
        TransformedList list = TransformedList.transformedList(originalList, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedListTest.assertEquals((int)els.length, (int)list.size());
        for (Object el : els) {
            TransformedListTest.assertEquals((boolean)true, (boolean)list.contains(Integer.valueOf((String)el)));
            TransformedListTest.assertEquals((boolean)false, (boolean)list.contains(el));
        }
        TransformedListTest.assertEquals((boolean)false, (boolean)list.remove(els[0]));
        TransformedListTest.assertEquals((boolean)true, (boolean)list.remove(Integer.valueOf((String)els[0])));
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

