/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.OrderedMap;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.comparators.NullComparator;
import org.apache.commons.collections4.iterators.AbstractOrderedMapIteratorTest;
import org.apache.commons.collections4.map.AbstractIterableMapTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrderedMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    public AbstractOrderedMapTest(String testName) {
        super(testName);
    }

    @Override
    public abstract OrderedMap<K, V> makeObject();

    @Override
    public OrderedMap<K, V> makeFullMap() {
        return (OrderedMap)super.makeFullMap();
    }

    @Override
    public Map<K, V> makeConfirmedMap() {
        return new TreeMap(new NullComparator());
    }

    @Override
    public K[] getSampleKeys() {
        ArrayList list = new ArrayList(Arrays.asList(super.getSampleKeys()));
        Collections.sort(list, new NullComparator());
        return list.toArray();
    }

    public void testFirstKey() {
        this.resetEmpty();
        OrderedMap<K, V> ordered = this.getMap();
        try {
            ordered.firstKey();
            AbstractOrderedMapTest.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        this.resetFull();
        ordered = this.getMap();
        Object confirmedFirst = this.confirmed.keySet().iterator().next();
        AbstractOrderedMapTest.assertEquals(confirmedFirst, (Object)ordered.firstKey());
    }

    public void testLastKey() {
        this.resetEmpty();
        OrderedMap<K, V> ordered = this.getMap();
        try {
            ordered.lastKey();
            AbstractOrderedMapTest.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        this.resetFull();
        ordered = this.getMap();
        Object confirmedLast2 = null;
        for (Object confirmedLast2 : this.confirmed.keySet()) {
        }
        AbstractOrderedMapTest.assertEquals(confirmedLast2, (Object)ordered.lastKey());
    }

    public void testNextKey() {
        this.resetEmpty();
        OrderedMap<K, V> ordered = this.getMap();
        AbstractOrderedMapTest.assertEquals(null, (Object)ordered.nextKey(this.getOtherKeys()[0]));
        if (!this.isAllowNullKey()) {
            try {
                AbstractOrderedMapTest.assertEquals(null, (Object)ordered.nextKey(null));
            }
            catch (NullPointerException ex) {}
        } else {
            AbstractOrderedMapTest.assertEquals(null, (Object)ordered.nextKey(null));
        }
        this.resetFull();
        ordered = this.getMap();
        Iterator it = this.confirmed.keySet().iterator();
        Object confirmedLast = it.next();
        while (it.hasNext()) {
            Object confirmedObject = it.next();
            AbstractOrderedMapTest.assertEquals(confirmedObject, (Object)ordered.nextKey(confirmedLast));
            confirmedLast = confirmedObject;
        }
        AbstractOrderedMapTest.assertEquals(null, (Object)ordered.nextKey(confirmedLast));
        if (!this.isAllowNullKey()) {
            try {
                ordered.nextKey(null);
                AbstractOrderedMapTest.fail();
            }
            catch (NullPointerException ex) {}
        } else {
            AbstractOrderedMapTest.assertEquals(null, (Object)ordered.nextKey(null));
        }
    }

    public void testPreviousKey() {
        this.resetEmpty();
        OrderedMap<K, V> ordered = this.getMap();
        AbstractOrderedMapTest.assertEquals(null, (Object)ordered.previousKey(this.getOtherKeys()[0]));
        if (!this.isAllowNullKey()) {
            try {
                AbstractOrderedMapTest.assertEquals(null, (Object)ordered.previousKey(null));
            }
            catch (NullPointerException ex) {}
        } else {
            AbstractOrderedMapTest.assertEquals(null, (Object)ordered.previousKey(null));
        }
        this.resetFull();
        ordered = this.getMap();
        ArrayList list = new ArrayList(this.confirmed.keySet());
        Collections.reverse(list);
        Iterator it = list.iterator();
        Object confirmedLast = it.next();
        while (it.hasNext()) {
            Object confirmedObject = it.next();
            AbstractOrderedMapTest.assertEquals(confirmedObject, (Object)ordered.previousKey(confirmedLast));
            confirmedLast = confirmedObject;
        }
        AbstractOrderedMapTest.assertEquals(null, (Object)ordered.previousKey(confirmedLast));
        if (!this.isAllowNullKey()) {
            try {
                ordered.previousKey(null);
                AbstractOrderedMapTest.fail();
            }
            catch (NullPointerException ex) {}
        } else if (!this.isAllowNullKey()) {
            AbstractOrderedMapTest.assertEquals(null, (Object)ordered.previousKey(null));
        }
    }

    public BulkTest bulkTestOrderedMapIterator() {
        return new InnerTestOrderedMapIterator();
    }

    @Override
    public OrderedMap<K, V> getMap() {
        return (OrderedMap)super.getMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InnerTestOrderedMapIterator
    extends AbstractOrderedMapIteratorTest<K, V> {
        public InnerTestOrderedMapIterator() {
            super("InnerTestOrderedMapIterator");
        }

        @Override
        public boolean supportsRemove() {
            return AbstractOrderedMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean isGetStructuralModify() {
            return AbstractOrderedMapTest.this.isGetStructuralModify();
        }

        @Override
        public boolean supportsSetValue() {
            return AbstractOrderedMapTest.this.isSetValueSupported();
        }

        @Override
        public OrderedMapIterator<K, V> makeEmptyIterator() {
            AbstractOrderedMapTest.this.resetEmpty();
            return AbstractOrderedMapTest.this.getMap().mapIterator();
        }

        @Override
        public OrderedMapIterator<K, V> makeObject() {
            AbstractOrderedMapTest.this.resetFull();
            return AbstractOrderedMapTest.this.getMap().mapIterator();
        }

        @Override
        public OrderedMap<K, V> getMap() {
            return AbstractOrderedMapTest.this.getMap();
        }

        @Override
        public Map<K, V> getConfirmedMap() {
            return AbstractOrderedMapTest.this.getConfirmed();
        }

        @Override
        public void verify() {
            super.verify();
            AbstractOrderedMapTest.this.verify();
        }
    }
}

