/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.FactoryUtils;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.functors.ConstantFactory;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.DefaultedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultedMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    protected final Factory<V> nullFactory = FactoryUtils.nullFactory();

    public DefaultedMapTest(String testName) {
        super(testName);
    }

    @Override
    public IterableMap<K, V> makeObject() {
        return DefaultedMap.defaultedMap(new HashMap(), this.nullFactory);
    }

    @Override
    public void testMapGet() {
        DefaultedMap map = new DefaultedMap((Object)"NULL");
        DefaultedMapTest.assertEquals((int)0, (int)map.size());
        DefaultedMapTest.assertEquals((boolean)false, (boolean)map.containsKey("NotInMap"));
        DefaultedMapTest.assertEquals((Object)"NULL", map.get("NotInMap"));
        map.put("Key", "Value");
        DefaultedMapTest.assertEquals((int)1, (int)map.size());
        DefaultedMapTest.assertEquals((boolean)true, (boolean)map.containsKey("Key"));
        DefaultedMapTest.assertEquals((Object)"Value", map.get("Key"));
        DefaultedMapTest.assertEquals((boolean)false, (boolean)map.containsKey("NotInMap"));
        DefaultedMapTest.assertEquals((Object)"NULL", map.get("NotInMap"));
    }

    public void testMapGet2() {
        HashMap base = new HashMap();
        DefaultedMap map = DefaultedMap.defaultedMap(base, (Object)"NULL");
        DefaultedMapTest.assertEquals((int)0, (int)map.size());
        DefaultedMapTest.assertEquals((int)0, (int)base.size());
        DefaultedMapTest.assertEquals((boolean)false, (boolean)map.containsKey("NotInMap"));
        DefaultedMapTest.assertEquals((Object)"NULL", map.get("NotInMap"));
        map.put("Key", "Value");
        DefaultedMapTest.assertEquals((int)1, (int)map.size());
        DefaultedMapTest.assertEquals((int)1, (int)base.size());
        DefaultedMapTest.assertEquals((boolean)true, (boolean)map.containsKey("Key"));
        DefaultedMapTest.assertEquals((Object)"Value", map.get("Key"));
        DefaultedMapTest.assertEquals((boolean)false, (boolean)map.containsKey("NotInMap"));
        DefaultedMapTest.assertEquals((Object)"NULL", map.get("NotInMap"));
    }

    public void testMapGet3() {
        HashMap base = new HashMap();
        DefaultedMap map = DefaultedMap.defaultedMap(base, (Factory)ConstantFactory.constantFactory((Object)"NULL"));
        DefaultedMapTest.assertEquals((int)0, (int)map.size());
        DefaultedMapTest.assertEquals((int)0, (int)base.size());
        DefaultedMapTest.assertEquals((boolean)false, (boolean)map.containsKey("NotInMap"));
        DefaultedMapTest.assertEquals((Object)"NULL", map.get("NotInMap"));
        map.put("Key", "Value");
        DefaultedMapTest.assertEquals((int)1, (int)map.size());
        DefaultedMapTest.assertEquals((int)1, (int)base.size());
        DefaultedMapTest.assertEquals((boolean)true, (boolean)map.containsKey("Key"));
        DefaultedMapTest.assertEquals((Object)"Value", map.get("Key"));
        DefaultedMapTest.assertEquals((boolean)false, (boolean)map.containsKey("NotInMap"));
        DefaultedMapTest.assertEquals((Object)"NULL", map.get("NotInMap"));
    }

    public void testMapGet4() {
        HashMap base = new HashMap();
        Map map = DefaultedMap.defaultedMap(base, (Transformer)new Transformer<K, V>(){

            public V transform(K input) {
                if (input instanceof String) {
                    return "NULL";
                }
                return "NULL_OBJECT";
            }
        });
        DefaultedMapTest.assertEquals((int)0, (int)map.size());
        DefaultedMapTest.assertEquals((int)0, (int)base.size());
        DefaultedMapTest.assertEquals((boolean)false, (boolean)map.containsKey("NotInMap"));
        DefaultedMapTest.assertEquals((Object)"NULL", map.get("NotInMap"));
        DefaultedMapTest.assertEquals((Object)"NULL_OBJECT", map.get(0));
        map.put("Key", "Value");
        DefaultedMapTest.assertEquals((int)1, (int)map.size());
        DefaultedMapTest.assertEquals((int)1, (int)base.size());
        DefaultedMapTest.assertEquals((boolean)true, (boolean)map.containsKey("Key"));
        DefaultedMapTest.assertEquals((Object)"Value", map.get("Key"));
        DefaultedMapTest.assertEquals((boolean)false, (boolean)map.containsKey("NotInMap"));
        DefaultedMapTest.assertEquals((Object)"NULL", map.get("NotInMap"));
        DefaultedMapTest.assertEquals((Object)"NULL_OBJECT", map.get(0));
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

