/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.ResettableIterator;
import org.apache.commons.collections4.list.AbstractListTest;
import org.apache.commons.collections4.map.AbstractOrderedMapTest;
import org.apache.commons.collections4.map.LinkedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedMapTest<K, V>
extends AbstractOrderedMapTest<K, V> {
    public LinkedMapTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(LinkedMapTest.class);
    }

    @Override
    public LinkedMap<K, V> makeObject() {
        return new LinkedMap();
    }

    @Override
    public LinkedMap<K, V> makeFullMap() {
        return (LinkedMap)super.makeFullMap();
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    public void testReset() {
        this.resetEmpty();
        LinkedMap<K, V> ordered = this.getMap();
        ((ResettableIterator)ordered.mapIterator()).reset();
        this.resetFull();
        ordered = this.getMap();
        ArrayList list = new ArrayList(ordered.keySet());
        ResettableIterator it = (ResettableIterator)ordered.mapIterator();
        LinkedMapTest.assertSame(list.get(0), (Object)it.next());
        LinkedMapTest.assertSame(list.get(1), (Object)it.next());
        it.reset();
        LinkedMapTest.assertSame(list.get(0), (Object)it.next());
    }

    public void testInsertionOrder() {
        if (!this.isPutAddSupported() || !this.isPutChangeSupported()) {
            return;
        }
        K[] keys = this.getSampleKeys();
        V[] values = this.getSampleValues();
        this.resetEmpty();
        this.map.put(keys[0], values[0]);
        this.map.put(keys[1], values[1]);
        Iterator keyIter = this.map.keySet().iterator();
        LinkedMapTest.assertSame(keys[0], keyIter.next());
        LinkedMapTest.assertSame(keys[1], keyIter.next());
        Iterator valueIter = this.map.values().iterator();
        LinkedMapTest.assertSame(values[0], valueIter.next());
        LinkedMapTest.assertSame(values[1], valueIter.next());
        this.map.put(keys[1], values[1]);
        keyIter = this.map.keySet().iterator();
        LinkedMapTest.assertSame(keys[0], keyIter.next());
        LinkedMapTest.assertSame(keys[1], keyIter.next());
        valueIter = this.map.values().iterator();
        LinkedMapTest.assertSame(values[0], valueIter.next());
        LinkedMapTest.assertSame(values[1], valueIter.next());
        this.map.put(keys[1], values[2]);
        keyIter = this.map.keySet().iterator();
        LinkedMapTest.assertSame(keys[0], keyIter.next());
        LinkedMapTest.assertSame(keys[1], keyIter.next());
        valueIter = this.map.values().iterator();
        LinkedMapTest.assertSame(values[0], valueIter.next());
        LinkedMapTest.assertSame(values[2], valueIter.next());
        this.map.put(keys[0], values[3]);
        keyIter = this.map.keySet().iterator();
        LinkedMapTest.assertSame(keys[0], keyIter.next());
        LinkedMapTest.assertSame(keys[1], keyIter.next());
        valueIter = this.map.values().iterator();
        LinkedMapTest.assertSame(values[3], valueIter.next());
        LinkedMapTest.assertSame(values[2], valueIter.next());
    }

    public void testGetByIndex() {
        this.resetEmpty();
        LinkedMap<K, V> lm = this.getMap();
        try {
            lm.get(0);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            lm.get(-1);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        this.resetFull();
        lm = this.getMap();
        try {
            lm.get(-1);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            lm.get(lm.size());
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        int i = 0;
        OrderedMapIterator it = lm.mapIterator();
        while (it.hasNext()) {
            LinkedMapTest.assertSame((Object)it.next(), (Object)lm.get(i));
            ++i;
        }
    }

    public void testGetValueByIndex() {
        this.resetEmpty();
        LinkedMap<K, V> lm = this.getMap();
        try {
            lm.getValue(0);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            lm.getValue(-1);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        this.resetFull();
        lm = this.getMap();
        try {
            lm.getValue(-1);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            lm.getValue(lm.size());
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        int i = 0;
        OrderedMapIterator it = lm.mapIterator();
        while (it.hasNext()) {
            it.next();
            LinkedMapTest.assertSame((Object)it.getValue(), (Object)lm.getValue(i));
            ++i;
        }
    }

    public void testIndexOf() {
        this.resetEmpty();
        LinkedMap<K, V> lm = this.getMap();
        LinkedMapTest.assertEquals((int)-1, (int)lm.indexOf(this.getOtherKeys()));
        this.resetFull();
        lm = this.getMap();
        ArrayList<Object> list = new ArrayList<Object>();
        OrderedMapIterator it = lm.mapIterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        for (int i = 0; i < list.size(); ++i) {
            LinkedMapTest.assertEquals((int)i, (int)lm.indexOf(list.get(i)));
        }
    }

    public void testRemoveByIndex() {
        this.resetEmpty();
        LinkedMap<K, V> lm = this.getMap();
        try {
            lm.remove(0);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            lm.remove(-1);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        this.resetFull();
        lm = this.getMap();
        try {
            lm.remove(-1);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            lm.remove(lm.size());
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        ArrayList<Object> list = new ArrayList<Object>();
        OrderedMapIterator it = lm.mapIterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        for (int i = 0; i < list.size(); ++i) {
            Object key = list.get(i);
            Object value = lm.get(key);
            LinkedMapTest.assertEquals((Object)value, (Object)lm.remove(i));
            list.remove(i);
            LinkedMapTest.assertEquals((boolean)false, (boolean)lm.containsKey(key));
        }
    }

    public BulkTest bulkTestListView() {
        return new TestListView();
    }

    public void testClone() {
        LinkedMap map = new LinkedMap(10);
        map.put((Object)"1", (Object)"1");
        LinkedMap cloned = map.clone();
        LinkedMapTest.assertEquals((int)map.size(), (int)cloned.size());
        LinkedMapTest.assertSame((Object)map.get((Object)"1"), cloned.get("1"));
    }

    @Override
    public LinkedMap<K, V> getMap() {
        return (LinkedMap)super.getMap();
    }

    public void testInitialCapacityZero() {
        LinkedMap map = new LinkedMap(0);
        LinkedMapTest.assertEquals((int)1, (int)map.data.length);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestListView
    extends AbstractListTest<K> {
        TestListView() {
            super("TestListView");
        }

        @Override
        public List<K> makeObject() {
            return LinkedMapTest.this.makeObject().asList();
        }

        @Override
        public List<K> makeFullCollection() {
            return LinkedMapTest.this.makeFullMap().asList();
        }

        @Override
        public K[] getFullElements() {
            return LinkedMapTest.this.getSampleKeys();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isRemoveSupported() {
            return false;
        }

        @Override
        public boolean isSetSupported() {
            return false;
        }

        @Override
        public boolean isNullSupported() {
            return LinkedMapTest.this.isAllowNullKey();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }
    }
}

