/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.AbstractObjectTest;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.map.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiValueMapTest<K, V>
extends AbstractObjectTest {
    public MultiValueMapTest(String testName) {
        super(testName);
    }

    public void testNoMappingReturnsNull() {
        MultiValueMap<K, V> map = this.createTestMap();
        MultiValueMapTest.assertNull((Object)map.get((Object)"whatever"));
    }

    public void testValueCollectionType() {
        MultiValueMap<K, V> map = this.createTestMap(LinkedList.class);
        MultiValueMapTest.assertTrue((boolean)(map.get((Object)"one") instanceof LinkedList));
    }

    public void testMultipleValues() {
        MultiValueMap<K, V> map = this.createTestMap(HashSet.class);
        HashSet<String> expected = new HashSet<String>();
        expected.add("uno");
        expected.add("un");
        MultiValueMapTest.assertEquals(expected, (Object)map.get((Object)"one"));
    }

    public void testContainsValue() {
        MultiValueMap<K, V> map = this.createTestMap(HashSet.class);
        MultiValueMapTest.assertTrue((boolean)map.containsValue((Object)"uno"));
        MultiValueMapTest.assertTrue((boolean)map.containsValue((Object)"un"));
        MultiValueMapTest.assertTrue((boolean)map.containsValue((Object)"dos"));
        MultiValueMapTest.assertTrue((boolean)map.containsValue((Object)"deux"));
        MultiValueMapTest.assertTrue((boolean)map.containsValue((Object)"tres"));
        MultiValueMapTest.assertTrue((boolean)map.containsValue((Object)"trois"));
        MultiValueMapTest.assertFalse((boolean)map.containsValue((Object)"quatro"));
    }

    public void testKeyContainsValue() {
        MultiValueMap<K, V> map = this.createTestMap(HashSet.class);
        MultiValueMapTest.assertTrue((boolean)map.containsValue((Object)"one", (Object)"uno"));
        MultiValueMapTest.assertTrue((boolean)map.containsValue((Object)"one", (Object)"un"));
        MultiValueMapTest.assertTrue((boolean)map.containsValue((Object)"two", (Object)"dos"));
        MultiValueMapTest.assertTrue((boolean)map.containsValue((Object)"two", (Object)"deux"));
        MultiValueMapTest.assertTrue((boolean)map.containsValue((Object)"three", (Object)"tres"));
        MultiValueMapTest.assertTrue((boolean)map.containsValue((Object)"three", (Object)"trois"));
        MultiValueMapTest.assertFalse((boolean)map.containsValue((Object)"four", (Object)"quatro"));
    }

    public void testValues() {
        MultiValueMap<K, V> map = this.createTestMap(HashSet.class);
        HashSet<String> expected = new HashSet<String>();
        expected.add("uno");
        expected.add("dos");
        expected.add("tres");
        expected.add("un");
        expected.add("deux");
        expected.add("trois");
        Collection c = map.values();
        MultiValueMapTest.assertEquals((int)6, (int)c.size());
        MultiValueMapTest.assertEquals(expected, new HashSet(c));
    }

    private MultiValueMap<K, V> createTestMap() {
        return this.createTestMap(ArrayList.class);
    }

    private <C extends Collection<V>> MultiValueMap<K, V> createTestMap(Class<C> collectionClass) {
        MultiValueMap map = MultiValueMap.multiValueMap(new HashMap(), collectionClass);
        map.put((Object)"one", (Object)"uno");
        map.put((Object)"one", (Object)"un");
        map.put((Object)"two", (Object)"dos");
        map.put((Object)"two", (Object)"deux");
        map.put((Object)"three", (Object)"tres");
        map.put((Object)"three", (Object)"trois");
        return map;
    }

    public void testKeyedIterator() {
        MultiValueMap<K, V> map = this.createTestMap();
        ArrayList actual = new ArrayList(IteratorUtils.toList((Iterator)map.iterator((Object)"one")));
        ArrayList<String> expected = new ArrayList<String>(Arrays.asList("uno", "un"));
        MultiValueMapTest.assertEquals(expected, actual);
    }

    public void testRemoveAllViaIterator() {
        MultiValueMap<K, V> map = this.createTestMap();
        Iterator i = map.values().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
        MultiValueMapTest.assertNull((Object)map.get((Object)"one"));
        MultiValueMapTest.assertTrue((boolean)map.isEmpty());
    }

    public void testRemoveAllViaKeyedIterator() {
        MultiValueMap<K, V> map = this.createTestMap();
        Iterator i = map.iterator((Object)"one");
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
        MultiValueMapTest.assertNull((Object)map.get((Object)"one"));
        MultiValueMapTest.assertEquals((int)4, (int)map.totalSize());
    }

    public void testIterator() {
        MultiValueMap<K, V> map = this.createTestMap();
        ArrayList values = new ArrayList(map.values());
        for (Map.Entry entry : map) {
            MultiValueMapTest.assertTrue((boolean)map.containsValue(entry.getKey(), entry.getValue()));
            MultiValueMapTest.assertTrue((boolean)values.contains(entry.getValue()));
            MultiValueMapTest.assertTrue((boolean)values.remove(entry.getValue()));
        }
        MultiValueMapTest.assertTrue((boolean)values.isEmpty());
    }

    public void testRemoveAllViaEntryIterator() {
        MultiValueMap<K, V> map = this.createTestMap();
        Iterator i = map.iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
        MultiValueMapTest.assertNull((Object)map.get((Object)"one"));
        MultiValueMapTest.assertEquals((int)0, (int)map.totalSize());
    }

    public void testTotalSizeA() {
        MultiValueMapTest.assertEquals((int)6, (int)this.createTestMap().totalSize());
    }

    public void testMapEquals() {
        MultiValueMap one = new MultiValueMap();
        Integer value = 1;
        one.put((Object)"One", (Object)value);
        one.removeMapping((Object)"One", (Object)value);
        MultiValueMap two = new MultiValueMap();
        MultiValueMapTest.assertEquals((Object)two, (Object)one);
    }

    public void testGetCollection() {
        MultiValueMap map = new MultiValueMap();
        map.put((Object)"A", (Object)"AA");
        MultiValueMapTest.assertSame((Object)map.get((Object)"A"), (Object)map.getCollection((Object)"A"));
    }

    public void testTotalSize() {
        MultiValueMap map = new MultiValueMap();
        MultiValueMapTest.assertEquals((int)0, (int)map.totalSize());
        map.put((Object)"A", (Object)"AA");
        MultiValueMapTest.assertEquals((int)1, (int)map.totalSize());
        map.put((Object)"B", (Object)"BA");
        MultiValueMapTest.assertEquals((int)2, (int)map.totalSize());
        map.put((Object)"B", (Object)"BB");
        MultiValueMapTest.assertEquals((int)3, (int)map.totalSize());
        map.put((Object)"B", (Object)"BC");
        MultiValueMapTest.assertEquals((int)4, (int)map.totalSize());
        map.remove((Object)"A");
        MultiValueMapTest.assertEquals((int)3, (int)map.totalSize());
        map.removeMapping((Object)"B", (Object)"BC");
        MultiValueMapTest.assertEquals((int)2, (int)map.totalSize());
    }

    public void testSize() {
        MultiValueMap map = new MultiValueMap();
        MultiValueMapTest.assertEquals((int)0, (int)map.size());
        map.put((Object)"A", (Object)"AA");
        MultiValueMapTest.assertEquals((int)1, (int)map.size());
        map.put((Object)"B", (Object)"BA");
        MultiValueMapTest.assertEquals((int)2, (int)map.size());
        map.put((Object)"B", (Object)"BB");
        MultiValueMapTest.assertEquals((int)2, (int)map.size());
        map.put((Object)"B", (Object)"BC");
        MultiValueMapTest.assertEquals((int)2, (int)map.size());
        map.remove((Object)"A");
        MultiValueMapTest.assertEquals((int)1, (int)map.size());
        map.removeMapping((Object)"B", (Object)"BC");
        MultiValueMapTest.assertEquals((int)1, (int)map.size());
    }

    public void testSize_Key() {
        MultiValueMap map = new MultiValueMap();
        MultiValueMapTest.assertEquals((int)0, (int)map.size((Object)"A"));
        MultiValueMapTest.assertEquals((int)0, (int)map.size((Object)"B"));
        map.put((Object)"A", (Object)"AA");
        MultiValueMapTest.assertEquals((int)1, (int)map.size((Object)"A"));
        MultiValueMapTest.assertEquals((int)0, (int)map.size((Object)"B"));
        map.put((Object)"B", (Object)"BA");
        MultiValueMapTest.assertEquals((int)1, (int)map.size((Object)"A"));
        MultiValueMapTest.assertEquals((int)1, (int)map.size((Object)"B"));
        map.put((Object)"B", (Object)"BB");
        MultiValueMapTest.assertEquals((int)1, (int)map.size((Object)"A"));
        MultiValueMapTest.assertEquals((int)2, (int)map.size((Object)"B"));
        map.put((Object)"B", (Object)"BC");
        MultiValueMapTest.assertEquals((int)1, (int)map.size((Object)"A"));
        MultiValueMapTest.assertEquals((int)3, (int)map.size((Object)"B"));
        map.remove((Object)"A");
        MultiValueMapTest.assertEquals((int)0, (int)map.size((Object)"A"));
        MultiValueMapTest.assertEquals((int)3, (int)map.size((Object)"B"));
        map.removeMapping((Object)"B", (Object)"BC");
        MultiValueMapTest.assertEquals((int)0, (int)map.size((Object)"A"));
        MultiValueMapTest.assertEquals((int)2, (int)map.size((Object)"B"));
    }

    public void testIterator_Key() {
        MultiValueMap map = new MultiValueMap();
        MultiValueMapTest.assertEquals((boolean)false, (boolean)map.iterator((Object)"A").hasNext());
        map.put((Object)"A", (Object)"AA");
        Iterator it = map.iterator((Object)"A");
        MultiValueMapTest.assertEquals((boolean)true, (boolean)it.hasNext());
        it.next();
        MultiValueMapTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testContainsValue_Key() {
        MultiValueMap map = new MultiValueMap();
        MultiValueMapTest.assertEquals((boolean)false, (boolean)map.containsValue((Object)"A", (Object)"AA"));
        MultiValueMapTest.assertEquals((boolean)false, (boolean)map.containsValue((Object)"B", (Object)"BB"));
        map.put((Object)"A", (Object)"AA");
        MultiValueMapTest.assertEquals((boolean)true, (boolean)map.containsValue((Object)"A", (Object)"AA"));
        MultiValueMapTest.assertEquals((boolean)false, (boolean)map.containsValue((Object)"A", (Object)"AB"));
    }

    public void testPutWithList() {
        MultiValueMap test = MultiValueMap.multiValueMap(new HashMap(), ArrayList.class);
        MultiValueMapTest.assertEquals((Object)"a", (Object)test.put((Object)"A", (Object)"a"));
        MultiValueMapTest.assertEquals((Object)"b", (Object)test.put((Object)"A", (Object)"b"));
        MultiValueMapTest.assertEquals((int)1, (int)test.size());
        MultiValueMapTest.assertEquals((int)2, (int)test.size((Object)"A"));
        MultiValueMapTest.assertEquals((int)2, (int)test.totalSize());
    }

    public void testPutWithSet() {
        MultiValueMap test = MultiValueMap.multiValueMap(new HashMap(), HashSet.class);
        MultiValueMapTest.assertEquals((Object)"a", (Object)test.put((Object)"A", (Object)"a"));
        MultiValueMapTest.assertEquals((Object)"b", (Object)test.put((Object)"A", (Object)"b"));
        MultiValueMapTest.assertEquals(null, (Object)test.put((Object)"A", (Object)"a"));
        MultiValueMapTest.assertEquals((int)1, (int)test.size());
        MultiValueMapTest.assertEquals((int)2, (int)test.size((Object)"A"));
        MultiValueMapTest.assertEquals((int)2, (int)test.totalSize());
    }

    public void testPutAll_Map1() {
        MultiValueMap original = new MultiValueMap();
        original.put((Object)"key", (Object)"object1");
        original.put((Object)"key", (Object)"object2");
        MultiValueMap test = new MultiValueMap();
        test.put((Object)"keyA", (Object)"objectA");
        test.put((Object)"key", (Object)"object0");
        test.putAll((Map)original);
        MultiValueMapTest.assertEquals((int)2, (int)test.size());
        MultiValueMapTest.assertEquals((int)4, (int)test.totalSize());
        MultiValueMapTest.assertEquals((int)1, (int)test.getCollection((Object)"keyA").size());
        MultiValueMapTest.assertEquals((int)3, (int)test.getCollection((Object)"key").size());
        MultiValueMapTest.assertEquals((boolean)true, (boolean)test.containsValue((Object)"objectA"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)test.containsValue((Object)"object0"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)test.containsValue((Object)"object1"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)test.containsValue((Object)"object2"));
    }

    public void testPutAll_Map2() {
        HashMap<String, String> original = new HashMap<String, String>();
        original.put("keyX", "object1");
        original.put("keyY", "object2");
        MultiValueMap test = new MultiValueMap();
        test.put((Object)"keyA", (Object)"objectA");
        test.put((Object)"keyX", (Object)"object0");
        test.putAll(original);
        MultiValueMapTest.assertEquals((int)3, (int)test.size());
        MultiValueMapTest.assertEquals((int)4, (int)test.totalSize());
        MultiValueMapTest.assertEquals((int)1, (int)test.getCollection((Object)"keyA").size());
        MultiValueMapTest.assertEquals((int)2, (int)test.getCollection((Object)"keyX").size());
        MultiValueMapTest.assertEquals((int)1, (int)test.getCollection((Object)"keyY").size());
        MultiValueMapTest.assertEquals((boolean)true, (boolean)test.containsValue((Object)"objectA"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)test.containsValue((Object)"object0"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)test.containsValue((Object)"object1"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)test.containsValue((Object)"object2"));
    }

    public void testPutAll_KeyCollection() {
        MultiValueMap map = new MultiValueMap();
        List<String> coll = Arrays.asList("X", "Y", "Z");
        MultiValueMapTest.assertEquals((boolean)true, (boolean)map.putAll((Object)"A", coll));
        MultiValueMapTest.assertEquals((int)3, (int)map.size((Object)"A"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)map.containsValue((Object)"A", (Object)"X"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)map.containsValue((Object)"A", (Object)"Y"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)map.containsValue((Object)"A", (Object)"Z"));
        MultiValueMapTest.assertEquals((boolean)false, (boolean)map.putAll((Object)"A", null));
        MultiValueMapTest.assertEquals((int)3, (int)map.size((Object)"A"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)map.containsValue((Object)"A", (Object)"X"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)map.containsValue((Object)"A", (Object)"Y"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)map.containsValue((Object)"A", (Object)"Z"));
        MultiValueMapTest.assertEquals((boolean)false, (boolean)map.putAll((Object)"A", new ArrayList()));
        MultiValueMapTest.assertEquals((int)3, (int)map.size((Object)"A"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)map.containsValue((Object)"A", (Object)"X"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)map.containsValue((Object)"A", (Object)"Y"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)map.containsValue((Object)"A", (Object)"Z"));
        coll = Arrays.asList("M");
        MultiValueMapTest.assertEquals((boolean)true, (boolean)map.putAll((Object)"A", coll));
        MultiValueMapTest.assertEquals((int)4, (int)map.size((Object)"A"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)map.containsValue((Object)"A", (Object)"X"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)map.containsValue((Object)"A", (Object)"Y"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)map.containsValue((Object)"A", (Object)"Z"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)map.containsValue((Object)"A", (Object)"M"));
    }

    public void testRemove_KeyItem() {
        MultiValueMap map = new MultiValueMap();
        map.put((Object)"A", (Object)"AA");
        map.put((Object)"A", (Object)"AB");
        map.put((Object)"A", (Object)"AC");
        MultiValueMapTest.assertEquals((boolean)false, (boolean)map.removeMapping((Object)"C", (Object)"CA"));
        MultiValueMapTest.assertEquals((boolean)false, (boolean)map.removeMapping((Object)"A", (Object)"AD"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)map.removeMapping((Object)"A", (Object)"AC"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)map.removeMapping((Object)"A", (Object)"AB"));
        MultiValueMapTest.assertEquals((boolean)true, (boolean)map.removeMapping((Object)"A", (Object)"AA"));
        MultiValueMapTest.assertEquals((Object)new MultiValueMap(), (Object)map);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public Object makeObject() {
        Map m = this.makeEmptyMap();
        m.put("a", "1");
        m.put("a", "1b");
        m.put("b", "2");
        m.put("c", "3");
        m.put("c", "3b");
        m.put("d", "4");
        return m;
    }

    private Map makeEmptyMap() {
        return new MultiValueMap();
    }

    public void testEmptyMapCompatibility() throws Exception {
        Map map = this.makeEmptyMap();
        Map map2 = (Map)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(map));
        MultiValueMapTest.assertEquals((String)"Map is empty", (int)0, (int)map2.size());
    }

    public void testFullMapCompatibility() throws Exception {
        Map map = (Map)this.makeObject();
        Map map2 = (Map)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(map));
        MultiValueMapTest.assertEquals((String)"Map is the right size", (int)map.size(), (int)map2.size());
        for (Object key : map.keySet()) {
            MultiValueMapTest.assertEquals((String)"Map had inequal elements", map.get(key), map2.get(key));
            map2.remove(key);
        }
        MultiValueMapTest.assertEquals((String)"Map had extra values", (int)0, (int)map2.size());
    }
}

