/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.map.AbstractSortedMapTest;
import org.apache.commons.collections4.map.PredicatedSortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicatedSortedMapTest<K, V>
extends AbstractSortedMapTest<K, V> {
    protected static final Predicate<Object> truePredicate = TruePredicate.truePredicate();
    protected static final Predicate<Object> testPredicate = new Predicate<Object>(){

        public boolean evaluate(Object o) {
            return o instanceof String;
        }
    };

    public PredicatedSortedMapTest(String testName) {
        super(testName);
    }

    protected SortedMap<K, V> decorateMap(SortedMap<K, V> map, Predicate<? super K> keyPredicate, Predicate<? super V> valuePredicate) {
        return PredicatedSortedMap.predicatedSortedMap(map, keyPredicate, valuePredicate);
    }

    @Override
    public SortedMap<K, V> makeObject() {
        return this.decorateMap(new TreeMap(), truePredicate, truePredicate);
    }

    public SortedMap<K, V> makeTestMap() {
        return this.decorateMap(new TreeMap(), testPredicate, testPredicate);
    }

    @Override
    public boolean isSubMapViewsSerializable() {
        return false;
    }

    @Override
    public boolean isAllowNullKey() {
        return false;
    }

    public void testEntrySet() {
        SortedMap<String, String> map = this.makeTestMap();
        PredicatedSortedMapTest.assertTrue((String)"returned entryset should not be null", (map.entrySet() != null ? 1 : 0) != 0);
        map = this.decorateMap(new TreeMap(), null, null);
        map.put("oneKey", "oneValue");
        PredicatedSortedMapTest.assertTrue((String)"returned entryset should contain one entry", (map.entrySet().size() == 1 ? 1 : 0) != 0);
        map = this.decorateMap(map, null, null);
    }

    public void testPut() {
        Map.Entry entry;
        SortedMap<Object, Object> map = this.makeTestMap();
        try {
            map.put("Hi", 3);
            PredicatedSortedMapTest.fail((String)"Illegal value should raise IllegalArgument");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            map.put(3, "Hi");
            PredicatedSortedMapTest.fail((String)"Illegal key should raise IllegalArgument");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        PredicatedSortedMapTest.assertTrue((!map.containsKey(3) ? 1 : 0) != 0);
        PredicatedSortedMapTest.assertTrue((!map.containsValue(3) ? 1 : 0) != 0);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("A", "a");
        map2.put("B", "b");
        map2.put("C", "c");
        map2.put("c", 3);
        try {
            map.putAll(map2);
            PredicatedSortedMapTest.fail((String)"Illegal value should raise IllegalArgument");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        map.put("E", "e");
        Iterator iterator = map.entrySet().iterator();
        try {
            entry = iterator.next();
            entry.setValue(3);
            PredicatedSortedMapTest.fail((String)"Illegal value should raise IllegalArgument");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        map.put("F", "f");
        iterator = map.entrySet().iterator();
        entry = iterator.next();
        entry.setValue("x");
    }

    public void testSortOrder() {
        SortedMap<String, String> map = this.makeTestMap();
        map.put("A", "a");
        map.put("B", "b");
        try {
            map.put(null, "c");
            PredicatedSortedMapTest.fail((String)"Null key should raise IllegalArgument");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        map.put("C", "c");
        try {
            map.put("D", null);
            PredicatedSortedMapTest.fail((String)"Null value should raise IllegalArgument");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        PredicatedSortedMapTest.assertEquals((String)"First key should be A", (Object)"A", map.firstKey());
        PredicatedSortedMapTest.assertEquals((String)"Last key should be C", (Object)"C", map.lastKey());
        PredicatedSortedMapTest.assertEquals((String)"First key in tail map should be B", (Object)"B", (Object)map.tailMap("B").firstKey());
        PredicatedSortedMapTest.assertEquals((String)"Last key in head map should be B", (Object)"B", (Object)map.headMap("C").lastKey());
        PredicatedSortedMapTest.assertEquals((String)"Last key in submap should be B", (Object)"B", (Object)map.subMap("A", "C").lastKey());
        Comparator<K> c = map.comparator();
        PredicatedSortedMapTest.assertTrue((String)"natural order, so comparator should be null", (c == null ? 1 : 0) != 0);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

