/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import junit.framework.Assert;
import org.apache.commons.collections.AbstractTestObject;

public abstract class AbstractTestCollection
extends AbstractTestObject {
    public Collection collection;
    public Collection confirmed;
    static /* synthetic */ Class class$java$util$Map$Entry;

    public AbstractTestCollection(String testName) {
        super(testName);
    }

    public boolean areEqualElementsDistinguishable() {
        return false;
    }

    public boolean isAddSupported() {
        return true;
    }

    public boolean isRemoveSupported() {
        return true;
    }

    public boolean isNullSupported() {
        return true;
    }

    public boolean isFailFastSupported() {
        return false;
    }

    public void verify() {
        int confirmedSize = this.confirmed.size();
        Assert.assertEquals((String)"Collection size should match confirmed collection's", (int)confirmedSize, (int)this.collection.size());
        Assert.assertEquals((String)"Collection isEmpty() result should match confirmed  collection's", (boolean)this.confirmed.isEmpty(), (boolean)this.collection.isEmpty());
        Object[] confirmedValues = new Object[confirmedSize];
        Iterator iter = this.confirmed.iterator();
        int pos = 0;
        while (iter.hasNext()) {
            confirmedValues[pos++] = iter.next();
        }
        boolean[] matched = new boolean[confirmedSize];
        iter = this.collection.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            boolean match = false;
            int i = 0;
            while (i < confirmedSize) {
                if (!matched[i] && (o == confirmedValues[i] || o != null && o.equals(confirmedValues[i]))) {
                    matched[i] = true;
                    match = true;
                    break;
                }
                ++i;
            }
            if (match) continue;
            Assert.fail((String)("Collection should not contain a value that the confirmed collection does not have: " + o + "\nTest: " + this.collection + "\nReal: " + this.confirmed));
        }
        int i = 0;
        while (i < confirmedSize) {
            if (!matched[i]) {
                Assert.fail((String)("Collection should contain all values that are in the confirmed collection\nTest: " + this.collection + "\nReal: " + this.confirmed));
            }
            ++i;
        }
    }

    public void resetEmpty() {
        this.collection = this.makeCollection();
        this.confirmed = this.makeConfirmedCollection();
    }

    public void resetFull() {
        this.collection = this.makeFullCollection();
        this.confirmed = this.makeConfirmedFullCollection();
    }

    public abstract Collection makeConfirmedCollection();

    public abstract Collection makeConfirmedFullCollection();

    public abstract Collection makeCollection();

    public Collection makeFullCollection() {
        Collection c = this.makeCollection();
        c.addAll(Arrays.asList(this.getFullElements()));
        return c;
    }

    public Object makeObject() {
        return this.makeCollection();
    }

    public Map.Entry cloneMapEntry(Map.Entry entry) {
        HashMap map = new HashMap();
        map.put(entry.getKey(), entry.getValue());
        return map.entrySet().iterator().next();
    }

    public Object[] getFullElements() {
        if (this.isNullSupported()) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.addAll(Arrays.asList(this.getFullNonNullElements()));
            list.add(4, null);
            return list.toArray();
        }
        return (Object[])this.getFullNonNullElements().clone();
    }

    public Object[] getOtherElements() {
        return this.getOtherNonNullElements();
    }

    public Object[] getFullNonNullElements() {
        return new Object[]{new String(""), new String("One"), new Integer(2), "Three", new Integer(4), "One", new Double(5.0), new Float(6.0f), "Seven", "Eight", new String("Nine"), new Integer(10), new Short(11), new Long(12L), "Thirteen", "14", "15", new Byte(16)};
    }

    public Object[] getOtherNonNullElements() {
        return new Object[]{new Integer(0), new Float(0.0f), new Double(0.0), "Zero", new Short(0), new Byte(0), new Long(0L), new Character('\u0000'), "0"};
    }

    public Object[] getFullNonNullStringElements() {
        return new Object[]{"If", "the", "dull", "substance", "of", "my", "flesh", "were", "thought", "Injurious", "distance", "could", "not", "stop", "my", "way"};
    }

    public Object[] getOtherNonNullStringElements() {
        return new Object[]{"For", "then", "despite", "space", "I", "would", "be", "brought", "From", "limits", "far", "remote", "where", "thou", "dost", "stay"};
    }

    public void testCollectionAdd() {
        if (!this.isAddSupported()) {
            return;
        }
        Object[] elements = this.getFullElements();
        int i = 0;
        while (i < elements.length) {
            this.resetEmpty();
            boolean r = this.collection.add(elements[i]);
            this.confirmed.add(elements[i]);
            this.verify();
            Assert.assertTrue((String)"Empty collection changed after add", (boolean)r);
            Assert.assertEquals((String)"Collection size is 1 after first add", (int)1, (int)this.collection.size());
            ++i;
        }
        this.resetEmpty();
        int size = 0;
        int i2 = 0;
        while (i2 < elements.length) {
            boolean r = this.collection.add(elements[i2]);
            this.confirmed.add(elements[i2]);
            this.verify();
            if (r) {
                ++size;
            }
            Assert.assertEquals((String)"Collection size should grow after add", (int)size, (int)this.collection.size());
            Assert.assertTrue((String)"Collection should contain added element", (boolean)this.collection.contains(elements[i2]));
            ++i2;
        }
    }

    public void testCollectionAddAll() {
        if (!this.isAddSupported()) {
            return;
        }
        this.resetEmpty();
        Object[] elements = this.getFullElements();
        boolean r = this.collection.addAll(Arrays.asList(elements));
        this.confirmed.addAll(Arrays.asList(elements));
        this.verify();
        Assert.assertTrue((String)"Empty collection should change after addAll", (boolean)r);
        int i = 0;
        while (i < elements.length) {
            Assert.assertTrue((String)"Collection should contain added element", (boolean)this.collection.contains(elements[i]));
            ++i;
        }
        this.resetFull();
        int size = this.collection.size();
        elements = this.getOtherElements();
        r = this.collection.addAll(Arrays.asList(elements));
        this.confirmed.addAll(Arrays.asList(elements));
        this.verify();
        Assert.assertTrue((String)"Full collection should change after addAll", (boolean)r);
        int i2 = 0;
        while (i2 < elements.length) {
            Assert.assertTrue((String)"Full collection should contain added element", (boolean)this.collection.contains(elements[i2]));
            ++i2;
        }
        Assert.assertEquals((String)"Size should increase after addAll", (int)(size + elements.length), (int)this.collection.size());
        this.resetFull();
        size = this.collection.size();
        r = this.collection.addAll(Arrays.asList(this.getFullElements()));
        this.confirmed.addAll(Arrays.asList(this.getFullElements()));
        this.verify();
        if (r) {
            Assert.assertTrue((String)"Size should increase if addAll returns true", (size < this.collection.size() ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)"Size should not change if addAll returns false", (int)size, (int)this.collection.size());
        }
    }

    public void testUnsupportedAdd() {
        if (this.isAddSupported()) {
            return;
        }
        this.resetEmpty();
        try {
            this.collection.add(new Object());
            Assert.fail((String)"Emtpy collection should not support add.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        this.verify();
        try {
            this.collection.addAll(Arrays.asList(this.getFullElements()));
            Assert.fail((String)"Emtpy collection should not support addAll.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        this.verify();
        this.resetFull();
        try {
            this.collection.add(new Object());
            Assert.fail((String)"Full collection should not support add.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        this.verify();
        try {
            this.collection.addAll(Arrays.asList(this.getOtherElements()));
            Assert.fail((String)"Full collection should not support addAll.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.verify();
    }

    public void testCollectionClear() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        this.collection.clear();
        this.verify();
        this.resetFull();
        this.collection.clear();
        this.confirmed.clear();
        this.verify();
    }

    public void testCollectionContains() {
        this.resetEmpty();
        Object[] elements = this.getFullElements();
        int i = 0;
        while (i < elements.length) {
            Assert.assertTrue((String)("Empty collection shouldn't contain element[" + i + "]"), (!this.collection.contains(elements[i]) ? 1 : 0) != 0);
            ++i;
        }
        this.verify();
        elements = this.getOtherElements();
        int i2 = 0;
        while (i2 < elements.length) {
            Assert.assertTrue((String)("Empty collection shouldn't contain element[" + i2 + "]"), (!this.collection.contains(elements[i2]) ? 1 : 0) != 0);
            ++i2;
        }
        this.verify();
        this.resetFull();
        elements = this.getFullElements();
        int i3 = 0;
        while (i3 < elements.length) {
            Assert.assertTrue((String)("Full collection should contain element[" + i3 + "]"), (boolean)this.collection.contains(elements[i3]));
            ++i3;
        }
        this.verify();
        this.resetFull();
        elements = this.getOtherElements();
        int i4 = 0;
        while (i4 < elements.length) {
            Assert.assertTrue((String)"Full collection shouldn't contain element", (!this.collection.contains(elements[i4]) ? 1 : 0) != 0);
            ++i4;
        }
    }

    public void testCollectionContainsAll() {
        int min;
        this.resetEmpty();
        Collection<Object> col = new HashSet<Object>();
        Assert.assertTrue((String)"Every Collection should contain all elements of an empty Collection.", (boolean)this.collection.containsAll(col));
        col.addAll(Arrays.asList(this.getOtherElements()));
        Assert.assertTrue((String)"Empty Collection shouldn't contain all elements of a non-empty Collection.", (!this.collection.containsAll(col) ? 1 : 0) != 0);
        this.verify();
        this.resetFull();
        Assert.assertTrue((String)"Full collection shouldn't contain other elements", (!this.collection.containsAll(col) ? 1 : 0) != 0);
        col.clear();
        col.addAll(Arrays.asList(this.getFullElements()));
        Assert.assertTrue((String)"Full collection should containAll full elements", (boolean)this.collection.containsAll(col));
        this.verify();
        int n = min = this.getFullElements().length < 2 ? 0 : 2;
        int max = this.getFullElements().length == 1 ? 1 : (this.getFullElements().length <= 5 ? this.getFullElements().length - 1 : 5);
        col = Arrays.asList(this.getFullElements()).subList(min, max);
        Assert.assertTrue((String)"Full collection should containAll partial full elements", (boolean)this.collection.containsAll(col));
        Assert.assertTrue((String)"Full collection should containAll itself", (boolean)this.collection.containsAll(this.collection));
        this.verify();
        col = new ArrayList();
        col.addAll(Arrays.asList(this.getFullElements()));
        col.addAll(Arrays.asList(this.getFullElements()));
        Assert.assertTrue((String)"Full collection should containAll duplicate full elements", (boolean)this.collection.containsAll(col));
        this.verify();
    }

    public void testCollectionIsEmpty() {
        this.resetEmpty();
        Assert.assertEquals((String)"New Collection should be empty.", (boolean)true, (boolean)this.collection.isEmpty());
        this.verify();
        this.resetFull();
        Assert.assertEquals((String)"Full collection shouldn't be empty", (boolean)false, (boolean)this.collection.isEmpty());
        this.verify();
    }

    public void testCollectionIterator() {
        this.resetEmpty();
        Iterator it1 = this.collection.iterator();
        Assert.assertEquals((String)"Iterator for empty Collection shouldn't have next.", (boolean)false, (boolean)it1.hasNext());
        try {
            it1.next();
            Assert.fail((String)"Iterator at end of Collection should throw NoSuchElementException when next is called.");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.verify();
        this.resetFull();
        it1 = this.collection.iterator();
        int i = 0;
        while (i < this.collection.size()) {
            Assert.assertTrue((String)"Iterator for full collection should haveNext", (boolean)it1.hasNext());
            it1.next();
            ++i;
        }
        Assert.assertTrue((String)"Iterator should be finished", (!it1.hasNext() ? 1 : 0) != 0);
        ArrayList list = new ArrayList();
        it1 = this.collection.iterator();
        int i2 = 0;
        while (i2 < this.collection.size()) {
            Object next = it1.next();
            Assert.assertTrue((String)"Collection should contain element returned by its iterator", (boolean)this.collection.contains(next));
            list.add(next);
            ++i2;
        }
        try {
            it1.next();
            Assert.fail((String)"iterator.next() should raise NoSuchElementException after it finishes");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.verify();
    }

    public void testCollectionIteratorRemove() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        try {
            this.collection.iterator().remove();
            Assert.fail((String)"New iterator.remove should raise IllegalState");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.verify();
        try {
            Iterator iter = this.collection.iterator();
            iter.hasNext();
            iter.remove();
            Assert.fail((String)"New iterator.remove should raise IllegalState even after hasNext");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.verify();
        this.resetFull();
        int size = this.collection.size();
        Iterator iter = this.collection.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof Map.Entry) {
                o = this.cloneMapEntry((Map.Entry)o);
            }
            iter.remove();
            if (!this.areEqualElementsDistinguishable()) {
                this.confirmed.remove(o);
                this.verify();
            }
            Assert.assertEquals((String)"Collection should shrink by one after iterator.remove", (int)(--size), (int)this.collection.size());
        }
        Assert.assertTrue((String)"Collection should be empty after iterator purge", (boolean)this.collection.isEmpty());
        this.resetFull();
        iter = this.collection.iterator();
        iter.next();
        iter.remove();
        try {
            iter.remove();
            Assert.fail((String)"Second iter.remove should raise IllegalState");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCollectionRemove() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        Object[] elements = this.getFullElements();
        int i = 0;
        while (i < elements.length) {
            Assert.assertTrue((String)"Shouldn't remove nonexistent element", (!this.collection.remove(elements[i]) ? 1 : 0) != 0);
            this.verify();
            ++i;
        }
        Object[] other = this.getOtherElements();
        this.resetFull();
        int i2 = 0;
        while (i2 < other.length) {
            Assert.assertTrue((String)"Shouldn't remove nonexistent other element", (!this.collection.remove(other[i2]) ? 1 : 0) != 0);
            this.verify();
            ++i2;
        }
        int size = this.collection.size();
        int i3 = 0;
        while (i3 < elements.length) {
            this.resetFull();
            Assert.assertTrue((String)("Collection should remove extant element: " + elements[i3]), (boolean)this.collection.remove(elements[i3]));
            if (!this.areEqualElementsDistinguishable()) {
                this.confirmed.remove(elements[i3]);
                this.verify();
            }
            Assert.assertEquals((String)"Collection should shrink after remove", (int)(size - 1), (int)this.collection.size());
            ++i3;
        }
    }

    public void testCollectionRemoveAll() {
        int min;
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        Assert.assertTrue((String)"Emtpy collection removeAll should return false for empty input", (!this.collection.removeAll(Collections.EMPTY_SET) ? 1 : 0) != 0);
        this.verify();
        Assert.assertTrue((String)"Emtpy collection removeAll should return false for nonempty input", (!this.collection.removeAll(new ArrayList(this.collection)) ? 1 : 0) != 0);
        this.verify();
        this.resetFull();
        Assert.assertTrue((String)"Full collection removeAll should return false for empty input", (!this.collection.removeAll(Collections.EMPTY_SET) ? 1 : 0) != 0);
        this.verify();
        Assert.assertTrue((String)"Full collection removeAll should return false for other elements", (!this.collection.removeAll(Arrays.asList(this.getOtherElements())) ? 1 : 0) != 0);
        this.verify();
        Assert.assertTrue((String)"Full collection removeAll should return true for full elements", (boolean)this.collection.removeAll(new HashSet(this.collection)));
        this.confirmed.removeAll(new HashSet(this.confirmed));
        this.verify();
        this.resetFull();
        int size = this.collection.size();
        int n = min = this.getFullElements().length < 2 ? 0 : 2;
        int max = this.getFullElements().length == 1 ? 1 : (this.getFullElements().length <= 5 ? this.getFullElements().length - 1 : 5);
        List<Object> all = Arrays.asList(this.getFullElements()).subList(min, max);
        Assert.assertTrue((String)"Full collection removeAll should work", (boolean)this.collection.removeAll(all));
        this.confirmed.removeAll(all);
        this.verify();
        Assert.assertTrue((String)"Collection should shrink after removeAll", (this.collection.size() < size ? 1 : 0) != 0);
        Iterator iter = all.iterator();
        while (iter.hasNext()) {
            Assert.assertTrue((String)"Collection shouldn't contain removed element", (!this.collection.contains(iter.next()) ? 1 : 0) != 0);
        }
    }

    public void testCollectionRetainAll() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        List<Object> elements = Arrays.asList(this.getFullElements());
        List<Object> other = Arrays.asList(this.getOtherElements());
        Assert.assertTrue((String)"Empty retainAll() should return false", (!this.collection.retainAll(Collections.EMPTY_SET) ? 1 : 0) != 0);
        this.verify();
        Assert.assertTrue((String)"Empty retainAll() should return false", (!this.collection.retainAll(elements) ? 1 : 0) != 0);
        this.verify();
        this.resetFull();
        Assert.assertTrue((String)"Collection should change from retainAll empty", (boolean)this.collection.retainAll(Collections.EMPTY_SET));
        this.confirmed.retainAll(Collections.EMPTY_SET);
        this.verify();
        this.resetFull();
        Assert.assertTrue((String)"Collection changed from retainAll other", (boolean)this.collection.retainAll(other));
        this.confirmed.retainAll(other);
        this.verify();
        this.resetFull();
        int size = this.collection.size();
        Assert.assertTrue((String)"Collection shouldn't change from retainAll elements", (!this.collection.retainAll(elements) ? 1 : 0) != 0);
        this.verify();
        Assert.assertEquals((String)"Collection size shouldn't change", (int)size, (int)this.collection.size());
        if (this.getFullElements().length > 1) {
            this.resetFull();
            size = this.collection.size();
            int min = this.getFullElements().length < 2 ? 0 : 2;
            int max = this.getFullElements().length <= 5 ? this.getFullElements().length - 1 : 5;
            Assert.assertTrue((String)"Collection should changed by partial retainAll", (boolean)this.collection.retainAll(elements.subList(min, max)));
            this.confirmed.retainAll(elements.subList(min, max));
            this.verify();
            Iterator iter = this.collection.iterator();
            while (iter.hasNext()) {
                Assert.assertTrue((String)"Collection only contains retained element", (boolean)elements.subList(min, max).contains(iter.next()));
            }
        }
        this.resetFull();
        HashSet<Object> set = new HashSet<Object>(elements);
        size = this.collection.size();
        Assert.assertTrue((String)"Collection shouldn't change from retainAll without duplicate elements", (!this.collection.retainAll(set) ? 1 : 0) != 0);
        this.verify();
        Assert.assertEquals((String)"Collection size didn't change from nonduplicate retainAll", (int)size, (int)this.collection.size());
    }

    public void testCollectionSize() {
        this.resetEmpty();
        Assert.assertEquals((String)"Size of new Collection is 0.", (int)0, (int)this.collection.size());
        this.resetFull();
        Assert.assertTrue((String)"Size of full collection should be greater than zero", (this.collection.size() > 0 ? 1 : 0) != 0);
    }

    public void testCollectionToArray() {
        this.resetEmpty();
        Assert.assertEquals((String)"Empty Collection should return empty array for toArray", (int)0, (int)this.collection.toArray().length);
        this.resetFull();
        Object[] array = this.collection.toArray();
        Assert.assertEquals((String)"Full collection toArray should be same size as collection", (int)array.length, (int)this.collection.size());
        Object[] confirmedArray = this.confirmed.toArray();
        Assert.assertEquals((String)"length of array from confirmed collection should match the length of the collection's array", (int)confirmedArray.length, (int)array.length);
        boolean[] matched = new boolean[array.length];
        int i = 0;
        while (i < array.length) {
            Assert.assertTrue((String)"Collection should contain element in toArray", (boolean)this.collection.contains(array[i]));
            boolean match = false;
            int j = 0;
            while (j < array.length) {
                if (!matched[j] && (array[i] == confirmedArray[j] || array[i] != null && array[i].equals(confirmedArray[j]))) {
                    matched[j] = true;
                    match = true;
                    break;
                }
                ++j;
            }
            if (!match) {
                Assert.fail((String)("element " + i + " in returned array should be found " + "in the confirmed collection's array"));
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < matched.length) {
            Assert.assertEquals((String)"Collection should return all its elements in toArray", (boolean)true, (boolean)matched[i2]);
            ++i2;
        }
    }

    public void testCollectionToArray2() {
        Class cl;
        this.resetEmpty();
        Object[] a = new Object[]{new Object(), null, null};
        Object[] array = this.collection.toArray(a);
        Assert.assertEquals((String)"Given array shouldn't shrink", (Object)array, (Object)a);
        Assert.assertEquals((String)"Last element should be set to null", (Object)a[0], null);
        this.verify();
        this.resetFull();
        try {
            array = this.collection.toArray(new Void[0]);
            Assert.fail((String)"toArray(new Void[0]) should raise ArrayStore");
        }
        catch (ArrayStoreException e) {
            // empty catch block
        }
        this.verify();
        try {
            array = this.collection.toArray((T[])null);
            Assert.fail((String)"toArray(null) should raise NPE");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.verify();
        array = this.collection.toArray(new Object[0]);
        a = this.collection.toArray();
        Assert.assertEquals((String)"toArrays should be equal", Arrays.asList(array), Arrays.asList(a));
        HashSet classes = new HashSet();
        int i = 0;
        while (i < array.length) {
            classes.add(array[i] == null ? null : array[i].getClass());
            ++i;
        }
        if (classes.size() > 1) {
            return;
        }
        if ((class$java$util$Map$Entry == null ? (class$java$util$Map$Entry = AbstractTestCollection.class$("java.util.Map$Entry")) : class$java$util$Map$Entry).isAssignableFrom(cl = (Class)classes.iterator().next())) {
            cl = class$java$util$Map$Entry == null ? (class$java$util$Map$Entry = AbstractTestCollection.class$("java.util.Map$Entry")) : class$java$util$Map$Entry;
        }
        a = (Object[])Array.newInstance(cl, 0);
        array = this.collection.toArray(a);
        Assert.assertEquals((String)"toArray(Object[]) should return correct array type", a.getClass(), array.getClass());
        Assert.assertEquals((String)"type-specific toArrays should be equal", Arrays.asList(array), Arrays.asList(this.collection.toArray()));
        this.verify();
    }

    public void testCollectionToString() {
        this.resetEmpty();
        Assert.assertTrue((String)"toString shouldn't return null", (this.collection.toString() != null ? 1 : 0) != 0);
        this.resetFull();
        Assert.assertTrue((String)"toString shouldn't return null", (this.collection.toString() != null ? 1 : 0) != 0);
    }

    public void testUnsupportedRemove() {
        if (this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        try {
            this.collection.clear();
            Assert.fail((String)"clear should raise UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        this.verify();
        try {
            this.collection.remove(null);
            Assert.fail((String)"remove should raise UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        this.verify();
        try {
            this.collection.removeAll(null);
            Assert.fail((String)"removeAll should raise UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        this.verify();
        try {
            this.collection.retainAll(null);
            Assert.fail((String)"removeAll should raise UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        this.verify();
        this.resetFull();
        try {
            Iterator iterator = this.collection.iterator();
            iterator.next();
            iterator.remove();
            Assert.fail((String)"iterator.remove should raise UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.verify();
    }

    public void testCollectionIteratorFailFast() {
        List<Object> sublist;
        Iterator iter;
        if (!this.isFailFastSupported()) {
            return;
        }
        if (this.isAddSupported()) {
            this.resetFull();
            try {
                iter = this.collection.iterator();
                Object o = this.getOtherElements()[0];
                this.collection.add(o);
                this.confirmed.add(o);
                iter.next();
                Assert.fail((String)"next after add should raise ConcurrentModification");
            }
            catch (ConcurrentModificationException e) {
                // empty catch block
            }
            this.verify();
            this.resetFull();
            try {
                iter = this.collection.iterator();
                this.collection.addAll(Arrays.asList(this.getOtherElements()));
                this.confirmed.addAll(Arrays.asList(this.getOtherElements()));
                iter.next();
                Assert.fail((String)"next after addAll should raise ConcurrentModification");
            }
            catch (ConcurrentModificationException e) {
                // empty catch block
            }
            this.verify();
        }
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        try {
            iter = this.collection.iterator();
            this.collection.clear();
            iter.next();
            Assert.fail((String)"next after clear should raise ConcurrentModification");
        }
        catch (ConcurrentModificationException e) {
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.resetFull();
        try {
            iter = this.collection.iterator();
            this.collection.remove(this.getFullElements()[0]);
            iter.next();
            Assert.fail((String)"next after remove should raise ConcurrentModification");
        }
        catch (ConcurrentModificationException e) {
            // empty catch block
        }
        this.resetFull();
        try {
            iter = this.collection.iterator();
            sublist = Arrays.asList(this.getFullElements()).subList(2, 5);
            this.collection.removeAll(sublist);
            iter.next();
            Assert.fail((String)"next after removeAll should raise ConcurrentModification");
        }
        catch (ConcurrentModificationException e) {
            // empty catch block
        }
        this.resetFull();
        try {
            iter = this.collection.iterator();
            sublist = Arrays.asList(this.getFullElements()).subList(2, 5);
            this.collection.retainAll(sublist);
            iter.next();
            Assert.fail((String)"next after retainAll should raise ConcurrentModification");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

