/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.set;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import org.apache.commons.collections.collection.AbstractTestCollection;

public abstract class AbstractTestSet
extends AbstractTestCollection {
    public AbstractTestSet(String name) {
        super(name);
    }

    public void verify() {
        super.verify();
        Assert.assertEquals((String)"Sets should be equal", (Object)this.confirmed, (Object)this.collection);
        Assert.assertEquals((String)"Sets should have equal hashCodes", (int)this.confirmed.hashCode(), (int)this.collection.hashCode());
        Collection set = this.makeConfirmedCollection();
        Iterator iterator = this.collection.iterator();
        while (iterator.hasNext()) {
            Assert.assertTrue((String)"Set.iterator should only return unique elements", (boolean)set.add(iterator.next()));
        }
    }

    public Collection makeConfirmedCollection() {
        return new HashSet();
    }

    public Collection makeConfirmedFullCollection() {
        Collection set = this.makeConfirmedCollection();
        set.addAll(Arrays.asList(this.getFullElements()));
        return set;
    }

    public abstract Set makeEmptySet();

    public Set makeFullSet() {
        Set set = this.makeEmptySet();
        set.addAll(Arrays.asList(this.getFullElements()));
        return set;
    }

    public final Collection makeCollection() {
        return this.makeEmptySet();
    }

    public final Collection makeFullCollection() {
        return this.makeFullSet();
    }

    public Set getSet() {
        return (Set)this.collection;
    }

    public Set getConfirmedSet() {
        return (Set)this.confirmed;
    }

    public void testSetEquals() {
        this.resetEmpty();
        Assert.assertEquals((String)"Empty sets should be equal", (Object)this.getSet(), (Object)this.getConfirmedSet());
        this.verify();
        Collection set2 = this.makeConfirmedCollection();
        set2.add("foo");
        Assert.assertTrue((String)"Empty set shouldn't equal nonempty set", (!this.getSet().equals(set2) ? 1 : 0) != 0);
        this.resetFull();
        Assert.assertEquals((String)"Full sets should be equal", (Object)this.getSet(), (Object)this.getConfirmedSet());
        this.verify();
        set2.clear();
        set2.addAll(Arrays.asList(this.getOtherElements()));
        Assert.assertTrue((String)"Sets with different contents shouldn't be equal", (!this.getSet().equals(set2) ? 1 : 0) != 0);
    }

    public void testSetHashCode() {
        this.resetEmpty();
        Assert.assertEquals((String)"Empty sets have equal hashCodes", (int)this.getSet().hashCode(), (int)this.getConfirmedSet().hashCode());
        this.resetFull();
        Assert.assertEquals((String)"Equal sets have equal hashCodes", (int)this.getSet().hashCode(), (int)this.getConfirmedSet().hashCode());
    }
}

