/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.release.plugin.mojos;

import java.io.File;
import junit.framework.TestCase;
import org.apache.commons.release.plugin.mojos.CommonsSiteCompressionMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.testing.MojoRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CommonsSiteCompressionMojoTest {
    @Rule
    public MojoRule rule = new MojoRule(){

        protected void before() throws Throwable {
        }

        protected void after() {
        }
    };
    protected CommonsSiteCompressionMojo mojo;

    @Test
    public void testCompressSiteSuccess() throws Exception {
        File testPom = new File("src/test/resources/mojos/compress-site/compress-site.xml");
        Assert.assertNotNull((Object)testPom);
        TestCase.assertTrue((boolean)testPom.exists());
        this.mojo = (CommonsSiteCompressionMojo)this.rule.lookupMojo("compress-site", testPom);
        this.mojo.execute();
        File siteZip = new File("target/commons-release-plugin/site.zip");
        TestCase.assertTrue((boolean)siteZip.exists());
    }

    @Test
    public void testCompressSiteDirNonExistentFailure() throws Exception {
        File testPom = new File("src/test/resources/mojos/compress-site/compress-site-failure.xml");
        Assert.assertNotNull((Object)testPom);
        TestCase.assertTrue((boolean)testPom.exists());
        this.mojo = (CommonsSiteCompressionMojo)this.rule.lookupMojo("compress-site", testPom);
        try {
            this.mojo.execute();
        }
        catch (MojoFailureException e) {
            Assert.assertEquals((Object)"\"mvn site\" was not run before this goal, or a siteDirectory did not exist.", (Object)e.getMessage());
        }
    }
}

