/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.release.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;

public final class SharedFunctions {
    public static final int BUFFER_BYTE_SIZE = 1024;

    private SharedFunctions() {
    }

    public static void initDirectory(Log log, File workingDirectory) throws MojoExecutionException {
        if (workingDirectory.exists()) {
            try {
                FileUtils.deleteDirectory((File)workingDirectory);
            }
            catch (IOException e) {
                log.error((CharSequence)e.getMessage());
                throw new MojoExecutionException("Unable to remove directory: " + e.getMessage(), (Exception)e);
            }
        }
        if (!workingDirectory.exists()) {
            workingDirectory.mkdirs();
        }
    }

    public static void copyFile(Log log, File fromFile, File toFile) throws MojoExecutionException {
        try {
            int len;
            FileInputStream in = new FileInputStream(fromFile);
            FileOutputStream out = new FileOutputStream(toFile);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            log.error((CharSequence)e.getMessage());
            throw new MojoExecutionException("Unable to copy file: " + e.getMessage(), (Exception)e);
        }
    }
}

