/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.release.plugin.mojos;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.release.plugin.SharedFunctions;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.manager.BasicScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.SvnExeScmProvider;
import org.apache.maven.scm.repository.ScmRepository;

@Mojo(name="stage-distributions", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true)
public class CommonsDistributionStagingMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;
    @Parameter(defaultValue="${basedir}")
    private File basedir;
    @Parameter(defaultValue="${project.build.directory}/commons-release-plugin", alias="outputDirectory")
    private File workingDirectory;
    @Parameter(defaultValue="${project.build.directory}/commons-release-plugin/scm", alias="outputDirectory")
    private File distCheckoutDirectory;
    @Parameter(defaultValue="false")
    private Boolean dryRun;
    @Parameter(required=true)
    private String distSvnStagingUrl;
    @Parameter(property="user.name")
    private String username;
    @Parameter(property="user.password")
    private String password;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Preparing to stage distributions");
        try {
            BasicScmManager scmManager = new BasicScmManager();
            scmManager.setScmProvider("svn", (ScmProvider)new SvnExeScmProvider());
            ScmRepository repository = scmManager.makeScmRepository(this.distSvnStagingUrl);
            ScmProvider provider = scmManager.getProviderByRepository(repository);
            SvnScmProviderRepository providerRepository = (SvnScmProviderRepository)repository.getProviderRepository();
            providerRepository.setUser(this.username);
            providerRepository.setPassword(this.password);
            if (!this.workingDirectory.exists()) {
                SharedFunctions.initDirectory(this.getLog(), this.workingDirectory);
            }
            if (!this.distCheckoutDirectory.exists()) {
                SharedFunctions.initDirectory(this.getLog(), this.distCheckoutDirectory);
            }
            ScmFileSet scmFileSet = new ScmFileSet(this.distCheckoutDirectory);
            this.getLog().info((CharSequence)("Checking out dist from: " + this.distSvnStagingUrl));
            provider.checkOut(repository, scmFileSet);
            this.copyReleaseNotesToWorkingDirectory();
            List<File> filesToCommit = this.copyDistributionsIntoScmDirectoryStructure();
            ScmFileSet scmFileSetToCommit = new ScmFileSet(this.distCheckoutDirectory, filesToCommit);
            if (!this.dryRun.booleanValue()) {
                AddScmResult addResult = provider.add(repository, scmFileSetToCommit, "Staging release: " + this.project.getArtifactId() + ", version: " + this.project.getVersion());
                if (addResult.isSuccess()) {
                    this.getLog().info((CharSequence)("Staging release: " + this.project.getArtifactId() + ", version: " + this.project.getVersion()));
                    CheckInScmResult checkInResult = provider.checkIn(repository, scmFileSetToCommit, "Staging release: " + this.project.getArtifactId() + ", version: " + this.project.getVersion());
                    if (checkInResult.isSuccess()) return;
                    this.getLog().error((CharSequence)("Committing dist files failed: " + checkInResult.getCommandOutput()));
                    throw new MojoExecutionException("Committing dist files failed: " + checkInResult.getCommandOutput());
                }
                this.getLog().error((CharSequence)("Adding dist files failed: " + addResult.getCommandOutput()));
                throw new MojoExecutionException("Adding dist files failed: " + addResult.getCommandOutput());
            }
            this.getLog().info((CharSequence)("Would have committed to: " + this.distSvnStagingUrl));
            this.getLog().info((CharSequence)("Staging release: " + this.project.getArtifactId() + ", version: " + this.project.getVersion()));
            return;
        }
        catch (ScmException e) {
            this.getLog().error((CharSequence)("Could not commit files to dist: " + this.distSvnStagingUrl), (Throwable)e);
            throw new MojoExecutionException("Could not commit files to dist: " + this.distSvnStagingUrl, (Exception)((Object)e));
        }
    }

    private void copyReleaseNotesToWorkingDirectory() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Copying RELEASE-NOTES.txt to working directory.");
        File releaseNotes = new File(this.basedir + "/RELEASE-NOTES.txt");
        StringBuffer copiedReleaseNotesAbsolutePath = new StringBuffer(this.workingDirectory.getAbsolutePath());
        copiedReleaseNotesAbsolutePath.append("/scm/");
        copiedReleaseNotesAbsolutePath.append(releaseNotes.getName());
        File copiedReleaseNotes = new File(copiedReleaseNotesAbsolutePath.toString());
        SharedFunctions.copyFile(this.getLog(), releaseNotes, copiedReleaseNotes);
    }

    private List<File> copyDistributionsIntoScmDirectoryStructure() throws MojoExecutionException {
        List<File> workingDirectoryFiles = Arrays.asList(this.workingDirectory.listFiles());
        String scmBinariesRoot = this.buildDistBinariesRoot();
        String scmSourceRoot = this.buildDistSourceRoot();
        ArrayList<File> filesForMavenScmFileSet = new ArrayList<File>();
        for (File file : workingDirectoryFiles) {
            File copy;
            if (file.getName().contains("src")) {
                copy = new File(scmSourceRoot + "/" + file.getName());
                SharedFunctions.copyFile(this.getLog(), file, copy);
                filesForMavenScmFileSet.add(copy);
                continue;
            }
            if (file.getName().contains("bin")) {
                copy = new File(scmBinariesRoot + "/" + file.getName());
                SharedFunctions.copyFile(this.getLog(), file, copy);
                filesForMavenScmFileSet.add(copy);
                continue;
            }
            if (file.getName().contains("scm")) {
                this.getLog().debug((CharSequence)"Not copying scm directory over to the scm directory because it is the scm directory.");
                continue;
            }
            copy = new File(this.distCheckoutDirectory.getAbsolutePath() + "/" + file.getName());
            SharedFunctions.copyFile(this.getLog(), file, copy);
            filesForMavenScmFileSet.add(copy);
        }
        filesForMavenScmFileSet.add(new File(this.distCheckoutDirectory + "/RELEASE-NOTES.txt"));
        return filesForMavenScmFileSet;
    }

    private String buildDistBinariesRoot() {
        StringBuffer buffer = new StringBuffer(this.distCheckoutDirectory.getAbsolutePath());
        buffer.append("/binaries");
        return buffer.toString();
    }

    private String buildDistSourceRoot() {
        StringBuffer buffer = new StringBuffer(this.distCheckoutDirectory.getAbsolutePath());
        buffer.append("/source");
        return buffer.toString();
    }

    protected void setBasedir(File basedir) {
        this.basedir = basedir;
    }
}

