/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.release.plugin.mojos;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.release.plugin.SharedFunctions;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="detach-distributions", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true, aggregator=true)
public class CommonsDistributionDetachmentMojo
extends AbstractMojo {
    private static final Set<String> ARTIFACT_TYPES_TO_DETACH;
    private List<Artifact> detachedArtifacts = new ArrayList<Artifact>();
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/commons-release-plugin", property="commons.outputDirectory")
    private File workingDirectory;
    @Parameter(defaultValue="", property="commons.distSvnStagingUrl")
    private String distSvnStagingUrl;
    @Parameter(defaultValue="false", property="commons.release.isDistModule")
    private Boolean isDistModule;

    public void execute() throws MojoExecutionException {
        if (!this.isDistModule.booleanValue()) {
            this.getLog().info((CharSequence)"This module is marked as a non distribution or assembly module, and the plugin will not run.");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.distSvnStagingUrl)) {
            this.getLog().warn((CharSequence)"commons.distSvnStagingUrl is not set, the commons-release-plugin will not run.");
            return;
        }
        this.getLog().info((CharSequence)"Detaching Assemblies");
        for (Object attachedArtifact : this.project.getAttachedArtifacts()) {
            if (!ARTIFACT_TYPES_TO_DETACH.contains(((Artifact)attachedArtifact).getType())) continue;
            this.detachedArtifacts.add((Artifact)attachedArtifact);
        }
        if (this.detachedArtifacts.isEmpty()) {
            this.getLog().info((CharSequence)"Current project contains no distributions. Not executing.");
            return;
        }
        for (Artifact artifactToRemove : this.detachedArtifacts) {
            this.project.getAttachedArtifacts().remove(artifactToRemove);
        }
        if (!this.workingDirectory.exists()) {
            SharedFunctions.initDirectory(this.getLog(), this.workingDirectory);
        }
        this.copyRemovedArtifactsToWorkingDirectory();
        this.getLog().info((CharSequence)"");
        this.sha1AndMd5SignArtifacts();
    }

    private void copyRemovedArtifactsToWorkingDirectory() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Copying detached artifacts to working directory.");
        for (Artifact artifact : this.detachedArtifacts) {
            File artifactFile = artifact.getFile();
            StringBuffer copiedArtifactAbsolutePath = new StringBuffer(this.workingDirectory.getAbsolutePath());
            copiedArtifactAbsolutePath.append("/");
            copiedArtifactAbsolutePath.append(artifactFile.getName());
            File copiedArtifact = new File(copiedArtifactAbsolutePath.toString());
            this.getLog().info((CharSequence)("Copying: " + artifactFile.getName()));
            SharedFunctions.copyFile(this.getLog(), artifactFile, copiedArtifact);
        }
    }

    private void sha1AndMd5SignArtifacts() throws MojoExecutionException {
        for (Artifact artifact : this.detachedArtifacts) {
            if (artifact.getFile().getName().contains("asc")) continue;
            try {
                String md5 = DigestUtils.md5Hex((byte[])Files.readAllBytes(artifact.getFile().toPath()));
                this.getLog().info((CharSequence)(artifact.getFile().getName() + " md5: " + md5));
                PrintWriter md5Writer = new PrintWriter(this.getMd5FilePath(this.workingDirectory, artifact.getFile()));
                md5Writer.println(md5);
                String sha1 = DigestUtils.sha1Hex((byte[])Files.readAllBytes(artifact.getFile().toPath()));
                this.getLog().info((CharSequence)(artifact.getFile().getName() + " sha1: " + sha1));
                PrintWriter sha1Writer = new PrintWriter(this.getSha1FilePath(this.workingDirectory, artifact.getFile()));
                sha1Writer.println(sha1);
                md5Writer.close();
                sha1Writer.close();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not sign file: " + artifact.getFile().getName(), (Exception)e);
            }
        }
    }

    private String getMd5FilePath(File workingDirectory, File file) {
        StringBuffer buffer = new StringBuffer(workingDirectory.getAbsolutePath());
        buffer.append("/");
        buffer.append(file.getName());
        buffer.append(".md5");
        return buffer.toString();
    }

    private String getSha1FilePath(File workingDirectory, File file) {
        StringBuffer buffer = new StringBuffer(workingDirectory.getAbsolutePath());
        buffer.append("/");
        buffer.append(file.getName());
        buffer.append(".sha1");
        return buffer.toString();
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("zip");
        hashSet.add("tar.gz");
        hashSet.add("zip.asc");
        hashSet.add("tar.gz.asc");
        ARTIFACT_TYPES_TO_DETACH = Collections.unmodifiableSet(hashSet);
    }
}

