/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.bzip2;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class BZip2Utils {
    private static final Map<String, String> uncompressSuffix = new HashMap<String, String>();

    private BZip2Utils() {
    }

    public static boolean isCompressedFilename(String filename) {
        String lower = filename.toLowerCase(Locale.ENGLISH);
        int n = lower.length();
        for (int i = 3; i <= 5 && i < n; ++i) {
            if (!uncompressSuffix.containsKey(lower.substring(n - i))) continue;
            return true;
        }
        return false;
    }

    public static String getUncompressedFilename(String filename) {
        String lower = filename.toLowerCase(Locale.ENGLISH);
        int n = lower.length();
        for (int i = 3; i <= 5 && i < n; ++i) {
            String suffix = uncompressSuffix.get(lower.substring(n - i));
            if (suffix == null) continue;
            return filename.substring(0, n - i) + suffix;
        }
        return filename;
    }

    public static String getCompressedFilename(String filename) {
        return filename + ".bz2";
    }

    static {
        uncompressSuffix.put(".tbz2", ".tar");
        uncompressSuffix.put(".tbz", ".tar");
        uncompressSuffix.put(".bz2", "");
        uncompressSuffix.put(".bz", "");
    }
}

