/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.configuration.AbstractFileConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationKey;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class HierarchicalXMLConfiguration
extends HierarchicalConfiguration
implements FileConfiguration {
    private FileConfiguration delegate = new FileConfigurationDelegate();

    public void initProperties(Document document) {
        this.constructHierarchy(this.getRoot(), document.getDocumentElement());
    }

    private void constructHierarchy(HierarchicalConfiguration.Node node, Element element) {
        StringBuffer buffer = new StringBuffer();
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node w3cNode = list.item(i);
            if (w3cNode instanceof Element) {
                Element child = (Element)w3cNode;
                HierarchicalConfiguration.Node childNode = new HierarchicalConfiguration.Node(child.getTagName());
                this.constructHierarchy(childNode, child);
                node.addChild(childNode);
                this.processAttributes(childNode, child);
                continue;
            }
            if (!(w3cNode instanceof Text)) continue;
            Text data = (Text)w3cNode;
            buffer.append(data.getData());
        }
        String text = buffer.toString().trim();
        if (text.length() > 0) {
            node.setValue(text);
        }
    }

    private void processAttributes(HierarchicalConfiguration.Node node, Element element) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node w3cNode = attributes.item(i);
            if (!(w3cNode instanceof Attr)) continue;
            Attr attr = (Attr)w3cNode;
            HierarchicalConfiguration.Node child = new HierarchicalConfiguration.Node(ConfigurationKey.constructAttributeKey(attr.getName()));
            child.setValue(attr.getValue());
            node.addChild(child);
        }
    }

    public void load() throws ConfigurationException {
        this.delegate.load();
    }

    public void load(String fileName) throws ConfigurationException {
        this.delegate.load(fileName);
    }

    public void load(File file) throws ConfigurationException {
        this.delegate.load(file);
    }

    public void load(URL url) throws ConfigurationException {
        this.delegate.load(url);
    }

    public void load(InputStream in) throws ConfigurationException {
        this.delegate.load(in);
    }

    public void load(InputStream in, String encoding) throws ConfigurationException {
        this.delegate.load(in, encoding);
    }

    public void load(Reader in) throws ConfigurationException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.initProperties(builder.parse(new InputSource(in)));
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    public void save() throws ConfigurationException {
        this.delegate.save();
    }

    public void save(String fileName) throws ConfigurationException {
        this.delegate.save(fileName);
    }

    public void save(File file) throws ConfigurationException {
        this.delegate.save(file);
    }

    public void save(URL url) throws ConfigurationException {
        this.delegate.save(url);
    }

    public void save(OutputStream out) throws ConfigurationException {
        this.delegate.save(out);
    }

    public void save(OutputStream out, String encoding) throws ConfigurationException {
        this.delegate.save(out, encoding);
    }

    public void save(Writer out) throws ConfigurationException {
        throw new UnsupportedOperationException("Can't save HierarchicalXMLConfigurations");
    }

    public String getFileName() {
        return this.delegate.getFileName();
    }

    public void setFileName(String fileName) {
        this.delegate.setFileName(fileName);
    }

    public String getBasePath() {
        return this.delegate.getBasePath();
    }

    public void setBasePath(String basePath) {
        this.delegate.setBasePath(basePath);
    }

    public File getFile() {
        return this.delegate.getFile();
    }

    public void setFile(File file) {
        this.delegate.setFile(file);
    }

    public URL getURL() {
        return this.delegate.getURL();
    }

    public void setURL(URL url) {
        this.delegate.setURL(url);
    }

    private class FileConfigurationDelegate
    extends AbstractFileConfiguration {
        private FileConfigurationDelegate() {
        }

        public void load(Reader in) throws ConfigurationException {
            HierarchicalXMLConfiguration.this.load(in);
        }

        public void save(Writer out) throws ConfigurationException {
            HierarchicalXMLConfiguration.this.save(out);
        }
    }
}

