/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConfigurationUtils {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$configuration$ConfigurationUtils == null ? (class$org$apache$commons$configuration$ConfigurationUtils = ConfigurationUtils.class$("org.apache.commons.configuration.ConfigurationUtils")) : class$org$apache$commons$configuration$ConfigurationUtils));
    static /* synthetic */ Class class$org$apache$commons$configuration$ConfigurationUtils;

    private ConfigurationUtils() {
    }

    public static void dump(Configuration configuration, PrintStream out) {
        ConfigurationUtils.dump(configuration, new PrintWriter(out));
    }

    public static void dump(Configuration configuration, PrintWriter out) {
        Iterator keys = configuration.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = configuration.getProperty(key);
            out.print(key);
            out.print("=");
            out.print(value);
            if (!keys.hasNext()) continue;
            out.println();
        }
        out.flush();
    }

    public static String toString(Configuration configuration) {
        StringWriter writer = new StringWriter();
        ConfigurationUtils.dump(configuration, new PrintWriter(writer));
        return writer.toString();
    }

    public static URL getURL(String basePath, String file) throws MalformedURLException {
        File f = new File(file);
        if (f.isAbsolute()) {
            return f.toURL();
        }
        try {
            if (basePath == null) {
                return new URL(file);
            }
            URL base = new URL(basePath);
            return new URL(base, file);
        }
        catch (MalformedURLException uex) {
            return ConfigurationUtils.constructFile(basePath, file).toURL();
        }
    }

    static File constructFile(String basePath, String fileName) {
        File file = null;
        File absolute = null;
        if (fileName != null) {
            absolute = new File(fileName);
        }
        if (StringUtils.isEmpty((String)basePath) || absolute != null && absolute.isAbsolute()) {
            file = new File(fileName);
        } else {
            StringBuffer fName = new StringBuffer();
            fName.append(basePath);
            if (!basePath.endsWith(File.separator)) {
                fName.append(File.separator);
            }
            if (fileName.startsWith("." + File.separator)) {
                fName.append(fileName.substring(2));
            } else {
                fName.append(fileName);
            }
            file = new File(fName.toString());
        }
        return file;
    }

    public static URL locate(String name) {
        return ConfigurationUtils.locate(null, name);
    }

    public static URL locate(String base, String name) {
        ClassLoader loader;
        File file;
        URL url = null;
        try {
            if (base == null) {
                url = new URL(name);
            } else {
                URL baseURL = new URL(base);
                url = new URL(baseURL, name);
            }
            log.debug((Object)("Configuration loaded from the URL " + url));
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (url == null && (file = new File(name)).isAbsolute()) {
            try {
                url = file.toURL();
                log.debug((Object)("Configuration loaded from the absolute path " + name));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        if (url == null) {
            try {
                file = ConfigurationUtils.constructFile(base, name);
                if (file != null && file.exists()) {
                    url = file.toURL();
                }
                if (url != null) {
                    log.debug((Object)("Configuration loaded from the base path " + name));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (url == null) {
            try {
                file = ConfigurationUtils.constructFile(System.getProperty("user.home"), name);
                if (file != null && file.exists()) {
                    url = file.toURL();
                }
                if (url != null) {
                    log.debug((Object)("Configuration loaded from the home path " + name));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (url == null && (url = (loader = Thread.currentThread().getContextClassLoader()).getResource(name)) != null) {
            log.debug((Object)("Configuration loaded from the context classpath (" + name + ")"));
        }
        if (url == null && (url = ClassLoader.getSystemResource(name)) != null) {
            log.debug((Object)("Configuration loaded from the system classpath (" + name + ")"));
        }
        return url;
    }

    static String getBasePath(URL url) {
        String s = url.toString();
        if (s.endsWith("/") || StringUtils.isEmpty((String)url.getPath())) {
            return s;
        }
        return s.substring(0, s.lastIndexOf("/") + 1);
    }

    static String getFileName(URL url) {
        if (url == null) {
            return null;
        }
        String path = url.getPath();
        if (path.endsWith("/") || StringUtils.isEmpty((String)path)) {
            return null;
        }
        return path.substring(path.lastIndexOf("/") + 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

