/* Generated By:JavaCC: Do not edit this line. PropertyListParser.java */
package org.apache.commons.configuration.plist;

import java.util.List;
import java.util.ArrayList;

import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration.Node;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.codec.binary.Hex;

/**
 * JavaCC based parser for the PropertyList format.
 *
 * @author Emmanuel Bourg
 * @version $Revision$, $Date: 2005-11-22 21:40:57 +0100 (Tue, 22 Nov 2005) $
 */
class PropertyListParser implements PropertyListParserConstants
{

    /**
     * Remove the quotes at the beginning and at the end of the specified String.
     */
    protected String removeQuotes(String s)
    {
        if (s == null)
        {
            return null;
        }

        if (s.startsWith("\"") && s.endsWith("\"") && s.length() >= 2)
        {
            s = s.substring(1, s.length() - 1);
        }

        return s;
    }

    protected String unescapeQuotes(String s)
    {
        return StringUtils.replace(s, "\\\"", "\"");
    }

    /**
     * Remove the white spaces and the data delimiters from the specified
     * string and parse it as a byte array.
     */
    protected byte[] filterData(String s) throws ParseException
    {
        if (s == null)
        {
            return null;
        }

        // remove the delimiters
        if (s.startsWith("<") && s.endsWith(">") && s.length() >= 2)
        {
            s = s.substring(1, s.length() - 1);
        }

        // remove the white spaces
        s = StringUtils.replaceChars(s, " \t\n\r", "");

        // add a leading 0 to ensure well formed bytes
        if (s.length() % 2 != 0)
        {
            s = "0" + s;
        }

        // parse and return the bytes
        try
        {
            return Hex.decodeHex(s.toCharArray());
        }
        catch (Exception e)
        {
            throw new ParseException(e.getMessage());
        }
    }

    final public PropertyListConfiguration parse() throws ParseException
    {
        PropertyListConfiguration configuration = null;
        configuration = Dictionary();
        jj_consume_token(0);

        return configuration;
    }

    final public PropertyListConfiguration Dictionary() throws ParseException
    {
        PropertyListConfiguration configuration = new PropertyListConfiguration();
        List children = new ArrayList();
        Node child = null;
        jj_consume_token(DICT_BEGIN);
        label_1:
        while (true)
        {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk)
            {
                case STRING:
                case QUOTED_STRING:
                    ;
                    break;
                default:
                    jj_la1[0] = jj_gen;
                    break label_1;
            }
            child = Property();
            if (child.getValue() instanceof HierarchicalConfiguration)
            {
                // prune & graft the nested configuration to the parent configuration
                HierarchicalConfiguration conf = (HierarchicalConfiguration) child.getValue();
                Node root = conf.getRoot();
                root.setName(child.getName());
                children.add(root);
            }
            else
            {
                children.add(child);
            }
        }
        jj_consume_token(DICT_END);
        for (int i = 0; i < children.size(); i++)
        {
            child = (Node) children.get(i);
            configuration.getRoot().addChild(child);
        }

        return configuration;
    }

    final public Node Property() throws ParseException
    {
        Node node = new Node();
        String key = String();
        node.setName(key);
        jj_consume_token(EQUAL);
        Object value = Element();
        node.setValue(value);
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk)
        {
            case DICT_SEPARATOR:
                jj_consume_token(DICT_SEPARATOR);
                break;
            default:
                jj_la1[1] = jj_gen;
                ;
        }

        return node;
    }

    final public Object Element() throws ParseException
    {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk)
        {
            case ARRAY_BEGIN:
                return Array();

            case DICT_BEGIN:
                return Dictionary();

            case STRING:
            case QUOTED_STRING:
                return String();

            case DATA:
                return Data();

            default:
                jj_la1[2] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
    }

    final public List Array() throws ParseException
    {
        List list = new ArrayList();
        Object element = null;
        jj_consume_token(ARRAY_BEGIN);
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk)
        {
            case ARRAY_BEGIN:
            case DICT_BEGIN:
            case DATA:
            case STRING:
            case QUOTED_STRING:
                element = Element();
                list.add(element);
                label_2:
                while (true)
                {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk)
                    {
                        case ARRAY_SEPARATOR:
                            ;
                            break;
                        default:
                            jj_la1[3] = jj_gen;
                            break label_2;
                    }
                    jj_consume_token(ARRAY_SEPARATOR);
                    element = Element();
                    list.add(element);
                }
                break;
            default:
                jj_la1[4] = jj_gen;
                ;
        }
        jj_consume_token(ARRAY_END);

        return list;
    }

    final public String String() throws ParseException
    {
        Token token = null;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk)
        {
            case QUOTED_STRING:
                token = jj_consume_token(QUOTED_STRING);
                return unescapeQuotes(removeQuotes(token.image));

            case STRING:
                token = jj_consume_token(STRING);
                return token.image;

            default:
                jj_la1[5] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
    }

    final public byte[] Data() throws ParseException
    {
        Token token;
        token = jj_consume_token(DATA);

        return filterData(token.image);
    }

    public PropertyListParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token, jj_nt;
    private int jj_ntk;
    private int jj_gen;
    final private int[] jj_la1 = new int[6];
    static private int[] jj_la1_0;

    static
    {
        jj_la1_0();
    }

    private static void jj_la1_0()
    {
        jj_la1_0 = new int[]{0x180000, 0x400, 0x1c0120, 0x80, 0x1c0120, 0x180000, };
    }

    public PropertyListParser(java.io.InputStream stream)
    {
        jj_input_stream = new SimpleCharStream(stream, 1, 1);
        token_source = new PropertyListParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 6; i++) jj_la1[i] = -1;
    }

    public PropertyListParser(java.io.Reader stream)
    {
        jj_input_stream = new SimpleCharStream(stream, 1, 1);
        token_source = new PropertyListParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 6; i++) jj_la1[i] = -1;
    }

    final private Token jj_consume_token(int kind) throws ParseException
    {
        Token oldToken;
        if ((oldToken = token).next != null)
            token = token.next;
        else
            token = token.next = token_source.getNextToken();
        jj_ntk = -1;
        if (token.kind == kind)
        {
            jj_gen++;
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw generateParseException();
    }

    final private int jj_ntk()
    {
        if ((jj_nt = token.next) == null)
            return (jj_ntk = (token.next = token_source.getNextToken()).kind);
        else
            return (jj_ntk = jj_nt.kind);
    }

    private java.util.Vector jj_expentries = new java.util.Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public ParseException generateParseException()
    {
        jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[22];
        for (int i = 0; i < 22; i++)
        {
            la1tokens[i] = false;
        }
        if (jj_kind >= 0)
        {
            la1tokens[jj_kind] = true;
            jj_kind = -1;
        }
        for (int i = 0; i < 6; i++)
        {
            if (jj_la1[i] == jj_gen)
            {
                for (int j = 0; j < 32; j++)
                {
                    if ((jj_la1_0[i] & (1 << j)) != 0)
                    {
                        la1tokens[j] = true;
                    }
                }
            }
        }
        for (int i = 0; i < 22; i++)
        {
            if (la1tokens[i])
            {
                jj_expentry = new int[1];
                jj_expentry[0] = i;
                jj_expentries.addElement(jj_expentry);
            }
        }
        int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i = 0; i < jj_expentries.size(); i++)
        {
            exptokseq[i] = (int[]) jj_expentries.elementAt(i);
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

}
