/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.FileBasedConfiguration;
import org.apache.commons.configuration2.PropertiesConfigurationLayout;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.convert.ValueTransformer;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorAware;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.translate.AggregateTranslator;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.apache.commons.lang3.text.translate.UnicodeEscaper;

public class PropertiesConfiguration
extends BaseConfiguration
implements FileBasedConfiguration,
FileLocatorAware {
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    static final String COMMENT_CHARS = "#!";
    static final String DEFAULT_SEPARATOR = " = ";
    private static final IOFactory DEFAULT_IO_FACTORY = new DefaultIOFactory();
    private static String include = "include";
    private static final char[] SEPARATORS = new char[]{'=', ':'};
    private static final char[] WHITE_SPACE = new char[]{' ', '\t', '\f'};
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int HEX_RADIX = 16;
    private static final int UNICODE_LEN = 4;
    private PropertiesConfigurationLayout layout;
    private IOFactory ioFactory;
    private FileLocator locator;
    private boolean includesAllowed = true;

    public PropertiesConfiguration() {
        this.installLayout(this.createLayout());
    }

    public static String getInclude() {
        return include;
    }

    public static void setInclude(String inc) {
        include = inc;
    }

    public void setIncludesAllowed(boolean includesAllowed) {
        this.includesAllowed = includesAllowed;
    }

    public boolean isIncludesAllowed() {
        return this.includesAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHeader() {
        this.beginRead(false);
        try {
            String string = this.getLayout().getHeaderComment();
            return string;
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeader(String header) {
        this.beginWrite(false);
        try {
            this.getLayout().setHeaderComment(header);
        }
        finally {
            this.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFooter() {
        this.beginRead(false);
        try {
            String string = this.getLayout().getFooterComment();
            return string;
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFooter(String footer) {
        this.beginWrite(false);
        try {
            this.getLayout().setFooterComment(footer);
        }
        finally {
            this.endWrite();
        }
    }

    public PropertiesConfigurationLayout getLayout() {
        return this.layout;
    }

    public void setLayout(PropertiesConfigurationLayout layout) {
        this.installLayout(layout);
    }

    private void installLayout(PropertiesConfigurationLayout layout) {
        if (this.layout != null) {
            this.removeEventListener(ConfigurationEvent.ANY, this.layout);
        }
        this.layout = layout == null ? this.createLayout() : layout;
        this.addEventListener(ConfigurationEvent.ANY, this.layout);
    }

    private PropertiesConfigurationLayout createLayout() {
        return new PropertiesConfigurationLayout();
    }

    public IOFactory getIOFactory() {
        return this.ioFactory != null ? this.ioFactory : DEFAULT_IO_FACTORY;
    }

    public void setIOFactory(IOFactory ioFactory) {
        if (ioFactory == null) {
            throw new IllegalArgumentException("IOFactory must not be null!");
        }
        this.ioFactory = ioFactory;
    }

    @Override
    public void initFileLocator(FileLocator locator) {
        this.locator = locator;
    }

    @Override
    public void read(Reader in) throws ConfigurationException, IOException {
        this.getLayout().load(this, in);
    }

    @Override
    public void write(Writer out) throws ConfigurationException, IOException {
        this.getLayout().save(this, out);
    }

    @Override
    public Object clone() {
        PropertiesConfiguration copy = (PropertiesConfiguration)super.clone();
        if (this.layout != null) {
            copy.setLayout(new PropertiesConfigurationLayout(this.layout));
        }
        return copy;
    }

    boolean propertyLoaded(String key, String value) throws ConfigurationException {
        boolean result;
        if (StringUtils.isNotEmpty((CharSequence)PropertiesConfiguration.getInclude()) && key.equalsIgnoreCase(PropertiesConfiguration.getInclude())) {
            if (this.isIncludesAllowed()) {
                Collection<String> files = this.getListDelimiterHandler().split(value, true);
                for (String f : files) {
                    this.loadIncludeFile(this.interpolate(f));
                }
            }
            result = false;
        } else {
            this.addPropertyInternal(key, value);
            result = true;
        }
        return result;
    }

    static boolean isCommentLine(String line) {
        String s = line.trim();
        return s.length() < 1 || COMMENT_CHARS.indexOf(s.charAt(0)) >= 0;
    }

    private static int countTrailingBS(String line) {
        int bsCount = 0;
        for (int idx = line.length() - 1; idx >= 0 && line.charAt(idx) == '\\'; --idx) {
            ++bsCount;
        }
        return bsCount;
    }

    protected static String unescapeJava(String str) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuilder out = new StringBuilder(sz);
        StringBuilder unicode = new StringBuilder(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    out.append((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new ConfigurationRuntimeException("Unable to parse unicode value: " + unicode, nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                if (ch == '\\') {
                    out.append('\\');
                    continue;
                }
                if (ch == '\'') {
                    out.append('\'');
                    continue;
                }
                if (ch == '\"') {
                    out.append('\"');
                    continue;
                }
                if (ch == 'r') {
                    out.append('\r');
                    continue;
                }
                if (ch == 'f') {
                    out.append('\f');
                    continue;
                }
                if (ch == 't') {
                    out.append('\t');
                    continue;
                }
                if (ch == 'n') {
                    out.append('\n');
                    continue;
                }
                if (ch == 'b') {
                    out.append('\b');
                    continue;
                }
                if (ch == 'u') {
                    inUnicode = true;
                    continue;
                }
                out.append('\\');
                out.append(ch);
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            out.append(ch);
        }
        if (hadSlash) {
            out.append('\\');
        }
        return out.toString();
    }

    private void loadIncludeFile(String fileName) throws ConfigurationException {
        URL baseURL;
        assert (this.locator != null) : "Locator has not been set!";
        URL url = this.locateIncludeFile(this.locator.getBasePath(), fileName);
        if (url == null && (baseURL = this.locator.getSourceURL()) != null) {
            url = this.locateIncludeFile(baseURL.toString(), fileName);
        }
        if (url == null) {
            throw new ConfigurationException("Cannot resolve include file " + fileName);
        }
        FileHandler fh = new FileHandler(this);
        fh.load(url);
    }

    private URL locateIncludeFile(String basePath, String fileName) {
        FileLocator includeLocator = FileLocatorUtils.fileLocator(this.locator).sourceURL(null).basePath(basePath).fileName(fileName).create();
        return FileLocatorUtils.locate(includeLocator);
    }

    public static class DefaultIOFactory
    implements IOFactory {
        @Override
        public PropertiesReader createPropertiesReader(Reader in) {
            return new PropertiesReader(in);
        }

        @Override
        public PropertiesWriter createPropertiesWriter(Writer out, ListDelimiterHandler handler) {
            return new PropertiesWriter(out, handler);
        }
    }

    public static interface IOFactory {
        public PropertiesReader createPropertiesReader(Reader var1);

        public PropertiesWriter createPropertiesWriter(Writer var1, ListDelimiterHandler var2);
    }

    public static class PropertiesWriter
    extends FilterWriter {
        private static final CharSequenceTranslator ESCAPE_PROPERTIES = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])new String[][]{{"\\", "\\\\"}}), new LookupTranslator((CharSequence[][])EntityArrays.JAVA_CTRL_CHARS_ESCAPE()), UnicodeEscaper.outsideOf((int)32, (int)127)});
        private static final ValueTransformer TRANSFORMER = new ValueTransformer(){

            @Override
            public Object transformValue(Object value) {
                String strVal = String.valueOf(value);
                return ESCAPE_PROPERTIES.translate((CharSequence)strVal);
            }
        };
        private final ListDelimiterHandler delimiterHandler;
        private String currentSeparator;
        private String globalSeparator;
        private String lineSeparator;

        public PropertiesWriter(Writer writer, ListDelimiterHandler delHandler) {
            super(writer);
            this.delimiterHandler = delHandler;
        }

        public ListDelimiterHandler getDelimiterHandler() {
            return this.delimiterHandler;
        }

        public String getCurrentSeparator() {
            return this.currentSeparator;
        }

        public void setCurrentSeparator(String currentSeparator) {
            this.currentSeparator = currentSeparator;
        }

        public String getGlobalSeparator() {
            return this.globalSeparator;
        }

        public void setGlobalSeparator(String globalSeparator) {
            this.globalSeparator = globalSeparator;
        }

        public String getLineSeparator() {
            return this.lineSeparator != null ? this.lineSeparator : LINE_SEPARATOR;
        }

        public void setLineSeparator(String lineSeparator) {
            this.lineSeparator = lineSeparator;
        }

        public void writeProperty(String key, Object value) throws IOException {
            this.writeProperty(key, value, false);
        }

        public void writeProperty(String key, List<?> values) throws IOException {
            for (int i = 0; i < values.size(); ++i) {
                this.writeProperty(key, values.get(i));
            }
        }

        public void writeProperty(String key, Object value, boolean forceSingleLine) throws IOException {
            String v;
            if (value instanceof List) {
                v = null;
                List values = (List)value;
                if (forceSingleLine) {
                    try {
                        v = String.valueOf(this.getDelimiterHandler().escapeList(values, TRANSFORMER));
                    }
                    catch (UnsupportedOperationException uoex) {
                        // empty catch block
                    }
                }
                if (v == null) {
                    this.writeProperty(key, values);
                    return;
                }
            } else {
                v = String.valueOf(this.getDelimiterHandler().escape(value, TRANSFORMER));
            }
            this.write(this.escapeKey(key));
            this.write(this.fetchSeparator(key, value));
            this.write(v);
            this.writeln(null);
        }

        public void writeComment(String comment) throws IOException {
            this.writeln("# " + comment);
        }

        protected String escapeKey(String key) {
            StringBuilder newkey = new StringBuilder();
            for (int i = 0; i < key.length(); ++i) {
                char c = key.charAt(i);
                if (ArrayUtils.contains((char[])SEPARATORS, (char)c) || ArrayUtils.contains((char[])WHITE_SPACE, (char)c)) {
                    newkey.append('\\');
                    newkey.append(c);
                    continue;
                }
                newkey.append(c);
            }
            return newkey.toString();
        }

        public void writeln(String s) throws IOException {
            if (s != null) {
                this.write(s);
            }
            this.write(this.getLineSeparator());
        }

        protected String fetchSeparator(String key, Object value) {
            return this.getGlobalSeparator() != null ? this.getGlobalSeparator() : this.getCurrentSeparator();
        }
    }

    public static class PropertiesReader
    extends LineNumberReader {
        private static final Pattern PROPERTY_PATTERN = Pattern.compile("(([\\S&&[^\\\\" + new String(PropertiesConfiguration.access$000()) + "]]|\\\\.)*)(\\s*(\\s+|[" + new String(PropertiesConfiguration.access$000()) + "])\\s*)(.*)");
        private static final int IDX_KEY = 1;
        private static final int IDX_VALUE = 5;
        private static final int IDX_SEPARATOR = 3;
        private final List<String> commentLines = new ArrayList<String>();
        private String propertyName;
        private String propertyValue;
        private String propertySeparator = " = ";

        public PropertiesReader(Reader reader) {
            super(reader);
        }

        public String readProperty() throws IOException {
            String line;
            this.commentLines.clear();
            StringBuilder buffer = new StringBuilder();
            while (true) {
                if ((line = this.readLine()) == null) {
                    return null;
                }
                if (PropertiesConfiguration.isCommentLine(line)) {
                    this.commentLines.add(line);
                    continue;
                }
                if (!PropertiesReader.checkCombineLines(line = line.trim())) break;
                line = line.substring(0, line.length() - 1);
                buffer.append(line);
            }
            buffer.append(line);
            return buffer.toString();
        }

        public boolean nextProperty() throws IOException {
            String line = this.readProperty();
            if (line == null) {
                return false;
            }
            this.parseProperty(line);
            return true;
        }

        public List<String> getCommentLines() {
            return this.commentLines;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        public String getPropertySeparator() {
            return this.propertySeparator;
        }

        protected void parseProperty(String line) {
            String[] property = PropertiesReader.doParseProperty(line);
            this.initPropertyName(property[0]);
            this.initPropertyValue(property[1]);
            this.initPropertySeparator(property[2]);
        }

        protected void initPropertyName(String name) {
            this.propertyName = StringEscapeUtils.unescapeJava((String)name);
        }

        protected void initPropertyValue(String value) {
            this.propertyValue = PropertiesConfiguration.unescapeJava(value);
        }

        protected void initPropertySeparator(String value) {
            this.propertySeparator = value;
        }

        private static boolean checkCombineLines(String line) {
            return PropertiesConfiguration.countTrailingBS(line) % 2 != 0;
        }

        private static String[] doParseProperty(String line) {
            Matcher matcher = PROPERTY_PATTERN.matcher(line);
            String[] result = new String[]{"", "", ""};
            if (matcher.matches()) {
                result[0] = matcher.group(1).trim();
                result[1] = matcher.group(5).trim();
                result[2] = matcher.group(3);
            }
            return result;
        }
    }
}

