/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractImmutableNodeHandler
implements NodeHandler<ImmutableNode> {
    AbstractImmutableNodeHandler() {
    }

    @Override
    public String nodeName(ImmutableNode node) {
        return node.getNodeName();
    }

    @Override
    public Object getValue(ImmutableNode node) {
        return node.getValue();
    }

    @Override
    public List<ImmutableNode> getChildren(ImmutableNode node) {
        return node.getChildren();
    }

    @Override
    public List<ImmutableNode> getChildren(ImmutableNode node, String name) {
        ArrayList<ImmutableNode> result = new ArrayList<ImmutableNode>(node.getChildren().size());
        for (ImmutableNode c : node.getChildren()) {
            if (!StringUtils.equals((CharSequence)name, (CharSequence)c.getNodeName())) continue;
            result.add(c);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public ImmutableNode getChild(ImmutableNode node, int index) {
        return node.getChildren().get(index);
    }

    @Override
    public int indexOfChild(ImmutableNode parent, ImmutableNode child) {
        return parent.getChildren().indexOf(child);
    }

    @Override
    public int getChildrenCount(ImmutableNode node, String name) {
        if (name == null) {
            return node.getChildren().size();
        }
        return this.getChildren(node, name).size();
    }

    @Override
    public Set<String> getAttributes(ImmutableNode node) {
        return node.getAttributes().keySet();
    }

    @Override
    public boolean hasAttributes(ImmutableNode node) {
        return !node.getAttributes().isEmpty();
    }

    @Override
    public Object getAttributeValue(ImmutableNode node, String name) {
        return node.getAttributes().get(name);
    }

    @Override
    public boolean isDefined(ImmutableNode node) {
        return AbstractImmutableNodeHandler.checkIfNodeDefined(node);
    }

    static boolean checkIfNodeDefined(ImmutableNode node) {
        return node.getValue() != null || !node.getChildren().isEmpty() || !node.getAttributes().isEmpty();
    }
}

