/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.junit.Assert;

public class ConfigurationAssert {
    public static final String TEST_DIR_NAME = "target/test-classes";
    public static final String OUT_DIR_NAME = "target";
    public static final File TEST_DIR = new File("target/test-classes");
    public static final File OUT_DIR = new File("target");

    public static void assertConfigurationEquals(Configuration expected, Configuration actual) {
        String key;
        Iterator it = expected.getKeys();
        while (it.hasNext()) {
            key = (String)it.next();
            Assert.assertTrue((String)("The actual configuration doesn't contain the expected key '" + key + "'"), (boolean)actual.containsKey(key));
            Assert.assertEquals((String)("Value of the '" + key + "' property"), (Object)expected.getProperty(key), (Object)actual.getProperty(key));
        }
        it = actual.getKeys();
        while (it.hasNext()) {
            key = (String)it.next();
            Assert.assertTrue((String)("The actual configuration contains an extra key '" + key + "'"), (boolean)expected.containsKey(key));
        }
    }

    public static File getTestFile(String name) {
        return new File(TEST_DIR, name);
    }

    public static File getOutFile(String name) {
        return new File(OUT_DIR, name);
    }

    public static URL getTestURL(String name) {
        return ConfigurationAssert.urlFromFile(ConfigurationAssert.getTestFile(name));
    }

    public static URL getOutURL(String name) {
        return ConfigurationAssert.urlFromFile(ConfigurationAssert.getOutFile(name));
    }

    public static void checkEquals(Object o1, Object o2, boolean expEquals) {
        Assert.assertEquals((String)"Wrong result of equals()", (Object)expEquals, (Object)o1.equals(o2));
        if (o2 != null) {
            Assert.assertEquals((String)"Not symmetric", (Object)expEquals, (Object)o2.equals(o1));
        }
        if (expEquals) {
            Assert.assertEquals((String)"Different hash codes", (long)o1.hashCode(), (long)o2.hashCode());
        }
    }

    public static List<String> keysToList(Configuration config) {
        LinkedList<String> keyList = new LinkedList<String>();
        ConfigurationAssert.appendKeys(config, keyList);
        return keyList;
    }

    public static Set<String> keysToSet(Configuration config) {
        HashSet<String> keySet = new HashSet<String>();
        ConfigurationAssert.appendKeys(config, keySet);
        return keySet;
    }

    public static void appendKeys(Configuration config, Collection<String> collection) {
        Iterator it = config.getKeys();
        while (it.hasNext()) {
            collection.add((String)it.next());
        }
    }

    private static URL urlFromFile(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException mex) {
            throw new ConfigurationRuntimeException((Throwable)mex);
        }
    }
}

