/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration2.AbstractHierarchicalConfiguration;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ImmutableHierarchicalConfiguration;
import org.apache.commons.configuration2.InterpolationTestHelper;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.configuration2.SynchronizerTestImpl;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventListenerTestImpl;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.apache.commons.configuration2.tree.DefaultConfigurationKey;
import org.apache.commons.configuration2.tree.DefaultExpressionEngine;
import org.apache.commons.configuration2.tree.DefaultExpressionEngineSymbols;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeModel;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAbstractHierarchicalConfiguration {
    private AbstractHierarchicalConfiguration<ImmutableNode> config;

    @Before
    public void setUp() throws Exception {
        ImmutableNode root = new ImmutableNode.Builder(1).addChild(NodeStructureHelper.ROOT_TABLES_TREE).create();
        this.config = new AbstractHierarchicalConfigurationTestImpl(new InMemoryNodeModel(root));
    }

    private ImmutableNode getRootNode() {
        return (ImmutableNode)this.config.getModel().getNodeHandler().getRootNode();
    }

    @Test
    public void testIsEmptyFalse() {
        Assert.assertFalse((boolean)this.config.isEmpty());
    }

    @Test
    public void testIsEmptyRootOnly() {
        this.config = new AbstractHierarchicalConfigurationTestImpl(new InMemoryNodeModel());
        Assert.assertTrue((String)"Not empty", (boolean)this.config.isEmpty());
    }

    @Test
    public void testIsEmptyNodesWithNoValues() {
        ImmutableNode.Builder rootBuilder = new ImmutableNode.Builder(1);
        ImmutableNode.Builder nodeBuilder = new ImmutableNode.Builder(1);
        nodeBuilder.addChild(NodeStructureHelper.createNode("child", null));
        rootBuilder.addChild(nodeBuilder.create());
        this.config = new AbstractHierarchicalConfigurationTestImpl(new InMemoryNodeModel(rootBuilder.create()));
        Assert.assertTrue((String)"Not empty", (boolean)this.config.isEmpty());
    }

    private static void checkGetProperty(AbstractHierarchicalConfiguration<?> testConfig) {
        Assert.assertNull((Object)testConfig.getProperty("tables.table.resultset"));
        Assert.assertNull((Object)testConfig.getProperty("tables.table.fields.field"));
        Object prop = testConfig.getProperty("tables.table(0).fields.field.name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)NodeStructureHelper.fieldsLength(0), (long)((Collection)prop).size());
        prop = testConfig.getProperty("tables.table.fields.field.name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)TestAbstractHierarchicalConfiguration.totalFieldCount(), (long)((Collection)prop).size());
        prop = testConfig.getProperty("tables.table.fields.field(3).name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)2L, (long)((Collection)prop).size());
        prop = testConfig.getProperty("tables.table(1).fields.field(2).name");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)"creationDate", (Object)prop.toString());
    }

    @Test
    public void testGetProperty() {
        TestAbstractHierarchicalConfiguration.checkGetProperty(this.config);
    }

    @Test
    public void testSetProperty() {
        this.config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        this.config.setProperty("tables.table(0).name", (Object)"resources");
        Assert.assertEquals((Object)"resources", (Object)this.config.getString("tables.table(0).name"));
        this.config.setProperty("tables.table.name", (Object)"tab1,tab2");
        Assert.assertEquals((Object)"tab1", (Object)this.config.getString("tables.table(0).name"));
        Assert.assertEquals((Object)"tab2", (Object)this.config.getString("tables.table(1).name"));
        this.config.setProperty("test.items.item", (Object)new int[]{2, 4, 8, 16});
        Assert.assertEquals((long)3L, (long)this.config.getMaxIndex("test.items.item"));
        Assert.assertEquals((long)8L, (long)this.config.getInt("test.items.item(2)"));
        this.config.setProperty("test.items.item(2)", (Object)new Integer(6));
        Assert.assertEquals((long)6L, (long)this.config.getInt("test.items.item(2)"));
        this.config.setProperty("test.items.item(2)", (Object)new int[]{7, 9, 11});
        Assert.assertEquals((long)5L, (long)this.config.getMaxIndex("test.items.item"));
        this.config.setProperty("test", (Object)Boolean.TRUE);
        this.config.setProperty("test.items", (Object)"01/01/05");
        Assert.assertEquals((long)5L, (long)this.config.getMaxIndex("test.items.item"));
        Assert.assertTrue((boolean)this.config.getBoolean("test"));
        Assert.assertEquals((Object)"01/01/05", (Object)this.config.getProperty("test.items"));
        this.config.setProperty("test.items.item", (Object)new Integer(42));
        Assert.assertEquals((long)0L, (long)this.config.getMaxIndex("test.items.item"));
        Assert.assertEquals((long)42L, (long)this.config.getInt("test.items.item"));
    }

    @Test
    public void testClear() {
        this.config.setProperty(null, (Object)"value");
        this.config.addProperty("[@attr]", (Object)"defined");
        this.config.clear();
        Assert.assertTrue((String)"Configuration not empty", (boolean)this.config.isEmpty());
    }

    @Test
    public void testClearProperty() {
        this.config.clearProperty("tables.table(0).fields.field(0).name");
        Assert.assertEquals((Object)"uname", (Object)this.config.getProperty("tables.table(0).fields.field(0).name"));
        this.config.clearProperty("tables.table(0).name");
        Assert.assertFalse((boolean)this.config.containsKey("tables.table(0).name"));
        Assert.assertEquals((Object)"firstName", (Object)this.config.getProperty("tables.table(0).fields.field(1).name"));
        Assert.assertEquals((Object)"documents", (Object)this.config.getProperty("tables.table.name"));
        this.config.clearProperty("tables.table");
        Assert.assertEquals((Object)"documents", (Object)this.config.getProperty("tables.table.name"));
        this.config.addProperty("test", (Object)"first");
        this.config.addProperty("test.level", (Object)"second");
        this.config.clearProperty("test");
        Assert.assertEquals((Object)"second", (Object)this.config.getString("test.level"));
        Assert.assertFalse((boolean)this.config.containsKey("test"));
    }

    @Test
    public void testClearTree() {
        Object prop = this.config.getProperty("tables.table(0).fields.field.name");
        Assert.assertNotNull((Object)prop);
        this.config.clearTree("tables.table(0).fields.field(3)");
        prop = this.config.getProperty("tables.table(0).fields.field.name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)4L, (long)((Collection)prop).size());
        this.config.clearTree("tables.table(0).fields");
        Assert.assertNull((Object)this.config.getProperty("tables.table(0).fields.field.name"));
        prop = this.config.getProperty("tables.table.fields.field.name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)NodeStructureHelper.fieldsLength(1), (long)((Collection)prop).size());
        this.config.clearTree("tables.table(1)");
        Assert.assertNull((Object)this.config.getProperty("tables.table.fields.field.name"));
    }

    @Test
    public void testClearTreeComplex() {
        String name;
        int count = 5;
        for (int idx = 0; idx < 5; ++idx) {
            this.config.addProperty("indexList.index(-1)[@default]", (Object)Boolean.FALSE);
            this.config.addProperty("indexList.index[@name]", (Object)("test" + idx));
            this.config.addProperty("indexList.index.dir", (Object)("testDir" + idx));
        }
        Assert.assertEquals((String)"Wrong number of nodes", (long)4L, (long)this.config.getMaxIndex("indexList.index[@name]"));
        boolean found = false;
        int idx = 0;
        while ((name = this.config.getString("indexList.index(" + idx + ")[@name]")) != null) {
            if ("test3".equals(name)) {
                Assert.assertEquals((String)"Wrong dir", (Object)"testDir3", (Object)this.config.getString("indexList.index(" + idx + ").dir"));
                this.config.clearTree("indexList.index(" + idx + ")");
                found = true;
            }
            ++idx;
        }
        Assert.assertTrue((String)"Key to remove not found", (boolean)found);
        Assert.assertEquals((String)"Wrong number of nodes after remove", (long)3L, (long)this.config.getMaxIndex("indexList.index[@name]"));
        Assert.assertEquals((String)"Wrong number of dir nodes after remove", (long)3L, (long)this.config.getMaxIndex("indexList.index.dir"));
        idx = 0;
        while ((name = this.config.getString("indexList.index(" + idx + ")[@name]")) != null) {
            if ("test3".equals(name)) {
                Assert.fail((String)"Key was not removed!");
            }
            ++idx;
        }
    }

    @Test
    public void testClearTreeHierarchy() {
        this.config.addProperty("a.b.c", (Object)"c");
        this.config.addProperty("a.b.c.d", (Object)"d");
        this.config.addProperty("a.b.c.d.e", (Object)"e");
        this.config.clearTree("a.b.c");
        Assert.assertFalse((String)"Property not removed", (boolean)this.config.containsKey("a.b.c"));
        Assert.assertFalse((String)"Sub property not removed", (boolean)this.config.containsKey("a.b.c.d"));
    }

    @Test
    public void testContainsKey() {
        Assert.assertTrue((boolean)this.config.containsKey("tables.table(0).name"));
        Assert.assertTrue((boolean)this.config.containsKey("tables.table(1).name"));
        Assert.assertFalse((boolean)this.config.containsKey("tables.table(2).name"));
        Assert.assertTrue((boolean)this.config.containsKey("tables.table(0).fields.field.name"));
        Assert.assertFalse((boolean)this.config.containsKey("tables.table(0).fields.field"));
        this.config.clearTree("tables.table(0).fields");
        Assert.assertFalse((boolean)this.config.containsKey("tables.table(0).fields.field.name"));
        Assert.assertTrue((boolean)this.config.containsKey("tables.table.fields.field.name"));
    }

    @Test
    public void testGetKeys() {
        ArrayList keys = new ArrayList();
        Iterator it = this.config.getKeys();
        while (it.hasNext()) {
            keys.add(it.next());
        }
        Assert.assertEquals((long)2L, (long)keys.size());
        Assert.assertTrue((boolean)keys.contains("tables.table.name"));
        Assert.assertTrue((boolean)keys.contains("tables.table.fields.field.name"));
    }

    @Test
    public void testGetKeysOrder() {
        this.config.addProperty("order.key1", (Object)"value1");
        this.config.addProperty("order.key2", (Object)"value2");
        this.config.addProperty("order.key3", (Object)"value3");
        Iterator it = this.config.getKeys("order");
        Assert.assertEquals((String)"1st key", (Object)"order.key1", it.next());
        Assert.assertEquals((String)"2nd key", (Object)"order.key2", it.next());
        Assert.assertEquals((String)"3rd key", (Object)"order.key3", it.next());
    }

    @Test
    public void testGetKeysAttribute() {
        this.config.addProperty("tables.table(0)[@type]", (Object)"system");
        HashSet keys = new HashSet();
        Iterator it = this.config.getKeys();
        while (it.hasNext()) {
            keys.add(it.next());
        }
        Assert.assertTrue((String)("Attribute key not found: " + keys), (boolean)keys.contains("tables.table[@type]"));
    }

    @Test
    public void testGetKeysAttributePrefix() {
        this.config.addProperty("tables.table(0)[@type]", (Object)"system");
        Iterator itKeys = this.config.getKeys("tables.table[@type]");
        Assert.assertEquals((String)"Wrong key", (Object)"tables.table[@type]", itKeys.next());
        Assert.assertFalse((String)"Too many keys", (boolean)itKeys.hasNext());
    }

    @Test
    public void testGetKeysString() {
        this.config.addProperty("tables.table(0).fields.field(1).type", (Object)"VARCHAR");
        this.config.addProperty("tables.table(0)[@type]", (Object)"system");
        this.config.addProperty("tables.table(0).size", (Object)"42");
        this.config.addProperty("tables.table(0).fields.field(0).size", (Object)"128");
        this.config.addProperty("connections.connection.param.url", (Object)"url1");
        this.config.addProperty("connections.connection.param.user", (Object)"me");
        this.config.addProperty("connections.connection.param.pwd", (Object)"secret");
        this.config.addProperty("connections.connection(-1).param.url", (Object)"url2");
        this.config.addProperty("connections.connection(1).param.user", (Object)"guest");
        this.checkKeys("tables.table(1)", new String[]{"name", "fields.field.name"});
        this.checkKeys("tables.table(0)", new String[]{"name", "fields.field.name", "tables.table(0)[@type]", "size", "fields.field.type", "fields.field.size"});
        this.checkKeys("connections.connection(0).param", new String[]{"url", "user", "pwd"});
        this.checkKeys("connections.connection(1).param", new String[]{"url", "user"});
    }

    @Test
    public void testGetKeysWithKeyAsPrefix() {
        this.config.addProperty("order.key1", (Object)"value1");
        this.config.addProperty("order.key2", (Object)"value2");
        Iterator it = this.config.getKeys("order.key1");
        Assert.assertTrue((String)"no key found", (boolean)it.hasNext());
        Assert.assertEquals((String)"1st key", (Object)"order.key1", it.next());
        Assert.assertFalse((String)"more keys than expected", (boolean)it.hasNext());
    }

    @Test
    public void testGetKeysWithKeyAsPrefixMultiple() {
        this.config.addProperty("order.key1", (Object)"value1");
        this.config.addProperty("order.key1.test", (Object)"value2");
        this.config.addProperty("order.key1.test.complex", (Object)"value2");
        Iterator it = this.config.getKeys("order.key1");
        Assert.assertEquals((String)"Wrong key 1", (Object)"order.key1", it.next());
        Assert.assertEquals((String)"Wrong key 2", (Object)"order.key1.test", it.next());
        Assert.assertEquals((String)"Wrong key 3", (Object)"order.key1.test.complex", it.next());
        Assert.assertFalse((String)"More keys than expected", (boolean)it.hasNext());
    }

    @Test
    public void testSize() {
        Assert.assertEquals((String)"Wrong size", (long)2L, (long)this.config.size());
    }

    @Test
    public void testAddProperty() {
        this.config.addProperty("tables.table(0).fields.field(-1).name", (Object)"phone");
        Object prop = this.config.getProperty("tables.table(0).fields.field.name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)6L, (long)((Collection)prop).size());
        this.config.addProperty("tables.table(0).fields.field.name", (Object)"fax");
        prop = this.config.getProperty("tables.table.fields.field(5).name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof List));
        List list = (List)prop;
        Assert.assertEquals((Object)"phone", list.get(0));
        Assert.assertEquals((Object)"fax", list.get(1));
        this.config.addProperty("tables.table(-1).name", (Object)"config");
        prop = this.config.getProperty("tables.table.name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)3L, (long)((Collection)prop).size());
        this.config.addProperty("tables.table(2).fields.field(0).name", (Object)"cid");
        this.config.addProperty("tables.table(2).fields.field(-1).name", (Object)"confName");
        prop = this.config.getProperty("tables.table(2).fields.field.name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)2L, (long)((Collection)prop).size());
        Assert.assertEquals((Object)"confName", (Object)this.config.getProperty("tables.table(2).fields.field(1).name"));
        this.config.addProperty("connection.user", (Object)"scott");
        this.config.addProperty("connection.passwd", (Object)"tiger");
        Assert.assertEquals((Object)"tiger", (Object)this.config.getProperty("connection.passwd"));
        DefaultConfigurationKey key = TestAbstractHierarchicalConfiguration.createConfigurationKey();
        key.append("tables").append("table").appendIndex(0);
        key.appendAttribute("tableType");
        this.config.addProperty(key.toString(), (Object)"system");
        Assert.assertEquals((Object)"system", (Object)this.config.getProperty(key.toString()));
    }

    private static DefaultConfigurationKey createConfigurationKey() {
        return new DefaultConfigurationKey(DefaultExpressionEngine.INSTANCE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddPropertyInvalidKey() {
        this.config.addProperty(".", (Object)"InvalidKey");
    }

    @Test
    public void testGetMaxIndex() {
        Assert.assertEquals((long)(NodeStructureHelper.fieldsLength(0) - 1), (long)this.config.getMaxIndex("tables.table(0).fields.field"));
        Assert.assertEquals((long)(NodeStructureHelper.fieldsLength(1) - 1), (long)this.config.getMaxIndex("tables.table(1).fields.field"));
        Assert.assertEquals((long)1L, (long)this.config.getMaxIndex("tables.table"));
        Assert.assertEquals((long)1L, (long)this.config.getMaxIndex("tables.table.name"));
        Assert.assertEquals((long)0L, (long)this.config.getMaxIndex("tables.table(0).name"));
        Assert.assertEquals((long)0L, (long)this.config.getMaxIndex("tables.table(1).fields.field(1)"));
        Assert.assertEquals((long)-1L, (long)this.config.getMaxIndex("tables.table(2).fields"));
        int maxIdx = this.config.getMaxIndex("tables.table(0).fields.field.name");
        for (int i = 0; i <= maxIdx; ++i) {
            DefaultConfigurationKey key = new DefaultConfigurationKey(DefaultExpressionEngine.INSTANCE, "tables.table(0).fields");
            key.append("field").appendIndex(i).append("name");
            Assert.assertNotNull((Object)this.config.getProperty(key.toString()));
        }
    }

    @Test
    public void testClone() {
        Configuration copy = (Configuration)this.config.clone();
        Assert.assertTrue((String)"Wrong clone result", (boolean)(copy instanceof AbstractHierarchicalConfiguration));
        TestAbstractHierarchicalConfiguration.checkContent(copy);
    }

    @Test
    public void testCloneWithEventListeners() {
        EventListenerTestImpl l = new EventListenerTestImpl(null);
        this.config.addEventListener(ConfigurationEvent.ANY, (EventListener)l);
        AbstractHierarchicalConfiguration copy = (AbstractHierarchicalConfiguration)this.config.clone();
        Assert.assertFalse((String)"Event listener registered at clone", (boolean)copy.getEventListeners(ConfigurationEvent.ANY).contains(l));
    }

    @Test
    public void testCloneInterpolation() {
        String keyAnswer = "answer";
        String keyValue = "value";
        this.config.addProperty("answer", (Object)"The answer is ${value}.");
        this.config.addProperty("value", (Object)42);
        Configuration clone = (Configuration)this.config.clone();
        clone.setProperty("value", (Object)43);
        Assert.assertEquals((String)"Wrong interpolation in original", (Object)"The answer is 42.", (Object)this.config.getString("answer"));
        Assert.assertEquals((String)"Wrong interpolation in clone", (Object)"The answer is 43.", (Object)clone.getString("answer"));
    }

    @Test
    public void testAddNodes() {
        ArrayList<ImmutableNode> nodes = new ArrayList<ImmutableNode>();
        nodes.add(NodeStructureHelper.createFieldNode("birthDate"));
        nodes.add(NodeStructureHelper.createFieldNode("lastLogin"));
        nodes.add(NodeStructureHelper.createFieldNode("language"));
        this.config.addNodes("tables.table(0).fields", nodes);
        Assert.assertEquals((long)7L, (long)this.config.getMaxIndex("tables.table(0).fields.field"));
        Assert.assertEquals((Object)"birthDate", (Object)this.config.getString("tables.table(0).fields.field(5).name"));
        Assert.assertEquals((Object)"lastLogin", (Object)this.config.getString("tables.table(0).fields.field(6).name"));
        Assert.assertEquals((Object)"language", (Object)this.config.getString("tables.table(0).fields.field(7).name"));
    }

    @Test
    public void testAddNodesForNonExistingKey() {
        ArrayList<ImmutableNode> nodes = new ArrayList<ImmutableNode>();
        ImmutableNode newNode = new ImmutableNode.Builder().name("usr").value((Object)"scott").addAttribute("pwd", (Object)"tiger").create();
        nodes.add(newNode);
        this.config.addNodes("database.connection.settings", nodes);
        Assert.assertEquals((String)"Usr node not found", (Object)"scott", (Object)this.config.getString("database.connection.settings.usr"));
        Assert.assertEquals((String)"Pwd node not found", (Object)"tiger", (Object)this.config.getString("database.connection.settings.usr[@pwd]"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddNodesWithAttributeKey() {
        ArrayList<ImmutableNode> nodes = new ArrayList<ImmutableNode>();
        nodes.add(NodeStructureHelper.createNode("testNode", "yes"));
        this.config.addNodes("database.connection[@settings]", nodes);
    }

    @Test
    public void testAddNodesCopy() {
        AbstractHierarchicalConfigurationTestImpl configDest = new AbstractHierarchicalConfigurationTestImpl(new InMemoryNodeModel());
        configDest.addProperty("test", "TEST");
        List nodes = this.getRootNode().getChildren();
        Assert.assertEquals((String)"Wrong number of children", (long)1L, (long)nodes.size());
        configDest.addNodes("newNodes", nodes);
        for (int i = 0; i < NodeStructureHelper.tablesLength(); ++i) {
            String keyTab = "newNodes.tables.table(" + i + ").";
            Assert.assertEquals((String)("Table " + i + " not found"), (Object)NodeStructureHelper.table(i), (Object)configDest.getString(keyTab + "name"));
            for (int j = 0; j < NodeStructureHelper.fieldsLength(i); ++j) {
                Assert.assertEquals((String)("Invalid field " + j + " in table " + i), (Object)NodeStructureHelper.field(i, j), (Object)configDest.getString(keyTab + "fields.field(" + j + ").name"));
            }
        }
    }

    @Test
    public void testSetExpressionEngine() {
        this.config.setExpressionEngine(null);
        Assert.assertNotNull((String)"Expression engine is null", (Object)this.config.getExpressionEngine());
        Assert.assertSame((String)"Default engine is not used", (Object)DefaultExpressionEngine.INSTANCE, (Object)this.config.getExpressionEngine());
        this.config.setExpressionEngine(this.createAlternativeExpressionEngine());
        this.checkAlternativeSyntax();
    }

    @Test
    public void testInterpolation() {
        this.config.addProperty("base.dir", (Object)"/home/foo");
        this.config.addProperty("test.absolute.dir.dir1", (Object)"${base.dir}/path1");
        this.config.addProperty("test.absolute.dir.dir2", (Object)"${base.dir}/path2");
        this.config.addProperty("test.absolute.dir.dir3", (Object)"${base.dir}/path3");
        Configuration sub = this.config.subset("test.absolute.dir");
        for (int i = 1; i < 4; ++i) {
            Assert.assertEquals((String)"Wrong interpolation in parent", (Object)("/home/foo/path" + i), (Object)this.config.getString("test.absolute.dir.dir" + i));
            Assert.assertEquals((String)"Wrong interpolation in subnode", (Object)("/home/foo/path" + i), (Object)sub.getString("dir" + i));
        }
    }

    @Test
    public void testInterpolationBasic() {
        InterpolationTestHelper.testInterpolation(this.config);
    }

    @Test
    public void testInterpolationMultipleLevels() {
        InterpolationTestHelper.testMultipleInterpolation(this.config);
    }

    @Test
    public void testInterpolationLoop() {
        InterpolationTestHelper.testInterpolationLoop(this.config);
    }

    @Test
    public void testInterpolationSubset() {
        InterpolationTestHelper.testInterpolationSubset(this.config);
    }

    @Test
    public void testInterpolationSubsetMultipleLayers() {
        this.config.clear();
        this.config.addProperty("var", (Object)"value");
        this.config.addProperty("prop2.prop[@attr]", (Object)"${var}");
        Configuration sub1 = this.config.subset("prop2");
        Configuration sub2 = sub1.subset("prop");
        Assert.assertEquals((String)"Wrong value", (Object)"value", (Object)sub2.getString("[@attr]"));
    }

    @Test
    public void testInterpolationUnknownProperty() {
        InterpolationTestHelper.testInterpolationUnknownProperty(this.config);
    }

    @Test
    public void testInterpolationSysProperties() {
        InterpolationTestHelper.testInterpolationSystemProperties(this.config);
    }

    @Test
    public void testInterpolationConstants() {
        InterpolationTestHelper.testInterpolationConstants(this.config);
    }

    @Test
    public void testInterpolationEscaped() {
        InterpolationTestHelper.testInterpolationEscaped(this.config);
    }

    @Test
    public void testInterpolator() {
        InterpolationTestHelper.testGetInterpolator(this.config);
    }

    @Test
    public void testInterpolatedConfiguration() {
        this.config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        AbstractHierarchicalConfiguration c = (AbstractHierarchicalConfiguration)InterpolationTestHelper.testInterpolatedConfiguration(this.config);
        TestAbstractHierarchicalConfiguration.checkGetProperty(c);
    }

    @Test
    public void testInitCopyNull() {
        BaseHierarchicalConfiguration copy = new BaseHierarchicalConfiguration((HierarchicalConfiguration)((BaseHierarchicalConfiguration)null));
        Assert.assertTrue((String)"Configuration not empty", (boolean)copy.isEmpty());
    }

    @Test
    public void testGetPropertyKeyWithBrackets() {
        String key = "test.directory.platform(x86)";
        this.config.addProperty("test.directory.platform(x86)", (Object)"C:\\Temp");
        Assert.assertEquals((String)"Wrong property value", (Object)"C:\\Temp", (Object)this.config.getString("test.directory.platform(x86)"));
    }

    @Test
    public void testAddPropertyWithListHandling() {
        this.config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        String key = "list.delimiter.value";
        this.config.addProperty("list.delimiter.value.escaped", (Object)"3\\,1415");
        this.config.addProperty("list.delimiter.value.elements", (Object)"3,1415");
        Assert.assertEquals((String)"Wrong escaped property", (Object)"3,1415", (Object)this.config.getString("list.delimiter.value.escaped"));
        Assert.assertEquals((String)"Wrong list property", (Object)"3", (Object)this.config.getString("list.delimiter.value.elements"));
    }

    @Test
    public void testResolveNodeKey() {
        List nodes = this.config.resolveNodeKey((Object)this.getRootNode(), "tables.table.name", this.config.getModel().getNodeHandler());
        Assert.assertEquals((String)"Wrong number of nodes", (long)NodeStructureHelper.tablesLength(), (long)nodes.size());
        for (int i = 0; i < NodeStructureHelper.tablesLength(); ++i) {
            Assert.assertEquals((String)("Wrong node value at " + i), (Object)NodeStructureHelper.table(i), (Object)((ImmutableNode)nodes.get(i)).getValue());
        }
    }

    @Test
    public void testResolveNodeKeyAttribute() {
        String attrKey = "tables.table(0)[@type]";
        this.config.addProperty(attrKey, (Object)"system");
        Assert.assertTrue((String)"Got attribute results", (boolean)this.config.resolveNodeKey((Object)this.getRootNode(), attrKey, this.config.getModel().getNodeHandler()).isEmpty());
    }

    @Test
    public void testNodeKeyEmptyCache() {
        HashMap cache = new HashMap();
        ImmutableNode nodeTabName = NodeStructureHelper.nodeForKey(this.getRootNode(), "tables/table(0)/name");
        ImmutableNode nodeFldName = NodeStructureHelper.nodeForKey(this.getRootNode(), "tables/table(0)/fields/field(1)/name");
        Assert.assertEquals((String)"Wrong key (1)", (Object)"tables(0).table(0).name(0)", (Object)this.config.nodeKey((Object)nodeTabName, cache, this.config.getModel().getNodeHandler()));
        Assert.assertEquals((String)"Wrong key (2)", (Object)"tables(0).table(0).fields(0).field(1).name(0)", (Object)this.config.nodeKey((Object)nodeFldName, cache, this.config.getModel().getNodeHandler()));
    }

    @Test
    public void testNodeKeyCachePopulated() {
        HashMap cache = new HashMap();
        ImmutableNode nodeTabName = NodeStructureHelper.nodeForKey(this.getRootNode(), "tables/table(0)/name");
        NodeHandler handler = this.config.getModel().getNodeHandler();
        this.config.nodeKey((Object)nodeTabName, cache, handler);
        Assert.assertEquals((String)"Wrong number of elements", (long)4L, (long)cache.size());
        Assert.assertEquals((String)"Wrong entry (1)", (Object)"tables(0).table(0).name(0)", cache.get(nodeTabName));
        Assert.assertEquals((String)"Wrong entry (2)", (Object)"tables(0).table(0)", cache.get(handler.getParent((Object)nodeTabName)));
        Assert.assertEquals((String)"Wrong entry (3)", (Object)"tables(0)", cache.get(handler.getParent(handler.getParent((Object)nodeTabName))));
        Assert.assertEquals((String)"Wrong root entry", (Object)"", cache.get(this.getRootNode()));
    }

    @Test
    public void testNodeKeyCacheUsage() {
        HashMap<Object, String> cache = new HashMap<Object, String>();
        ImmutableNode nodeTabName = NodeStructureHelper.nodeForKey(this.getRootNode(), "tables/table(0)/name");
        NodeHandler handler = this.config.getModel().getNodeHandler();
        cache.put(handler.getParent((Object)nodeTabName), "somePrefix");
        Assert.assertEquals((String)"Wrong key", (Object)"somePrefix.name(0)", (Object)this.config.nodeKey((Object)nodeTabName, cache, handler));
    }

    @Test
    public void testNodeKeyRootNode() {
        HashMap cache = new HashMap();
        Assert.assertEquals((String)"Wrong root node key", (Object)"", (Object)this.config.nodeKey((Object)this.getRootNode(), cache, this.config.getModel().getNodeHandler()));
    }

    @Test
    public void testNodeKeyCacheHit() {
        HashMap<ImmutableNode, String> cache = new HashMap<ImmutableNode, String>();
        String key = "someResultKey";
        cache.put(this.getRootNode(), "someResultKey");
        Assert.assertEquals((String)"Wrong result", (Object)"someResultKey", (Object)this.config.nodeKey((Object)this.getRootNode(), cache, this.config.getModel().getNodeHandler()));
    }

    @Test
    public void testGetNodeModel() {
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        this.config.setSynchronizer((Synchronizer)sync);
        NodeModel model = this.config.getNodeModel();
        Assert.assertTrue((String)("Wrong node model: " + model), (boolean)(model instanceof InMemoryNodeModel));
        ImmutableNode rootNode = (ImmutableNode)model.getNodeHandler().getRootNode();
        Assert.assertEquals((String)"Wrong number of children of root node", (long)1L, (long)rootNode.getChildren().size());
        Assert.assertTrue((String)"Wrong children of root node", (boolean)rootNode.getChildren().contains(NodeStructureHelper.ROOT_TABLES_TREE));
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    private void checkKeys(String prefix, String[] expected) {
        HashSet<String> values = new HashSet<String>();
        for (String anExpected : expected) {
            values.add(anExpected.startsWith(prefix) ? anExpected : prefix + "." + anExpected);
        }
        Iterator itKeys = this.config.getKeys(prefix);
        while (itKeys.hasNext()) {
            String key = (String)itKeys.next();
            if (!values.contains(key)) {
                Assert.fail((String)("Found unexpected key: " + key));
                continue;
            }
            values.remove(key);
        }
        Assert.assertTrue((String)("Remaining keys " + values), (boolean)values.isEmpty());
    }

    private void checkAlternativeSyntax() {
        Assert.assertNull((Object)this.config.getProperty("tables/table/resultset"));
        Assert.assertNull((Object)this.config.getProperty("tables/table/fields/field"));
        Object prop = this.config.getProperty("tables/table[0]/fields/field/name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)NodeStructureHelper.fieldsLength(0), (long)((Collection)prop).size());
        prop = this.config.getProperty("tables/table/fields/field/name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)TestAbstractHierarchicalConfiguration.totalFieldCount(), (long)((Collection)prop).size());
        prop = this.config.getProperty("tables/table/fields/field[3]/name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)2L, (long)((Collection)prop).size());
        prop = this.config.getProperty("tables/table[1]/fields/field[2]/name");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)"creationDate", (Object)prop.toString());
        Set<String> keys = ConfigurationAssert.keysToSet(this.config);
        Assert.assertEquals((String)"Wrong number of defined keys", (long)2L, (long)keys.size());
        Assert.assertTrue((String)"Key not found", (boolean)keys.contains("tables/table/name"));
        Assert.assertTrue((String)"Key not found", (boolean)keys.contains("tables/table/fields/field/name"));
    }

    private static int totalFieldCount() {
        int fieldCount = 0;
        for (int i = 0; i < NodeStructureHelper.tablesLength(); ++i) {
            fieldCount += NodeStructureHelper.fieldsLength(i);
        }
        return fieldCount;
    }

    private static void checkContent(Configuration c) {
        for (int i = 0; i < NodeStructureHelper.tablesLength(); ++i) {
            Assert.assertEquals((Object)NodeStructureHelper.table(i), (Object)c.getString("tables.table(" + i + ").name"));
            for (int j = 0; j < NodeStructureHelper.fieldsLength(i); ++j) {
                Assert.assertEquals((Object)NodeStructureHelper.field(i, j), (Object)c.getString("tables.table(" + i + ").fields.field(" + j + ").name"));
            }
        }
    }

    private ExpressionEngine createAlternativeExpressionEngine() {
        return new DefaultExpressionEngine(new DefaultExpressionEngineSymbols.Builder(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS).setPropertyDelimiter("/").setIndexStart("[").setIndexEnd("]").create());
    }

    private static class AbstractHierarchicalConfigurationTestImpl
    extends AbstractHierarchicalConfiguration<ImmutableNode> {
        public AbstractHierarchicalConfigurationTestImpl(InMemoryNodeModel model) {
            super((NodeModel)model);
        }

        protected NodeModel<ImmutableNode> cloneNodeModel() {
            return new InMemoryNodeModel((ImmutableNode)this.getModel().getNodeHandler().getRootNode());
        }

        public SubnodeConfiguration configurationAt(String key, boolean supportUpdates) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public SubnodeConfiguration configurationAt(String key) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public List<HierarchicalConfiguration<ImmutableNode>> configurationsAt(String key) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public List<HierarchicalConfiguration<ImmutableNode>> configurationsAt(String key, boolean supportUpdates) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public List<HierarchicalConfiguration<ImmutableNode>> childConfigurationsAt(String key) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public List<HierarchicalConfiguration<ImmutableNode>> childConfigurationsAt(String key, boolean supportUpdates) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public ImmutableHierarchicalConfiguration immutableConfigurationAt(String key, boolean supportUpdates) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public ImmutableHierarchicalConfiguration immutableConfigurationAt(String key) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public List<ImmutableHierarchicalConfiguration> immutableConfigurationsAt(String key) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public List<ImmutableHierarchicalConfiguration> immutableChildConfigurationsAt(String key) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }
    }
}

