/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.CombinedConfigurationBuilder;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestPropertiesSequence {
    @Test
    public void testConfigurationValuesInSameOrderFromFile() throws Exception {
        String simpleConfigurationFile = ConfigurationAssert.getTestFile("testSequence.properties").getAbsolutePath();
        String compositeConfigurationFile = ConfigurationAssert.getTestFile("testSequenceDigester.xml").getAbsolutePath();
        PropertiesConfiguration simpleConfiguration = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)simpleConfiguration);
        handler.setFileName(simpleConfigurationFile);
        handler.load();
        CombinedConfigurationBuilder builder = new CombinedConfigurationBuilder();
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFileName(compositeConfigurationFile)});
        Configuration compositeConfiguration = (Configuration)builder.getConfiguration();
        Configuration a = simpleConfiguration.subset("prefix");
        Configuration b = compositeConfiguration.subset("prefix");
        List<String> keysSimpleConfiguration = ConfigurationAssert.keysToList(a);
        List<String> keysCompositeConfiguration = ConfigurationAssert.keysToList(b);
        Assert.assertTrue((String)("Size:" + keysSimpleConfiguration.size()), (keysSimpleConfiguration.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)keysSimpleConfiguration.size(), (long)keysCompositeConfiguration.size());
        for (int i = 0; i < keysSimpleConfiguration.size(); ++i) {
            Assert.assertEquals((Object)keysSimpleConfiguration.get(i), (Object)keysCompositeConfiguration.get(i));
        }
    }

    @Test
    public void testConfigurationValuesInSameOrderWithManualAdd() throws Exception {
        String simpleConfigurationFile = ConfigurationAssert.getTestFile("testSequence.properties").getAbsolutePath();
        String compositeConfigurationFile = ConfigurationAssert.getTestFile("testSequenceDigester.xml").getAbsolutePath();
        PropertiesConfiguration simpleConfiguration = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)simpleConfiguration);
        handler.setFileName(simpleConfigurationFile);
        handler.load();
        CombinedConfigurationBuilder builder = new CombinedConfigurationBuilder();
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFileName(compositeConfigurationFile)});
        Configuration compositeConfiguration = (Configuration)builder.getConfiguration();
        simpleConfiguration.setProperty("prefix.Co.test", (Object)Boolean.TRUE);
        simpleConfiguration.setProperty("prefix.Av.test", (Object)Boolean.TRUE);
        compositeConfiguration.setProperty("prefix.Co.test", (Object)Boolean.TRUE);
        compositeConfiguration.setProperty("prefix.Av.test", (Object)Boolean.TRUE);
        Configuration a = simpleConfiguration.subset("prefix");
        Configuration b = compositeConfiguration.subset("prefix");
        List<String> keysSimpleConfiguration = ConfigurationAssert.keysToList(a);
        List<String> keysCompositeConfiguration = ConfigurationAssert.keysToList(b);
        Assert.assertTrue((String)("Size:" + keysSimpleConfiguration.size()), (keysSimpleConfiguration.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)keysSimpleConfiguration.size(), (long)keysCompositeConfiguration.size());
        for (int i = 0; i < keysSimpleConfiguration.size(); ++i) {
            Assert.assertEquals((Object)keysSimpleConfiguration.get(i), (Object)keysCompositeConfiguration.get(i));
        }
    }

    @Test
    public void testMappingInSameOrder() throws Exception {
        String serviceKey;
        String[] keyParts;
        String key;
        String simpleConfigurationFile = ConfigurationAssert.getTestFile("testSequence.properties").getAbsolutePath();
        String compositeConfigurationFile = ConfigurationAssert.getTestFile("testSequenceDigester.xml").getAbsolutePath();
        PropertiesConfiguration simpleConfiguration = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)simpleConfiguration);
        handler.setFileName(simpleConfigurationFile);
        handler.load();
        CombinedConfigurationBuilder builder = new CombinedConfigurationBuilder();
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFileName(compositeConfigurationFile)});
        Configuration compositeConfiguration = (Configuration)builder.getConfiguration();
        BaseConfiguration mapping = new BaseConfiguration();
        BaseConfiguration mapping2 = new BaseConfiguration();
        Iterator keys = simpleConfiguration.getKeys();
        while (keys.hasNext()) {
            key = (String)keys.next();
            keyParts = StringUtils.split((String)key, (String)".");
            if (keyParts.length != 3 || !keyParts[0].equals("prefix") || !keyParts[2].equals("postfix") || mapping.containsKey(serviceKey = keyParts[1])) continue;
            mapping.setProperty(serviceKey, (Object)simpleConfiguration.getString(key));
        }
        keys = compositeConfiguration.getKeys();
        while (keys.hasNext()) {
            key = (String)keys.next();
            keyParts = StringUtils.split((String)key, (String)".");
            if (keyParts.length != 3 || !keyParts[0].equals("prefix") || !keyParts[2].equals("postfix") || mapping2.containsKey(serviceKey = keyParts[1])) continue;
            mapping2.setProperty(serviceKey, (Object)compositeConfiguration.getString(key));
        }
    }
}

