/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.InterpolationTestHelper;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.interpol.Lookup;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.InMemoryNodeModelSupport;
import org.apache.commons.configuration2.tree.NodeKeyResolver;
import org.apache.commons.configuration2.tree.NodeSelector;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.apache.commons.configuration2.tree.TrackedNodeModel;
import org.apache.commons.configuration2.tree.xpath.XPathExpressionEngine;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSubnodeConfiguration {
    private static final String SUB_KEY = "tables.table(0)";
    private static final NodeSelector SELECTOR = new NodeSelector("tables.table(0)");
    private BaseHierarchicalConfiguration parent;
    private SubnodeConfiguration config;

    @Before
    public void setUp() throws Exception {
        this.parent = TestSubnodeConfiguration.setUpParentConfig();
    }

    private static BaseHierarchicalConfiguration setUpParentConfig() {
        BaseHierarchicalConfiguration conf = new BaseHierarchicalConfiguration();
        TestSubnodeConfiguration.appendTree(conf, NodeStructureHelper.ROOT_TABLES_TREE);
        return conf;
    }

    private static void appendTree(BaseHierarchicalConfiguration configuration, ImmutableNode root) {
        configuration.addNodes(null, Collections.singleton(root));
    }

    private void setUpSubnodeConfig() {
        this.setUpSubnodeConfig(SUB_KEY);
    }

    private void setUpSubnodeConfig(String key) {
        this.config = (SubnodeConfiguration)this.parent.configurationAt(key, true);
    }

    private TrackedNodeModel setUpTrackedModel(NodeSelector selector) {
        InMemoryNodeModel parentModel = (InMemoryNodeModel)this.parent.getModel();
        parentModel.trackNode(selector, (NodeKeyResolver)this.parent);
        return new TrackedNodeModel((InMemoryNodeModelSupport)this.parent, selector, true);
    }

    @Test
    public void testInitSubNodeConfig() {
        this.setUpSubnodeConfig();
        Assert.assertSame((String)"Wrong root node in subnode", (Object)NodeStructureHelper.nodeForKey((ImmutableNode)this.parent.getModel().getNodeHandler().getRootNode(), "tables/table(0)"), (Object)this.config.getModel().getNodeHandler().getRootNode());
        Assert.assertSame((String)"Wrong parent config", (Object)this.parent, (Object)this.config.getParent());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitSubNodeConfigWithNullParent() {
        this.config = new SubnodeConfiguration(null, this.setUpTrackedModel(SELECTOR));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitSubNodeConfigWithNullNode() {
        this.config = new SubnodeConfiguration(this.parent, null);
    }

    @Test
    public void testGetProperties() {
        this.setUpSubnodeConfig();
        this.checkSubConfigContent();
    }

    private void checkSubConfigContent() {
        Assert.assertEquals((String)"Wrong table name", (Object)NodeStructureHelper.table(0), (Object)this.config.getString("name"));
        List fields = this.config.getList("fields.field.name");
        Assert.assertEquals((String)"Wrong number of fields", (long)NodeStructureHelper.fieldsLength(0), (long)fields.size());
        for (int i = 0; i < NodeStructureHelper.fieldsLength(0); ++i) {
            Assert.assertEquals((String)("Wrong field at position " + i), (Object)NodeStructureHelper.field(0, i), fields.get(i));
        }
    }

    @Test
    public void testSetProperty() {
        this.setUpSubnodeConfig();
        this.config.setProperty(null, (Object)"testTable");
        this.config.setProperty("name", (Object)(NodeStructureHelper.table(0) + "_tested"));
        Assert.assertEquals((String)"Root value was not set", (Object)"testTable", (Object)this.parent.getString(SUB_KEY));
        Assert.assertEquals((String)"Table name was not changed", (Object)(NodeStructureHelper.table(0) + "_tested"), (Object)this.parent.getString("tables.table(0).name"));
        this.parent.setProperty("tables.table(0).fields.field(1).name", (Object)"testField");
        Assert.assertEquals((String)"Field name was not changed", (Object)"testField", (Object)this.config.getString("fields.field(1).name"));
    }

    @Test
    public void testAddProperty() {
        this.setUpSubnodeConfig();
        this.config.addProperty("[@table-type]", (Object)"test");
        Assert.assertEquals((String)"Attribute not set", (Object)"test", (Object)this.parent.getString("tables.table(0)[@table-type]"));
        this.parent.addProperty("tables.table(0).fields.field(-1).name", (Object)"newField");
        List fields = this.config.getList("fields.field.name");
        Assert.assertEquals((String)"New field was not added", (long)(NodeStructureHelper.fieldsLength(0) + 1), (long)fields.size());
        Assert.assertEquals((String)"Wrong last field", (Object)"newField", fields.get(fields.size() - 1));
    }

    @Test
    public void testGetKeys() {
        this.setUpSubnodeConfig();
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(ConfigurationAssert.keysToList((Configuration)this.config));
        Assert.assertEquals((String)"Incorrect number of keys", (long)2L, (long)keys.size());
        Assert.assertTrue((String)"Key 1 not contained", (boolean)keys.contains("name"));
        Assert.assertTrue((String)"Key 2 not contained", (boolean)keys.contains("fields.field.name"));
    }

    @Test(expected=NoSuchElementException.class)
    public void testSetThrowExceptionOnMissing() {
        this.parent.setThrowExceptionOnMissing(true);
        this.setUpSubnodeConfig();
        Assert.assertTrue((String)"Exception flag not fetchted from parent", (boolean)this.config.isThrowExceptionOnMissing());
        this.config.getString("non existing key");
    }

    @Test
    public void testSetThrowExceptionOnMissingAffectsParent() {
        this.parent.setThrowExceptionOnMissing(true);
        this.setUpSubnodeConfig();
        this.config.setThrowExceptionOnMissing(false);
        Assert.assertTrue((String)"Exception flag reset on parent", (boolean)this.parent.isThrowExceptionOnMissing());
    }

    @Test
    public void testSetListDelimiterHandler() {
        DefaultListDelimiterHandler handler1 = new DefaultListDelimiterHandler('/');
        DefaultListDelimiterHandler handler2 = new DefaultListDelimiterHandler(';');
        this.parent.setListDelimiterHandler((ListDelimiterHandler)handler1);
        this.setUpSubnodeConfig();
        this.parent.setListDelimiterHandler((ListDelimiterHandler)handler2);
        Assert.assertEquals((String)"List delimiter handler not obtained from parent", (Object)handler1, (Object)this.config.getListDelimiterHandler());
        this.config.addProperty("newProp", (Object)"test1,test2/test3");
        Assert.assertEquals((String)"List was incorrectly splitted", (Object)"test1,test2", (Object)this.parent.getString("tables.table(0).newProp"));
        this.config.setListDelimiterHandler(DisabledListDelimiterHandler.INSTANCE);
        Assert.assertEquals((String)"List delimiter changed on parent", (Object)handler2, (Object)this.parent.getListDelimiterHandler());
    }

    @Test
    public void testSetExpressionEngine() {
        this.parent.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        this.setUpSubnodeConfig("tables/table[1]");
        Assert.assertEquals((String)"Wrong field name", (Object)NodeStructureHelper.field(0, 1), (Object)this.config.getString("fields/field[2]/name"));
        Set<String> keys = ConfigurationAssert.keysToSet((Configuration)this.config);
        Assert.assertEquals((String)"Wrong number of keys", (long)2L, (long)keys.size());
        Assert.assertTrue((String)"Key 1 not contained", (boolean)keys.contains("name"));
        Assert.assertTrue((String)"Key 2 not contained", (boolean)keys.contains("fields/field/name"));
        this.config.setExpressionEngine(null);
        Assert.assertTrue((String)"Expression engine reset on parent", (boolean)(this.parent.getExpressionEngine() instanceof XPathExpressionEngine));
    }

    @Test
    public void testConfiguarationAtNoUpdates() {
        this.setUpSubnodeConfig();
        HierarchicalConfiguration sub2 = this.config.configurationAt("fields.field(1)");
        Assert.assertEquals((String)"Wrong value of property", (Object)NodeStructureHelper.field(0, 1), (Object)sub2.getString("name"));
        this.parent.setProperty("tables.table(0).fields.field(1).name", (Object)"otherName");
        Assert.assertEquals((String)"Change of parent is visible", (Object)NodeStructureHelper.field(0, 1), (Object)sub2.getString("name"));
    }

    @Test
    public void testConfigurationAtWithUpdateSupport() {
        this.setUpSubnodeConfig();
        SubnodeConfiguration sub2 = (SubnodeConfiguration)this.config.configurationAt("fields.field(1)", true);
        Assert.assertEquals((String)"Wrong value of property", (Object)NodeStructureHelper.field(0, 1), (Object)sub2.getString("name"));
        Assert.assertEquals((String)"Wrong parent", (Object)this.config, (Object)sub2.getParent());
    }

    @Test
    public void testInterpolation() {
        this.parent.addProperty("tablespaces.tablespace.name", (Object)"default");
        this.parent.addProperty("tablespaces.tablespace(-1).name", (Object)"test");
        this.parent.addProperty("tables.table(0).tablespace", (Object)"${tablespaces.tablespace(0).name}");
        Assert.assertEquals((String)"Wrong interpolated tablespace", (Object)"default", (Object)this.parent.getString("tables.table(0).tablespace"));
        this.setUpSubnodeConfig();
        Assert.assertEquals((String)"Wrong interpolated tablespace in subnode", (Object)"default", (Object)this.config.getString("tablespace"));
    }

    private void checkInterpolationFromConfigurationAt(boolean withUpdates) {
        this.parent.addProperty("base.dir", (Object)"/home/foo");
        this.parent.addProperty("test.absolute.dir.dir1", (Object)"${base.dir}/path1");
        this.parent.addProperty("test.absolute.dir.dir2", (Object)"${base.dir}/path2");
        this.parent.addProperty("test.absolute.dir.dir3", (Object)"${base.dir}/path3");
        HierarchicalConfiguration sub = this.parent.configurationAt("test.absolute.dir", withUpdates);
        for (int i = 1; i < 4; ++i) {
            Assert.assertEquals((String)"Wrong interpolation in parent", (Object)("/home/foo/path" + i), (Object)this.parent.getString("test.absolute.dir.dir" + i));
            Assert.assertEquals((String)"Wrong interpolation in sub", (Object)("/home/foo/path" + i), (Object)sub.getString("dir" + i));
        }
    }

    @Test
    public void testInterpolationFromConfigurationAtNoUpdateSupport() {
        this.checkInterpolationFromConfigurationAt(false);
    }

    @Test
    public void testInterpolationFromConfigurationAtWithUpdateSupport() {
        this.checkInterpolationFromConfigurationAt(true);
    }

    @Test
    public void testLocalInterpolationFromConfigurationAt() {
        this.parent.addProperty("base.dir", (Object)"/home/foo");
        this.parent.addProperty("test.absolute.dir.dir1", (Object)"${base.dir}/path1");
        this.parent.addProperty("test.absolute.dir.dir2", (Object)"${dir1}");
        HierarchicalConfiguration sub = this.parent.configurationAt("test.absolute.dir");
        Assert.assertEquals((String)"Wrong interpolation in subnode", (Object)"/home/foo/path1", (Object)sub.getString("dir1"));
        Assert.assertEquals((String)"Wrong local interpolation in subnode", (Object)"/home/foo/path1", (Object)sub.getString("dir2"));
    }

    @Test
    public void testInterpolator() {
        this.parent.addProperty("tablespaces.tablespace.name", (Object)"default");
        this.parent.addProperty("tablespaces.tablespace(-1).name", (Object)"test");
        this.setUpSubnodeConfig();
        InterpolationTestHelper.testGetInterpolator((AbstractConfiguration)this.config);
    }

    @Test
    public void testLocalLookupsInInterpolatorAreInherited() {
        this.parent.addProperty("tablespaces.tablespace.name", (Object)"default");
        this.parent.addProperty("tablespaces.tablespace(-1).name", (Object)"test");
        this.parent.addProperty("tables.table(0).var", (Object)"${brackets:x}");
        ConfigurationInterpolator interpolator = this.parent.getInterpolator();
        interpolator.registerLookup("brackets", new Lookup(){

            public String lookup(String key) {
                return "(" + key + ")";
            }
        });
        this.setUpSubnodeConfig();
        Assert.assertEquals((String)"Local lookup was not inherited", (Object)"(x)", (Object)this.config.getString("var", ""));
    }

    @Test
    public void testParentChangeDetach() {
        this.setUpSubnodeConfig();
        this.parent.clear();
        this.checkSubConfigContent();
    }

    @Test
    public void testParentChangeDetatchException() {
        this.setUpSubnodeConfig();
        this.parent.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        this.parent.addProperty("newProp", (Object)"value");
        this.checkSubConfigContent();
    }

    @Test
    public void testClone() {
        this.setUpSubnodeConfig();
        SubnodeConfiguration copy = (SubnodeConfiguration)this.config.clone();
        Assert.assertNotSame((String)"Same model", (Object)this.config.getModel(), (Object)copy.getModel());
        TrackedNodeModel subModel = (TrackedNodeModel)copy.getModel();
        Assert.assertEquals((String)"Wrong selector", (Object)SELECTOR, (Object)subModel.getSelector());
        InMemoryNodeModel parentModel = (InMemoryNodeModel)this.parent.getModel();
        Assert.assertEquals((String)"Wrong parent model", (Object)parentModel, (Object)subModel.getParentModel());
        parentModel.untrackNode(SELECTOR);
        parentModel.untrackNode(SELECTOR);
        Assert.assertTrue((String)"Wrong finalize flag", (boolean)subModel.isReleaseTrackedNodeOnFinalize());
    }

    @Test
    public void testClose() {
        TrackedNodeModel model = (TrackedNodeModel)EasyMock.createMock(TrackedNodeModel.class);
        EasyMock.expect((Object)model.getSelector()).andReturn((Object)SELECTOR).anyTimes();
        model.close();
        EasyMock.replay((Object[])new Object[]{model});
        SubnodeConfiguration config = new SubnodeConfiguration(this.parent, model);
        config.close();
        EasyMock.verify((Object[])new Object[]{model});
    }
}

