/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.net.URL;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.ClasspathLocationStrategy;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestClasspathLocationStrategy {
    private static final String FILE_NAME = "test.xml";
    private FileSystem fileSystem;
    private ClasspathLocationStrategy strategy;

    @Before
    public void setUp() throws Exception {
        this.fileSystem = (FileSystem)EasyMock.createMock(FileSystem.class);
        EasyMock.replay((Object[])new Object[]{this.fileSystem});
        this.strategy = new ClasspathLocationStrategy();
    }

    @Test
    public void testLocateSuccess() throws ConfigurationException {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName(FILE_NAME).basePath("somePath").create();
        URL url = this.strategy.locate(this.fileSystem, locator);
        Configurations configurations = new Configurations();
        XMLConfiguration config1 = configurations.xml(url);
        XMLConfiguration config2 = configurations.xml(ConfigurationAssert.getTestURL(FILE_NAME));
        ConfigurationAssert.assertConfigurationEquals((Configuration)config1, (Configuration)config2);
    }

    @Test
    public void testLocateFailed() {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName("non existing resource name!").create();
        Assert.assertNull((String)"Got a URL", (Object)this.strategy.locate(this.fileSystem, locator));
    }

    @Test
    public void testLocateNoFileName() {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName("").create();
        Assert.assertNull((String)"Got a URL", (Object)this.strategy.locate(this.fileSystem, locator));
    }
}

