/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.tree.DefaultExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeKeyResolver;
import org.apache.commons.configuration2.tree.NodeSelector;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.apache.commons.configuration2.tree.NodeUpdateData;
import org.apache.commons.configuration2.tree.TrackedNodeHandler;
import org.apache.commons.configuration2.tree.TreeData;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestInMemoryNodeModelTrackedNodes {
    private static final String NEW_FIELD = "newTableField";
    private static final String TEST_KEY = "someTestKey";
    private static final String SELECTOR_KEY = "tables.table(1)";
    private static ImmutableNode root;
    private static NodeSelector selector;
    private InMemoryNodeModel model;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        root = new ImmutableNode.Builder(1).addChild(NodeStructureHelper.ROOT_TABLES_TREE).create();
        selector = new NodeSelector(SELECTOR_KEY);
    }

    @Before
    public void setUp() throws Exception {
        this.model = new InMemoryNodeModel(root);
    }

    private static NodeKeyResolver<ImmutableNode> createResolver() {
        return TestInMemoryNodeModelTrackedNodes.createResolver(true);
    }

    private static NodeKeyResolver<ImmutableNode> createResolver(boolean replay) {
        NodeKeyResolver<ImmutableNode> resolver = NodeStructureHelper.createResolverMock();
        NodeStructureHelper.expectResolveKeyForQueries(resolver);
        if (replay) {
            EasyMock.replay((Object[])new Object[]{resolver});
        }
        return resolver;
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testTrackNodeKeyNoResults() {
        this.model.trackNode(new NodeSelector("tables.unknown"), TestInMemoryNodeModelTrackedNodes.createResolver());
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testTrackNodeKeyMultipleResults() {
        this.model.trackNode(new NodeSelector("tables.table.fields.field.name"), TestInMemoryNodeModelTrackedNodes.createResolver());
    }

    @Test
    public void testGetTrackedNodeExisting() {
        ImmutableNode node = NodeStructureHelper.nodeForKey(this.model, "tables/table(1)");
        this.model.trackNode(selector, TestInMemoryNodeModelTrackedNodes.createResolver());
        Assert.assertSame((String)"Wrong node", (Object)node, (Object)this.model.getTrackedNode(selector));
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testGetTrackedNodeNonExisting() {
        this.model.getTrackedNode(selector);
    }

    @Test
    public void testGetTrackedNodeAfterUpdate() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.model.clearProperty("tables.table(1).fields.field(1).name", resolver);
        ImmutableNode node = this.model.getTrackedNode(selector);
        Assert.assertEquals((String)"Wrong node", (Object)NodeStructureHelper.table(1), (Object)((ImmutableNode)node.getChildren().get(0)).getValue());
    }

    @Test
    public void testGetTrackedNodeAfterUpdateNoLongerExisting() {
        ImmutableNode node = NodeStructureHelper.nodeForKey(this.model, "tables/table(1)");
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.initDetachedNode(resolver);
        Assert.assertSame((String)"Wrong node", (Object)node, (Object)this.model.getTrackedNode(selector));
    }

    private void initDetachedNode(NodeKeyResolver<ImmutableNode> resolver) {
        this.model.trackNode(selector, resolver);
        this.model.clearTree("tables.table(0)", resolver);
    }

    @Test
    public void testGetTrackedNodeAfterClear() {
        ImmutableNode node = NodeStructureHelper.nodeForKey(this.model, "tables/table(1)");
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.model.clear(resolver);
        Assert.assertSame((String)"Wrong node", (Object)node, (Object)this.model.getTrackedNode(selector));
    }

    @Test
    public void testGetTrackedNodeAfterSetRootNode() {
        ImmutableNode node = NodeStructureHelper.nodeForKey(this.model, "tables/table(1)");
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.model.setRootNode(root);
        Assert.assertSame((String)"Wrong node", (Object)node, (Object)this.model.getTrackedNode(selector));
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testUntrackNodeNonExisting() {
        this.model.untrackNode(selector);
    }

    @Test
    public void testUntrackNode() {
        this.model.trackNode(selector, TestInMemoryNodeModelTrackedNodes.createResolver());
        this.model.untrackNode(selector);
        try {
            this.model.getTrackedNode(selector);
            Assert.fail((String)"Could get untracked node!");
        }
        catch (ConfigurationRuntimeException configurationRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testTrackNodeMultipleTimes() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.model.trackNode(selector, resolver);
        this.model.untrackNode(selector);
        Assert.assertNotNull((String)"No tracked node", (Object)this.model.getTrackedNode(selector));
    }

    @Test
    public void testIsDetachedFalseNoUpdates() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        Assert.assertFalse((String)"Node is detached", (boolean)this.model.isTrackedNodeDetached(selector));
    }

    @Test
    public void testIsDetachedFalseAfterUpdate() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.model.clearProperty("tables.table(1).fields.field(1).name", resolver);
        Assert.assertFalse((String)"Node is detached", (boolean)this.model.isTrackedNodeDetached(selector));
    }

    @Test
    public void testIsDetachedTrue() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.initDetachedNode(resolver);
        Assert.assertTrue((String)"Node is not detached", (boolean)this.model.isTrackedNodeDetached(selector));
    }

    @Test
    public void testIsDetachedAfterClear() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.model.clear(resolver);
        Assert.assertTrue((String)"Node is not detached", (boolean)this.model.isTrackedNodeDetached(selector));
    }

    @Test
    public void testIsDetachedAfterSetRoot() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.model.clearProperty("tables.table(1).fields.field(1).name", resolver);
        this.model.setRootNode(root);
        Assert.assertTrue((String)"Node is not detached", (boolean)this.model.isTrackedNodeDetached(selector));
    }

    private ImmutableNode fieldsNodeFromModel() {
        return NodeStructureHelper.nodeForKey(this.model, "tables/table(1)/fields");
    }

    private ImmutableNode fieldsNodeFromTrackedNode() {
        return NodeStructureHelper.nodeForKey(this.model.getTrackedNode(selector), "fields");
    }

    private static void checkForRemovedField(ImmutableNode nodeFields, int idx) {
        Assert.assertEquals((String)"Field not removed", (long)(NodeStructureHelper.fieldsLength(1) - 1), (long)nodeFields.getChildren().size());
        HashSet<String> expectedNames = new HashSet<String>();
        HashSet<String> actualNames = new HashSet<String>();
        for (int i = 0; i < NodeStructureHelper.fieldsLength(1); ++i) {
            if (idx == i) continue;
            expectedNames.add(NodeStructureHelper.field(1, i));
        }
        for (ImmutableNode field : nodeFields.getChildren()) {
            ImmutableNode nodeName = (ImmutableNode)field.getChildren().get(0);
            actualNames.add(String.valueOf(nodeName.getValue()));
        }
        Assert.assertEquals((String)"Wrong field names", expectedNames, actualNames);
    }

    @Test
    public void testClearPropertyOnTrackedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.model.clearProperty("fields.field(0).name", selector, resolver);
        ImmutableNode nodeFields = this.fieldsNodeFromModel();
        TestInMemoryNodeModelTrackedNodes.checkForRemovedField(nodeFields, 0);
    }

    @Test
    public void testClearPropertyOnDetachedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.initDetachedNode(resolver);
        ImmutableNode rootNode = this.model.getRootNode();
        this.model.clearProperty("fields.field(0).name", selector, resolver);
        Assert.assertSame((String)"Model root was changed", (Object)rootNode, (Object)this.model.getRootNode());
        ImmutableNode nodeFields = this.fieldsNodeFromTrackedNode();
        TestInMemoryNodeModelTrackedNodes.checkForRemovedField(nodeFields, 0);
    }

    @Test
    public void testClearTreeOnTrackedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.model.clearTree("fields.field(1)", selector, resolver);
        ImmutableNode nodeFields = this.fieldsNodeFromModel();
        TestInMemoryNodeModelTrackedNodes.checkForRemovedField(nodeFields, 1);
    }

    @Test
    public void testClearTreeOnDetachedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.initDetachedNode(resolver);
        ImmutableNode rootNode = this.model.getRootNode();
        this.model.clearTree("fields.field(1)", selector, resolver);
        Assert.assertSame((String)"Model root was changed", (Object)rootNode, (Object)this.model.getRootNode());
        ImmutableNode nodeFields = this.fieldsNodeFromTrackedNode();
        TestInMemoryNodeModelTrackedNodes.checkForRemovedField(nodeFields, 1);
    }

    private static void checkForAddedField(ImmutableNode nodeFields) {
        Assert.assertEquals((String)"Wrong number of children", (long)(NodeStructureHelper.fieldsLength(1) + 1), (long)nodeFields.getChildren().size());
        ImmutableNode nodeField = (ImmutableNode)nodeFields.getChildren().get(NodeStructureHelper.fieldsLength(1));
        TestInMemoryNodeModelTrackedNodes.checkFieldNode(nodeField, NEW_FIELD);
    }

    private static void checkFieldNode(ImmutableNode nodeField, String name) {
        Assert.assertEquals((String)"Wrong node name", (Object)"field", (Object)nodeField.getNodeName());
        Assert.assertEquals((String)"Wrong number of children of field node", (long)1L, (long)nodeField.getChildren().size());
        ImmutableNode nodeName = (ImmutableNode)nodeField.getChildren().get(0);
        Assert.assertEquals((String)"Wrong name of name node", (Object)"name", (Object)nodeName.getNodeName());
        Assert.assertEquals((String)"Wrong node value", (Object)name, (Object)nodeName.getValue());
    }

    @Test
    public void testAddPropertyOnTrackedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver(false);
        NodeStructureHelper.expectResolveAddKeys(resolver);
        EasyMock.replay((Object[])new Object[]{resolver});
        this.model.trackNode(selector, resolver);
        this.model.addProperty("fields.field(-1).name", selector, Collections.singleton(NEW_FIELD), resolver);
        TestInMemoryNodeModelTrackedNodes.checkForAddedField(this.fieldsNodeFromModel());
        TestInMemoryNodeModelTrackedNodes.checkForAddedField(this.fieldsNodeFromTrackedNode());
    }

    @Test
    public void testAddPropertyOnDetachedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver(false);
        NodeStructureHelper.expectResolveAddKeys(resolver);
        EasyMock.replay((Object[])new Object[]{resolver});
        this.model.trackNode(selector, resolver);
        this.initDetachedNode(resolver);
        ImmutableNode rootNode = this.model.getRootNode();
        this.model.addProperty("fields.field(-1).name", selector, Collections.singleton(NEW_FIELD), resolver);
        Assert.assertSame((String)"Root node was changed", (Object)rootNode, (Object)this.model.getRootNode());
        TestInMemoryNodeModelTrackedNodes.checkForAddedField(this.fieldsNodeFromTrackedNode());
    }

    @Test
    public void testAddNodesOnTrackedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver(false);
        NodeStructureHelper.expectResolveAddKeys(resolver);
        EasyMock.replay((Object[])new Object[]{resolver});
        this.model.trackNode(selector, resolver);
        this.model.addNodes("fields", selector, Collections.singleton(NodeStructureHelper.createFieldNode(NEW_FIELD)), resolver);
        TestInMemoryNodeModelTrackedNodes.checkForAddedField(this.fieldsNodeFromModel());
        TestInMemoryNodeModelTrackedNodes.checkForAddedField(this.fieldsNodeFromTrackedNode());
    }

    @Test
    public void testAddNodesOnDetachedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver(false);
        NodeStructureHelper.expectResolveAddKeys(resolver);
        EasyMock.replay((Object[])new Object[]{resolver});
        this.model.trackNode(selector, resolver);
        this.initDetachedNode(resolver);
        ImmutableNode rootNode = this.model.getRootNode();
        this.model.addNodes("fields", selector, Collections.singleton(NodeStructureHelper.createFieldNode(NEW_FIELD)), resolver);
        Assert.assertSame((String)"Root node was changed", (Object)rootNode, (Object)this.model.getRootNode());
        TestInMemoryNodeModelTrackedNodes.checkForAddedField(this.fieldsNodeFromTrackedNode());
    }

    private static void prepareResolverForUpdateKeys(NodeKeyResolver<ImmutableNode> resolver) {
        EasyMock.expect((Object)resolver.resolveUpdateKey(EasyMock.anyObject(ImmutableNode.class), EasyMock.anyString(), EasyMock.anyObject(), (NodeHandler)EasyMock.anyObject(TreeData.class))).andAnswer((IAnswer)new IAnswer<NodeUpdateData<ImmutableNode>>(){

            public NodeUpdateData<ImmutableNode> answer() throws Throwable {
                ImmutableNode root = (ImmutableNode)EasyMock.getCurrentArguments()[0];
                String key = (String)EasyMock.getCurrentArguments()[1];
                TreeData handler = (TreeData)EasyMock.getCurrentArguments()[3];
                List results = DefaultExpressionEngine.INSTANCE.query((Object)root, key, (NodeHandler)handler);
                Assert.assertEquals((String)"Wrong number of query results", (long)1L, (long)results.size());
                return new NodeUpdateData(Collections.singletonMap(results.get(0), EasyMock.getCurrentArguments()[2]), null, null, null);
            }
        }).anyTimes();
    }

    private static void checkedForChangedField(ImmutableNode nodeFields, int idx) {
        Assert.assertEquals((String)"Wrong number of field nodes", (long)NodeStructureHelper.fieldsLength(1), (long)nodeFields.getChildren().size());
        int childIndex = 0;
        for (ImmutableNode field : nodeFields.getChildren()) {
            String expName = childIndex == idx ? NEW_FIELD : NodeStructureHelper.field(1, childIndex);
            TestInMemoryNodeModelTrackedNodes.checkFieldNode(field, expName);
            ++childIndex;
        }
    }

    @Test
    public void testSetPropertyOnTrackedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver(false);
        TestInMemoryNodeModelTrackedNodes.prepareResolverForUpdateKeys(resolver);
        EasyMock.replay((Object[])new Object[]{resolver});
        this.model.trackNode(selector, resolver);
        this.model.setProperty("fields.field(0).name", selector, (Object)NEW_FIELD, resolver);
        TestInMemoryNodeModelTrackedNodes.checkedForChangedField(this.fieldsNodeFromModel(), 0);
        TestInMemoryNodeModelTrackedNodes.checkedForChangedField(this.fieldsNodeFromTrackedNode(), 0);
    }

    @Test
    public void testSetPropertyOnDetachedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver(false);
        TestInMemoryNodeModelTrackedNodes.prepareResolverForUpdateKeys(resolver);
        EasyMock.replay((Object[])new Object[]{resolver});
        this.model.trackNode(selector, resolver);
        this.initDetachedNode(resolver);
        ImmutableNode rootNode = this.model.getRootNode();
        this.model.setProperty("fields.field(0).name", selector, (Object)NEW_FIELD, resolver);
        Assert.assertSame((String)"Root node of model was changed", (Object)rootNode, (Object)this.model.getRootNode());
        TestInMemoryNodeModelTrackedNodes.checkedForChangedField(this.fieldsNodeFromTrackedNode(), 0);
    }

    @Test
    public void testTrackedNodeClearedInOperation() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.model.clearTree(null, selector, resolver);
        Assert.assertTrue((String)"Node not detached", (boolean)this.model.isTrackedNodeDetached(selector));
        ImmutableNode node = this.model.getTrackedNode(selector);
        Assert.assertEquals((String)"Name was changed", (Object)"table", (Object)node.getNodeName());
        Assert.assertFalse((String)"Node is defined", (boolean)this.model.getNodeHandler().isDefined((Object)node));
    }

    @Test
    public void testGetTrackedNodeHandlerActive() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        NodeHandler handler = this.model.getTrackedNodeHandler(selector);
        Assert.assertTrue((String)("Wrong node handler: " + handler), (boolean)(handler instanceof TrackedNodeHandler));
        Assert.assertSame((String)"Wrong root node", (Object)this.model.getTrackedNode(selector), (Object)handler.getRootNode());
        TrackedNodeHandler tnh = (TrackedNodeHandler)handler;
        Assert.assertSame((String)"Wrong parent handler", (Object)this.model.getTreeData(), (Object)tnh.getParentHandler());
    }

    @Test
    public void testGetTrackedNodeHandlerDetached() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.initDetachedNode(resolver);
        NodeHandler handler = this.model.getTrackedNodeHandler(selector);
        Assert.assertSame((String)"Wrong root node", (Object)this.model.getTrackedNode(selector), (Object)handler.getRootNode());
        Assert.assertTrue((String)("Wrong handler: " + handler), (boolean)(handler instanceof TreeData));
        Assert.assertNotSame((String)"Shared handler", (Object)this.model.getNodeHandler(), (Object)handler);
    }

    private void checkReplaceTrackedNode() {
        ImmutableNode newNode = new ImmutableNode.Builder().name("newNode").create();
        this.model.replaceTrackedNode(selector, newNode);
        Assert.assertSame((String)"Node not changed", (Object)newNode, (Object)this.model.getTrackedNode(selector));
        Assert.assertTrue((String)"Node not detached", (boolean)this.model.isTrackedNodeDetached(selector));
    }

    @Test
    public void testReplaceTrackedNodeForActiveTrackedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.checkReplaceTrackedNode();
    }

    @Test
    public void testReplaceTrackedNodeForDetachedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.initDetachedNode(resolver);
        this.checkReplaceTrackedNode();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplaceTrackedNodeNull() {
        this.model.trackNode(selector, TestInMemoryNodeModelTrackedNodes.createResolver());
        this.model.replaceTrackedNode(selector, null);
    }

    private void expectNodeKey(NodeKeyResolver<ImmutableNode> resolver, ImmutableNode node, String key) {
        HashMap cache = new HashMap();
        EasyMock.expect((Object)resolver.nodeKey((Object)node, cache, this.model.getNodeHandler())).andReturn((Object)key);
    }

    @Test
    public void testSelectAndTrackNodes() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver(false);
        String nodeKey1 = "tables/table(0)";
        String nodeKey2 = "tables/table(1)";
        ImmutableNode node1 = NodeStructureHelper.nodeForKey(root, nodeKey1);
        ImmutableNode node2 = NodeStructureHelper.nodeForKey(root, nodeKey2);
        EasyMock.expect((Object)resolver.resolveNodeKey((Object)root, TEST_KEY, this.model.getNodeHandler())).andReturn(Arrays.asList(node1, node2));
        this.expectNodeKey(resolver, node1, nodeKey1);
        this.expectNodeKey(resolver, node2, nodeKey2);
        EasyMock.replay((Object[])new Object[]{resolver});
        Collection selectors = this.model.selectAndTrackNodes(TEST_KEY, resolver);
        Iterator it = selectors.iterator();
        NodeSelector sel = (NodeSelector)it.next();
        Assert.assertEquals((String)"Wrong selector 1", (Object)new NodeSelector(nodeKey1), (Object)sel);
        Assert.assertSame((String)"Wrong tracked node 1", (Object)node1, (Object)this.model.getTrackedNode(sel));
        sel = (NodeSelector)it.next();
        Assert.assertEquals((String)"Wrong selector 2", (Object)new NodeSelector(nodeKey2), (Object)sel);
        Assert.assertSame((String)"Wrong tracked node 2", (Object)node2, (Object)this.model.getTrackedNode(sel));
        Assert.assertFalse((String)"Too many selectors", (boolean)it.hasNext());
    }

    @Test
    public void testSelectAndTrackNodesNoSelection() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver(false);
        EasyMock.expect((Object)resolver.resolveNodeKey((Object)root, TEST_KEY, this.model.getNodeHandler())).andReturn(Collections.emptyList());
        EasyMock.replay((Object[])new Object[]{resolver});
        Assert.assertTrue((String)"Got selectors", (boolean)this.model.selectAndTrackNodes(TEST_KEY, resolver).isEmpty());
    }

    @Test
    public void testSelectAndTrackNodesNodeAlreadyTracked() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        resolver = TestInMemoryNodeModelTrackedNodes.createResolver(false);
        ImmutableNode node = this.model.getTrackedNode(selector);
        EasyMock.expect((Object)resolver.resolveNodeKey((Object)root, TEST_KEY, this.model.getNodeHandler())).andReturn(Collections.singletonList(node));
        this.expectNodeKey(resolver, node, SELECTOR_KEY);
        EasyMock.replay((Object[])new Object[]{resolver});
        Collection selectors = this.model.selectAndTrackNodes(TEST_KEY, resolver);
        Assert.assertEquals((String)"Wrong number of selectors", (long)1L, (long)selectors.size());
        Assert.assertEquals((String)"Wrong selector", (Object)selector, selectors.iterator().next());
        this.model.untrackNode(selector);
        Assert.assertSame((String)"Node not tracked", (Object)node, (Object)this.model.getTrackedNode(selector));
    }

    @Test
    public void testTrackChildNodes() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver(false);
        ImmutableNode node = NodeStructureHelper.nodeForKey(root, "tables");
        String[] keys = new String[node.getChildren().size()];
        for (int i = 0; i < keys.length; ++i) {
            ImmutableNode child = (ImmutableNode)node.getChildren().get(i);
            keys[i] = String.format("%s.%s(%d)", node.getNodeName(), child.getNodeName(), i);
            this.expectNodeKey(resolver, child, keys[i]);
        }
        EasyMock.expect((Object)resolver.resolveNodeKey((Object)root, TEST_KEY, this.model.getNodeHandler())).andReturn(Collections.singletonList(node));
        EasyMock.replay((Object[])new Object[]{resolver});
        Collection selectors = this.model.trackChildNodes(TEST_KEY, resolver);
        Assert.assertEquals((String)"Wrong number of selectors", (long)node.getChildren().size(), (long)selectors.size());
        int idx = 0;
        for (NodeSelector sel : selectors) {
            Assert.assertEquals((String)"Wrong selector", (Object)new NodeSelector(keys[idx]), (Object)sel);
            Assert.assertEquals((String)("Wrong tracked node for " + sel), node.getChildren().get(idx), (Object)this.model.getTrackedNode(sel));
            ++idx;
        }
    }

    private void checkTrackChildNodesNoResult(List<ImmutableNode> queryResult) {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver(false);
        EasyMock.expect((Object)resolver.resolveNodeKey((Object)root, TEST_KEY, this.model.getNodeHandler())).andReturn(queryResult);
        EasyMock.replay((Object[])new Object[]{resolver});
        TreeData oldData = this.model.getTreeData();
        Assert.assertTrue((String)"Got selectors", (boolean)this.model.trackChildNodes(TEST_KEY, resolver).isEmpty());
        Assert.assertSame((String)"Model was changed", (Object)oldData, (Object)this.model.getTreeData());
    }

    @Test
    public void testTrackChildNodesNoResults() {
        this.checkTrackChildNodesNoResult(Collections.<ImmutableNode>emptyList());
    }

    @Test
    public void testTrackChildNodesMultipleResults() {
        this.checkTrackChildNodesNoResult(Arrays.asList(NodeStructureHelper.nodeForKey(root, "tables/table(0)"), NodeStructureHelper.nodeForKey(root, "tables/table(1)")));
    }

    @Test
    public void testTrackChildNodesNodeWithNoChildren() {
        this.checkTrackChildNodesNoResult(Collections.singletonList(NodeStructureHelper.nodeForKey(root, "tables/table(0)/name")));
    }

    @Test
    public void testTrackChildNodeWithCreationExisting() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver(false);
        String childName = "name";
        String parentKey = "tables/table(0)";
        String childKey = parentKey + "/" + childName;
        ImmutableNode node = NodeStructureHelper.nodeForKey(this.model, parentKey);
        ImmutableNode child = NodeStructureHelper.nodeForKey(node, childName);
        EasyMock.expect((Object)resolver.resolveNodeKey((Object)root, TEST_KEY, this.model.getNodeHandler())).andReturn(Collections.singletonList(node));
        this.expectNodeKey(resolver, child, childKey);
        EasyMock.replay((Object[])new Object[]{resolver});
        NodeSelector childSelector = this.model.trackChildNodeWithCreation(TEST_KEY, childName, resolver);
        Assert.assertEquals((String)"Wrong selector", (Object)new NodeSelector(childKey), (Object)childSelector);
        Assert.assertSame((String)"Wrong tracked node", (Object)child, (Object)this.model.getTrackedNode(childSelector));
    }

    @Test
    public void testTrackChildNodeWithCreationNonExisting() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver(false);
        String childName = "space";
        String parentKey = "tables/table(0)";
        String childKey = parentKey + "/" + childName;
        ImmutableNode node = NodeStructureHelper.nodeForKey(this.model, parentKey);
        EasyMock.expect((Object)resolver.resolveNodeKey((Object)root, TEST_KEY, this.model.getNodeHandler())).andReturn(Collections.singletonList(node));
        EasyMock.expect((Object)resolver.nodeKey(EasyMock.anyObject(ImmutableNode.class), (Map)EasyMock.eq(new HashMap()), (NodeHandler)EasyMock.anyObject(TreeData.class))).andReturn((Object)childKey);
        EasyMock.replay((Object[])new Object[]{resolver});
        NodeSelector childSelector = this.model.trackChildNodeWithCreation(TEST_KEY, childName, resolver);
        Assert.assertEquals((String)"Wrong selector", (Object)new NodeSelector(childKey), (Object)childSelector);
        ImmutableNode child = this.model.getTrackedNode(childSelector);
        Assert.assertEquals((String)"Wrong child name", (Object)childName, (Object)child.getNodeName());
        Assert.assertNull((String)"Got a value", (Object)child.getValue());
        ImmutableNode parent = (ImmutableNode)this.model.getNodeHandler().getParent((Object)child);
        Assert.assertEquals((String)"Wrong parent node", (Object)"table", (Object)parent.getNodeName());
        Assert.assertEquals((String)"Wrong node path", (Object)child, (Object)NodeStructureHelper.nodeForKey(this.model, childKey));
    }

    private void checkTrackChildNodeWithCreationInvalidKey(List<ImmutableNode> queryResult) {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver(false);
        EasyMock.expect((Object)resolver.resolveNodeKey((Object)this.model.getRootNode(), TEST_KEY, this.model.getNodeHandler())).andReturn(queryResult);
        EasyMock.replay((Object[])new Object[]{resolver});
        this.model.trackChildNodeWithCreation(TEST_KEY, "someChild", resolver);
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testTrackChildNodeWithCreationNoResults() {
        this.checkTrackChildNodeWithCreationInvalidKey(new ArrayList<ImmutableNode>());
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testTrackChildNodeWithCreationMultipleResults() {
        List<ImmutableNode> nodes = Arrays.asList(NodeStructureHelper.nodeForKey(root, "tables/table(0)"), NodeStructureHelper.nodeForKey(root, "tables/table(1)"));
        this.checkTrackChildNodeWithCreationInvalidKey(nodes);
    }
}

