/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeAddData;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestNodeAddData {
    private static final String TEST_NODENAME = "testNewNode";
    private static final String PATH_NODE_NAME = "PATHNODE";
    private static ImmutableNode parentNode;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        parentNode = new ImmutableNode.Builder().name("testParent").create();
    }

    @Test
    public void testPathNodesNull() {
        NodeAddData data = new NodeAddData((Object)parentNode, TEST_NODENAME, false, null);
        Assert.assertTrue((String)"Got path nodes", (boolean)data.getPathNodes().isEmpty());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPathNodesNullModify() {
        NodeAddData data = new NodeAddData((Object)parentNode, TEST_NODENAME, false, null);
        data.getPathNodes().add("test");
    }

    @Test
    public void testInitPathNodesDefensiveCopy() {
        ArrayList<String> pathNodes = new ArrayList<String>();
        pathNodes.add(PATH_NODE_NAME);
        NodeAddData data = new NodeAddData((Object)parentNode, TEST_NODENAME, false, pathNodes);
        pathNodes.add("anotherNode");
        Assert.assertEquals((String)"Wrong number of path nodes", (long)1L, (long)data.getPathNodes().size());
        Assert.assertEquals((String)"Wrong path node", (Object)PATH_NODE_NAME, data.getPathNodes().get(0));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPathNodesDefinedModify() {
        NodeAddData data = new NodeAddData((Object)parentNode, TEST_NODENAME, false, Collections.singleton(PATH_NODE_NAME));
        data.getPathNodes().add("anotherNode");
    }
}

