/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree.xpath;

import java.util.Locale;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.QueryResult;
import org.apache.commons.configuration2.tree.xpath.ConfigurationAttributePointer;
import org.apache.commons.configuration2.tree.xpath.ConfigurationNodePointer;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConfigurationAttributePointer {
    private static final String ATTR_NAME = "myAttr";
    private static final String ATTR_VALUE = "myValue";
    private ConfigurationNodePointer<ImmutableNode> parent;
    private ConfigurationAttributePointer<ImmutableNode> pointer;

    @Before
    public void setUp() throws Exception {
        ImmutableNode.Builder ndBuilder = new ImmutableNode.Builder();
        ndBuilder.name("parent").addAttribute(ATTR_NAME, (Object)ATTR_VALUE);
        ImmutableNode nd = ndBuilder.create();
        this.parent = new ConfigurationNodePointer((Object)nd, Locale.ENGLISH, new InMemoryNodeModel(nd).getNodeHandler());
        this.pointer = new ConfigurationAttributePointer(this.parent, ATTR_NAME);
    }

    @Test
    public void testGetParentPointer() {
        Assert.assertSame((String)"Wrong parent pointer", this.parent, (Object)this.pointer.getParentPointer());
    }

    @Test
    public void testGetBaseValue() {
        Assert.assertEquals((String)"Wrong base value", (Object)ATTR_VALUE, (Object)this.pointer.getBaseValue());
    }

    @Test
    public void testGetImmediateNode() {
        Object node = this.pointer.getImmediateNode();
        Assert.assertTrue((String)"Wrong node class", (boolean)(node instanceof QueryResult));
        QueryResult proxy = (QueryResult)node;
        Assert.assertTrue((String)"No attribute result", (boolean)proxy.isAttributeResult());
        Assert.assertEquals((String)"Wrong parent node", (Object)this.parent.getConfigurationNode(), (Object)proxy.getNode());
        Assert.assertEquals((String)"Wrong attribute name", (Object)ATTR_NAME, (Object)proxy.getAttributeName());
    }

    @Test
    public void testGetLength() {
        Assert.assertEquals((String)"Wrong length", (long)1L, (long)this.pointer.getLength());
    }

    @Test
    public void testGetName() {
        QName name = this.pointer.getName();
        Assert.assertEquals((String)"Wrong name", (Object)ATTR_NAME, (Object)name.getName());
        Assert.assertNull((String)"Prefix not null", (Object)name.getPrefix());
    }

    @Test
    public void testIsCollection() {
        Assert.assertFalse((String)"Wrong collection flag", (boolean)this.pointer.isCollection());
    }

    @Test
    public void testIsLeaf() {
        Assert.assertTrue((String)"Wrong leaf flag", (boolean)this.pointer.isLeaf());
    }

    @Test
    public void testIsAttribute() {
        Assert.assertTrue((String)"Not an attribute", (boolean)this.pointer.isAttribute());
    }

    @Test
    public void testGetValue() {
        Assert.assertEquals((String)"Wrong value", (Object)ATTR_VALUE, (Object)this.pointer.getValue());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetValue() {
        this.pointer.setValue((Object)"newValue");
    }

    @Test
    public void testAttributeIterator() {
        Assert.assertNull((String)"Returned an attribute iterator", (Object)this.pointer.attributeIterator(new QName(null, "test")));
    }

    @Test
    public void testChildIterator() {
        Assert.assertNull((String)"Returned an iterator for children", (Object)this.pointer.childIterator(null, false, null));
    }

    @Test
    public void testTestNode() {
        NodeTypeTest test = new NodeTypeTest(2);
        Assert.assertTrue((String)"No a text node", (boolean)this.pointer.testNode((NodeTest)test));
        test = new NodeTypeTest(3);
        Assert.assertFalse((String)"A comment node", (boolean)this.pointer.testNode((NodeTest)test));
    }
}

