/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.commons.configuration2.NonCloneableConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.StrictConfigurationComparator;
import org.apache.commons.configuration2.SynchronizerTestImpl;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.LegacyListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventListenerTestImpl;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCompositeConfiguration {
    private static final String TEST_PROPERTY = "test.source.property";
    protected PropertiesConfiguration conf1;
    protected PropertiesConfiguration conf2;
    protected XMLConfiguration xmlConf;
    protected CompositeConfiguration cc;
    private final String testProperties = ConfigurationAssert.getTestFile("test.properties").getAbsolutePath();
    private final String testProperties2 = ConfigurationAssert.getTestFile("test2.properties").getAbsolutePath();
    private final String testPropertiesXML = ConfigurationAssert.getTestFile("test.xml").getAbsolutePath();

    @Before
    public void setUp() throws Exception {
        this.cc = new CompositeConfiguration();
        LegacyListDelimiterHandler listHandler = new LegacyListDelimiterHandler(',');
        this.conf1 = new PropertiesConfiguration();
        this.conf1.setListDelimiterHandler((ListDelimiterHandler)listHandler);
        FileHandler handler1 = new FileHandler((FileBased)this.conf1);
        handler1.setFileName(this.testProperties);
        handler1.load();
        this.conf2 = new PropertiesConfiguration();
        this.conf2.setListDelimiterHandler((ListDelimiterHandler)listHandler);
        FileHandler handler2 = new FileHandler((FileBased)this.conf2);
        handler2.setFileName(this.testProperties2);
        handler2.load();
        this.xmlConf = new XMLConfiguration();
        FileHandler handler3 = new FileHandler((FileBased)this.xmlConf);
        handler3.load(new File(this.testPropertiesXML));
        this.cc.setThrowExceptionOnMissing(true);
    }

    @Test
    public void testThrowExceptionOnMissing() {
        Assert.assertTrue((String)"Throw Exception Property is not set!", (boolean)this.cc.isThrowExceptionOnMissing());
    }

    @Test
    public void testAddRemoveConfigurations() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        Assert.assertEquals((String)"Number of configurations", (long)2L, (long)this.cc.getNumberOfConfigurations());
        this.cc.addConfiguration((Configuration)this.conf1);
        Assert.assertEquals((String)"Number of configurations", (long)2L, (long)this.cc.getNumberOfConfigurations());
        this.cc.addConfiguration((Configuration)this.conf2);
        Assert.assertEquals((String)"Number of configurations", (long)3L, (long)this.cc.getNumberOfConfigurations());
        this.cc.removeConfiguration((Configuration)this.conf1);
        Assert.assertEquals((String)"Number of configurations", (long)2L, (long)this.cc.getNumberOfConfigurations());
        this.cc.clear();
        Assert.assertEquals((String)"Number of configurations", (long)1L, (long)this.cc.getNumberOfConfigurations());
    }

    @Test
    public void testGetPropertyWIncludes() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.conf2);
        List l = this.cc.getList("packages");
        Assert.assertTrue((boolean)l.contains("packagea"));
    }

    @Test
    public void testGetProperty() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.conf2);
        Assert.assertEquals((String)"Make sure we get the property from conf1 first", (Object)"test.properties", (Object)this.cc.getString("propertyInOrder"));
        this.cc.clear();
        this.cc.addConfiguration((Configuration)this.conf2);
        this.cc.addConfiguration((Configuration)this.conf1);
        Assert.assertEquals((String)"Make sure we get the property from conf2 first", (Object)"test2.properties", (Object)this.cc.getString("propertyInOrder"));
    }

    @Test
    public void testCantRemoveMemoryConfig() throws Exception {
        this.cc.clear();
        Assert.assertEquals((long)1L, (long)this.cc.getNumberOfConfigurations());
        Configuration internal = this.cc.getConfiguration(0);
        this.cc.removeConfiguration(internal);
        Assert.assertEquals((long)1L, (long)this.cc.getNumberOfConfigurations());
    }

    @Test
    public void testGetPropertyMissing() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.conf2);
        try {
            Assert.assertNull((Object)this.cc.getString("bogus.property"));
            Assert.fail((String)"Should have thrown a NoSuchElementException");
        }
        catch (NoSuchElementException nsee) {
            Assert.assertTrue((boolean)nsee.getMessage().contains("bogus.property"));
        }
        Assert.assertTrue((String)"Should be false", (!this.cc.getBoolean("test.missing.boolean", false) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should be true", (boolean)this.cc.getBoolean("test.missing.boolean.true", true));
    }

    @Test
    public void testMultipleTypesOfConfigs() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Assert.assertEquals((String)"Make sure we get the property from conf1 first", (long)1L, (long)this.cc.getInt("test.short"));
        this.cc.clear();
        this.cc.addConfiguration((Configuration)this.xmlConf);
        this.cc.addConfiguration((Configuration)this.conf1);
        Assert.assertEquals((String)"Make sure we get the property from xml", (long)8L, (long)this.cc.getInt("test.short"));
    }

    @Test
    public void testPropertyExistsInOnlyOneConfig() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Assert.assertEquals((Object)"value", (Object)this.cc.getString("element"));
    }

    @Test
    public void testDefaultValueWhenKeyMissing() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Assert.assertEquals((Object)"default", (Object)this.cc.getString("bogus", "default"));
        Assert.assertTrue((1.4 == this.cc.getDouble("bogus", 1.4) ? 1 : 0) != 0);
        Assert.assertTrue((1.4 == this.cc.getDouble("bogus", 1.4) ? 1 : 0) != 0);
    }

    @Test
    public void testGettingConfiguration() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Assert.assertEquals(PropertiesConfiguration.class, this.cc.getConfiguration(0).getClass());
        Assert.assertEquals(XMLConfiguration.class, this.cc.getConfiguration(1).getClass());
    }

    @Test
    public void testClearingProperty() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        this.cc.clearProperty("test.short");
        Assert.assertTrue((String)"Make sure test.short is gone!", (!this.cc.containsKey("test.short") ? 1 : 0) != 0);
    }

    @Test
    public void testAddingProperty() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        String[] values = this.cc.getStringArray("test.short");
        Assert.assertEquals((String)"Number of values before add is wrong!", (long)1L, (long)values.length);
        Assert.assertEquals((String)"First Value before add is wrong", (Object)"1", (Object)values[0]);
        this.cc.addProperty("test.short", (Object)"88");
        values = this.cc.getStringArray("test.short");
        Assert.assertEquals((String)"Number of values is wrong!", (long)2L, (long)values.length);
        Assert.assertEquals((String)"First Value is wrong", (Object)"1", (Object)values[0]);
        Assert.assertEquals((String)"Third Value is wrong", (Object)"88", (Object)values[1]);
    }

    @Test
    public void testSettingMissingProperty() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        this.cc.setProperty("my.new.property", (Object)"supernew");
        Assert.assertEquals((Object)"supernew", (Object)this.cc.getString("my.new.property"));
    }

    @Test
    public void testGettingSubset() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Configuration subset = this.cc.subset("test");
        Assert.assertNotNull((Object)subset);
        Assert.assertFalse((String)"Shouldn't be empty", (boolean)subset.isEmpty());
        Assert.assertEquals((String)"Make sure the initial loaded configs subset overrides any later add configs subset", (Object)"1", (Object)subset.getString("short"));
        this.cc.setProperty("test.short", (Object)"43");
        subset = this.cc.subset("test");
        Assert.assertEquals((String)"Make sure the initial loaded configs subset overrides any later add configs subset", (Object)"43", (Object)subset.getString("short"));
    }

    @Test
    public void testSubsetCanResolve() throws Exception {
        this.cc = new CompositeConfiguration();
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty("subset.tempfile", (Object)"${java.io.tmpdir}/file.tmp");
        this.cc.addConfiguration((Configuration)config);
        this.cc.addConfiguration(ConfigurationConverter.getConfiguration((Properties)System.getProperties()));
        Configuration subset = this.cc.subset("subset");
        Assert.assertEquals((Object)(System.getProperty("java.io.tmpdir") + "/file.tmp"), (Object)subset.getString("tempfile"));
    }

    @Test
    public void testList() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        List packages = this.cc.getList("packages");
        Assert.assertEquals((long)3L, (long)packages.size());
        ArrayList<String> defaultList = new ArrayList<String>();
        defaultList.add("1");
        defaultList.add("2");
        packages = this.cc.getList("packages.which.dont.exist", defaultList);
        Assert.assertEquals((long)2L, (long)packages.size());
    }

    @Test
    public void testStringArray() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        String[] packages = this.cc.getStringArray("packages");
        Assert.assertEquals((long)3L, (long)packages.length);
        packages = this.cc.getStringArray("packages.which.dont.exist");
        Assert.assertEquals((long)0L, (long)packages.length);
    }

    @Test
    public void testGetList() {
        BaseConfiguration conf1 = new BaseConfiguration();
        conf1.addProperty("array", (Object)"value1");
        conf1.addProperty("array", (Object)"value2");
        BaseConfiguration conf2 = new BaseConfiguration();
        conf2.addProperty("array", (Object)"value3");
        conf2.addProperty("array", (Object)"value4");
        this.cc.addConfiguration((Configuration)conf1);
        this.cc.addConfiguration((Configuration)conf2);
        List list = this.cc.getList("array");
        Assert.assertNotNull((String)"null list", (Object)list);
        Assert.assertEquals((String)"list size", (long)2L, (long)list.size());
        Assert.assertTrue((String)"'value1' not found in the list", (boolean)list.contains("value1"));
        Assert.assertTrue((String)"'value2' not found in the list", (boolean)list.contains("value2"));
        this.cc.addProperty("array", (Object)"value5");
        list = this.cc.getList("array");
        Assert.assertNotNull((String)"null list", (Object)list);
        Assert.assertEquals((String)"list size", (long)3L, (long)list.size());
        Assert.assertTrue((String)"'value1' not found in the list", (boolean)list.contains("value1"));
        Assert.assertTrue((String)"'value2' not found in the list", (boolean)list.contains("value2"));
        Assert.assertTrue((String)"'value5' not found in the list", (boolean)list.contains("value5"));
    }

    @Test
    public void testGetKeysPreservesOrder() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        ArrayList orderedList = new ArrayList();
        Iterator keys = this.conf1.getKeys();
        while (keys.hasNext()) {
            orderedList.add(keys.next());
        }
        ArrayList iteratedList = new ArrayList();
        Iterator keys2 = this.cc.getKeys();
        while (keys2.hasNext()) {
            iteratedList.add(keys2.next());
        }
        Assert.assertEquals((long)orderedList.size(), (long)iteratedList.size());
        for (int i = 0; i < orderedList.size(); ++i) {
            Assert.assertEquals(orderedList.get(i), iteratedList.get(i));
        }
    }

    @Test
    public void testGetKeys2PreservesOrder() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        ArrayList orderedList = new ArrayList();
        Iterator keys = this.conf1.getKeys("test");
        while (keys.hasNext()) {
            orderedList.add(keys.next());
        }
        ArrayList iteratedList = new ArrayList();
        Iterator keys2 = this.cc.getKeys("test");
        while (keys2.hasNext()) {
            iteratedList.add(keys2.next());
        }
        Assert.assertEquals((long)orderedList.size(), (long)iteratedList.size());
        for (int i = 0; i < orderedList.size(); ++i) {
            Assert.assertEquals(orderedList.get(i), iteratedList.get(i));
        }
    }

    @Test
    public void testGetStringWithDefaults() {
        BaseConfiguration defaults = new BaseConfiguration();
        defaults.addProperty("default", (Object)"default string");
        CompositeConfiguration c = new CompositeConfiguration((Configuration)defaults);
        c.setThrowExceptionOnMissing(this.cc.isThrowExceptionOnMissing());
        c.addProperty("string", (Object)"test string");
        Assert.assertEquals((Object)"test string", (Object)c.getString("string"));
        try {
            c.getString("XXX");
            Assert.fail((String)"Should throw NoSuchElementException exception");
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (Exception e) {
            Assert.fail((String)("Should throw NoSuchElementException exception, not " + e));
        }
        Assert.assertEquals((Object)"test string", (Object)c.getString("string", "some default value"));
        Assert.assertEquals((Object)"default string", (Object)c.getString("default"));
        Assert.assertEquals((Object)"default string", (Object)c.getString("default", "some default value"));
        Assert.assertEquals((Object)"some default value", (Object)c.getString("XXX", "some default value"));
    }

    @Test
    public void testCheckingInMemoryConfiguration() throws Exception {
        String TEST_KEY = "testKey";
        PropertiesConfiguration defaults = new PropertiesConfiguration();
        defaults.setProperty(TEST_KEY, (Object)"testValue");
        CompositeConfiguration testConfiguration = new CompositeConfiguration((Configuration)defaults);
        Assert.assertTrue((boolean)testConfiguration.containsKey(TEST_KEY));
        Assert.assertFalse((boolean)testConfiguration.isEmpty());
        boolean foundTestKey = false;
        Iterator i = testConfiguration.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.equals(TEST_KEY)) continue;
            foundTestKey = true;
        }
        Assert.assertTrue((boolean)foundTestKey);
        testConfiguration.clearProperty(TEST_KEY);
        Assert.assertFalse((boolean)testConfiguration.containsKey(TEST_KEY));
    }

    @Test
    public void testStringArrayInterpolation() {
        CompositeConfiguration config = new CompositeConfiguration();
        config.addProperty("base", (Object)"foo");
        config.addProperty("list", (Object)"${base}.bar1");
        config.addProperty("list", (Object)"${base}.bar2");
        config.addProperty("list", (Object)"${base}.bar3");
        String[] array = config.getStringArray("list");
        Assert.assertEquals((String)"size", (long)3L, (long)array.length);
        Assert.assertEquals((String)"1st element", (Object)"foo.bar1", (Object)array[0]);
        Assert.assertEquals((String)"2nd element", (Object)"foo.bar2", (Object)array[1]);
        Assert.assertEquals((String)"3rd element", (Object)"foo.bar3", (Object)array[2]);
    }

    @Test
    public void testListInterpolation() {
        PropertiesConfiguration c1 = new PropertiesConfiguration();
        c1.addProperty("c1.value", (Object)"test1");
        c1.addProperty("c1.value", (Object)"${c2.value}");
        this.cc.addConfiguration((Configuration)c1);
        PropertiesConfiguration c2 = new PropertiesConfiguration();
        c2.addProperty("c2.value", (Object)"test2");
        this.cc.addConfiguration((Configuration)c2);
        List lst = this.cc.getList("c1.value");
        Assert.assertEquals((String)"Wrong list size", (long)2L, (long)lst.size());
        Assert.assertEquals((String)"Wrong first element", (Object)"test1", lst.get(0));
        Assert.assertEquals((String)"Wrong second element", (Object)"test2", lst.get(1));
    }

    @Test
    public void testInstanciateWithCollection() {
        ArrayList<Object> configs = new ArrayList<Object>();
        configs.add(this.xmlConf);
        configs.add(this.conf1);
        configs.add(this.conf2);
        CompositeConfiguration config = new CompositeConfiguration(configs);
        Assert.assertEquals((String)"Number of configurations", (long)4L, (long)config.getNumberOfConfigurations());
        Assert.assertTrue((String)"The in memory configuration is not empty", (boolean)config.getInMemoryConfiguration().isEmpty());
    }

    @Test
    public void testClone() {
        CompositeConfiguration cc2 = (CompositeConfiguration)this.cc.clone();
        Assert.assertEquals((String)"Wrong number of contained configurations", (long)this.cc.getNumberOfConfigurations(), (long)cc2.getNumberOfConfigurations());
        StrictConfigurationComparator comp = new StrictConfigurationComparator();
        for (int i = 0; i < this.cc.getNumberOfConfigurations(); ++i) {
            Assert.assertEquals((String)("Wrong configuration class at " + i), this.cc.getConfiguration(i).getClass(), cc2.getConfiguration(i).getClass());
            Assert.assertNotSame((String)"Configuration was not cloned", (Object)this.cc.getConfiguration(i), (Object)cc2.getConfiguration(i));
            Assert.assertTrue((String)("Configurations at " + i + " not equal"), (boolean)comp.compare(this.cc.getConfiguration(i), cc2.getConfiguration(i)));
        }
        Assert.assertTrue((String)"Configurations are not equal", (boolean)comp.compare((Configuration)this.cc, (Configuration)cc2));
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testCloneNotSupported() {
        this.cc.addConfiguration((Configuration)new NonCloneableConfiguration());
        this.cc.clone();
    }

    @Test
    public void testCloneEventListener() {
        this.cc.addEventListener(ConfigurationEvent.ANY, (EventListener)new EventListenerTestImpl(null));
        CompositeConfiguration cc2 = (CompositeConfiguration)this.cc.clone();
        Assert.assertTrue((String)"Listeners have been cloned", (boolean)cc2.getEventListeners(ConfigurationEvent.ANY).isEmpty());
    }

    @Test
    public void testCloneInterpolation() {
        CompositeConfiguration cc2 = (CompositeConfiguration)this.cc.clone();
        Assert.assertNotSame((String)"Interpolator was not cloned", (Object)this.cc.getInterpolator(), (Object)cc2.getInterpolator());
    }

    @Test
    public void testEventAddProperty() {
        EventListenerTestImpl listener = new EventListenerTestImpl(this.cc);
        this.cc.addEventListener(ConfigurationEvent.ANY, (EventListener)listener);
        this.cc.addProperty("test", (Object)"value");
        listener.checkEvent(ConfigurationEvent.ADD_PROPERTY, "test", "value", true);
        listener.checkEvent(ConfigurationEvent.ADD_PROPERTY, "test", "value", false);
        listener.done();
    }

    @Test
    public void testEventSetProperty() {
        EventListenerTestImpl listener = new EventListenerTestImpl(this.cc);
        this.cc.addEventListener(ConfigurationEvent.ANY, (EventListener)listener);
        this.cc.setProperty("test", (Object)"value");
        listener.checkEvent(ConfigurationEvent.SET_PROPERTY, "test", "value", true);
        listener.checkEvent(ConfigurationEvent.SET_PROPERTY, "test", "value", false);
        listener.done();
    }

    @Test
    public void testEventClearProperty() {
        this.cc.addConfiguration((Configuration)this.conf1);
        String key = "configuration.loaded";
        Assert.assertTrue((String)"Wrong value for property", (boolean)this.cc.getBoolean(key));
        EventListenerTestImpl listener = new EventListenerTestImpl(this.cc);
        this.cc.addEventListener(ConfigurationEvent.ANY, (EventListener)listener);
        this.cc.clearProperty(key);
        Assert.assertFalse((String)"Key still present", (boolean)this.cc.containsKey(key));
        listener.checkEvent(ConfigurationEvent.CLEAR_PROPERTY, key, null, true);
        listener.checkEvent(ConfigurationEvent.CLEAR_PROPERTY, key, null, false);
        listener.done();
    }

    @Test
    public void testSetListDelimiter() {
        this.cc.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler('/'));
        this.checkSetListDelimiterHandler();
    }

    @Test
    public void testSetListDelimiterAfterClear() {
        this.cc.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler('/'));
        this.cc.clear();
        this.checkSetListDelimiterHandler();
    }

    private void checkSetListDelimiterHandler() {
        this.cc.addProperty("test.list", (Object)"a/b/c");
        this.cc.addProperty("test.property", (Object)"a,b,c");
        Assert.assertEquals((String)"Wrong number of list elements", (long)3L, (long)this.cc.getList("test.list").size());
        Assert.assertEquals((String)"Wrong value of property", (Object)"a,b,c", (Object)this.cc.getString("test.property"));
        AbstractConfiguration config = (AbstractConfiguration)this.cc.getInMemoryConfiguration();
        DefaultListDelimiterHandler listHandler = (DefaultListDelimiterHandler)config.getListDelimiterHandler();
        Assert.assertEquals((String)"Wrong list delimiter", (long)47L, (long)listHandler.getDelimiter());
    }

    private void setUpSourceTest() {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.conf2);
    }

    @Test
    public void testGetSourceSingle() {
        this.setUpSourceTest();
        this.conf1.addProperty(TEST_PROPERTY, (Object)Boolean.TRUE);
        Assert.assertSame((String)"Wrong source configuration", (Object)this.conf1, (Object)this.cc.getSource(TEST_PROPERTY));
    }

    @Test
    public void testGetSourceUnknown() {
        this.setUpSourceTest();
        Assert.assertNull((String)"Wrong source for unknown key", (Object)this.cc.getSource(TEST_PROPERTY));
    }

    @Test
    public void testGetSourceInMemory() {
        this.setUpSourceTest();
        this.cc.addProperty(TEST_PROPERTY, (Object)Boolean.TRUE);
        Assert.assertSame((String)"Source not found in in-memory config", (Object)this.cc.getInMemoryConfiguration(), (Object)this.cc.getSource(TEST_PROPERTY));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetSourceMultiple() {
        this.setUpSourceTest();
        this.conf1.addProperty(TEST_PROPERTY, (Object)Boolean.TRUE);
        this.cc.addProperty(TEST_PROPERTY, (Object)"a value");
        this.cc.getSource(TEST_PROPERTY);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetSourceNull() {
        this.cc.getSource(null);
    }

    private void prepareInterpolationTest() {
        PropertiesConfiguration p = new PropertiesConfiguration();
        p.addProperty("foo", (Object)"initial");
        p.addProperty("bar", (Object)"${foo}");
        p.addProperty("prefix.foo", (Object)"override");
        this.cc.addConfiguration(p.subset("prefix"));
        this.cc.addConfiguration((Configuration)p);
        Assert.assertEquals((String)"Wrong value on direct access", (Object)"override", (Object)this.cc.getString("bar"));
    }

    @Test
    public void testGetListWithInterpolation() {
        this.prepareInterpolationTest();
        List lst = this.cc.getList("bar");
        Assert.assertEquals((String)"Wrong number of values", (long)1L, (long)lst.size());
        Assert.assertEquals((String)"Wrong value in list", (Object)"override", lst.get(0));
    }

    @Test
    public void testGetStringArrayWithInterpolation() {
        this.prepareInterpolationTest();
        String[] values = this.cc.getStringArray("bar");
        Assert.assertEquals((String)"Wrong number of values", (long)1L, (long)values.length);
        Assert.assertEquals((String)"Wrong value in array", (Object)"override", (Object)values[0]);
    }

    @Test
    public void testInterpolationInMultipleConfigs() {
        PropertiesConfiguration c1 = new PropertiesConfiguration();
        c1.addProperty("property.one", (Object)"one");
        c1.addProperty("property.two", (Object)"two");
        PropertiesConfiguration c2 = new PropertiesConfiguration();
        c2.addProperty("property.one.ref", (Object)"${property.one}");
        this.cc.addConfiguration((Configuration)c1);
        this.cc.addConfiguration((Configuration)c2);
        Assert.assertEquals((String)"Wrong interpolated value", (Object)"one", (Object)this.cc.getString("property.one.ref"));
    }

    @Test
    public void testInterpolationArrayReference() {
        PropertiesConfiguration props = new PropertiesConfiguration();
        Object[] values = new String[]{"a", "property", "with", "multiple", "values"};
        props.addProperty("keyMultiValues", (Object)values);
        props.addProperty("keyReference", (Object)"${keyMultiValues}");
        this.cc.addConfiguration((Configuration)props);
        Assert.assertArrayEquals((String)"Wrong interpolated value", (Object[])values, (Object[])this.cc.getStringArray("keyReference"));
    }

    @Test
    public void testSetListDelimiterInMemoryConfigNonBaseConfig() {
        Configuration inMemoryConfig = (Configuration)EasyMock.createMock(Configuration.class);
        EasyMock.replay((Object[])new Object[]{inMemoryConfig});
        this.cc = new CompositeConfiguration(inMemoryConfig);
        this.cc.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(';'));
    }

    @Test
    public void testUseChildConfigAsInMemoryConfig() {
        this.conf1.setProperty(TEST_PROPERTY, (Object)"conf1");
        this.conf2.setProperty(TEST_PROPERTY, (Object)"conf2");
        this.cc.addConfiguration((Configuration)this.conf1, true);
        this.cc.addConfiguration((Configuration)this.conf2);
        Assert.assertEquals((String)"Wrong number of configurations", (long)2L, (long)this.cc.getNumberOfConfigurations());
        Assert.assertEquals((String)"Wrong property", (Object)"conf1", (Object)this.cc.getString(TEST_PROPERTY));
        this.cc.addProperty("newProperty", (Object)"newValue");
        Assert.assertEquals((String)"Not added to in-memory config", (Object)"newValue", (Object)this.conf1.getString("newProperty"));
    }

    @Test
    public void testReplaceInMemoryConfig() {
        this.conf1.setProperty(TEST_PROPERTY, (Object)"conf1");
        this.conf2.setProperty(TEST_PROPERTY, (Object)"conf2");
        this.cc.addConfiguration((Configuration)this.conf1, true);
        this.cc.addProperty("newProperty1", (Object)"newValue1");
        this.cc.addConfiguration((Configuration)this.conf2, true);
        this.cc.addProperty("newProperty2", (Object)"newValue2");
        Assert.assertEquals((String)"Wrong property", (Object)"conf1", (Object)this.cc.getString(TEST_PROPERTY));
        Assert.assertEquals((String)"Not added to in-memory config", (Object)"newValue1", (Object)this.conf1.getString("newProperty1"));
        Assert.assertEquals((String)"In-memory config not changed", (Object)"newValue2", (Object)this.conf2.getString("newProperty2"));
    }

    private SynchronizerTestImpl installSynchronizer() {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.conf2);
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        this.cc.setSynchronizer((Synchronizer)sync);
        return sync;
    }

    @Test
    public void testAddConfigurationSynchronized() {
        SynchronizerTestImpl sync = this.installSynchronizer();
        this.cc.addConfiguration((Configuration)this.xmlConf);
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testRemoveConfigurationSynchronized() {
        SynchronizerTestImpl sync = this.installSynchronizer();
        this.cc.removeConfiguration((Configuration)this.conf1);
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testGetConfigurationSynchronized() {
        SynchronizerTestImpl sync = this.installSynchronizer();
        Assert.assertEquals((String)"Wrong result", (Object)this.conf1, (Object)this.cc.getConfiguration(0));
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testGetInMemoryConfigurationSynchronized() {
        SynchronizerTestImpl sync = this.installSynchronizer();
        this.cc.getInMemoryConfiguration();
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testGetNumberOfConfigurationsSynchronized() {
        SynchronizerTestImpl sync = this.installSynchronizer();
        Assert.assertEquals((String)"Wrong number of configurations", (long)3L, (long)this.cc.getNumberOfConfigurations());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }
}

