/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.DatabaseConfiguration;
import org.apache.commons.configuration2.DatabaseConfigurationTestHelper;
import org.apache.commons.configuration2.builder.fluent.DatabaseBuilderParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.ConfigurationErrorEvent;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.ErrorListenerTestImpl;
import org.apache.commons.configuration2.event.EventType;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDatabaseConfiguration {
    private static final String CONFIG_NAME2 = "anotherTestConfig";
    private ErrorListenerTestImpl listener;
    private DatabaseConfigurationTestHelper helper;

    @Before
    public void setUp() throws Exception {
        this.helper = new DatabaseConfigurationTestHelper();
        this.helper.setUp();
    }

    @After
    public void tearDown() throws Exception {
        if (this.listener != null) {
            this.listener.done();
        }
        this.helper.tearDown();
    }

    private PotentialErrorDatabaseConfiguration setUpConfig() throws ConfigurationException {
        return this.helper.setUpConfig(PotentialErrorDatabaseConfiguration.class);
    }

    private void setUpErrorListener(PotentialErrorDatabaseConfiguration config) {
        config.clearErrorListeners();
        this.listener = new ErrorListenerTestImpl((Object)config);
        config.addEventListener(ConfigurationErrorEvent.ANY, this.listener);
        config.failOnConnect = true;
    }

    private PotentialErrorDatabaseConfiguration setUpErrorConfig() throws ConfigurationException {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        this.setUpErrorListener(config);
        return config;
    }

    private void checkErrorListener(EventType<? extends ConfigurationErrorEvent> type, EventType<?> opType, String key, Object value) {
        Throwable exception = this.listener.checkEvent(type, opType, key, value);
        Assert.assertTrue((String)"Wrong exception", (boolean)(exception instanceof SQLException));
        this.listener = null;
    }

    @Test
    public void testAddPropertyDirectSingle() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.addPropertyDirect("key", (Object)"value");
        Assert.assertTrue((String)"missing property", (boolean)config.containsKey("key"));
    }

    @Test
    public void testAddPropertyDirectCommit() throws ConfigurationException {
        this.helper.setAutoCommit(false);
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.addPropertyDirect("key", (Object)"value");
        Assert.assertTrue((String)"missing property", (boolean)config.containsKey("key"));
    }

    @Test
    public void testAddPropertyDirectMultiple() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        config.addPropertyDirect("key", (Object)"value");
        Assert.assertTrue((String)"missing property", (boolean)config.containsKey("key"));
    }

    @Test
    public void testAddNonStringProperty() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.addPropertyDirect("boolean", (Object)Boolean.TRUE);
        Assert.assertTrue((String)"missing property", (boolean)config.containsKey("boolean"));
    }

    @Test
    public void testGetPropertyDirectSingle() throws ConfigurationException {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        Assert.assertEquals((String)"property1", (Object)"value1", (Object)config.getProperty("key1"));
        Assert.assertEquals((String)"property2", (Object)"value2", (Object)config.getProperty("key2"));
        Assert.assertEquals((String)"unknown property", null, (Object)config.getProperty("key3"));
    }

    @Test
    public void testGetPropertyDirectMultiple() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        Assert.assertEquals((String)"property1", (Object)"value1", (Object)config.getProperty("key1"));
        Assert.assertEquals((String)"property2", (Object)"value2", (Object)config.getProperty("key2"));
        Assert.assertEquals((String)"unknown property", null, (Object)config.getProperty("key3"));
    }

    @Test
    public void testClearPropertySingle() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.clearProperty("key1");
        Assert.assertFalse((String)"property not cleared", (boolean)config.containsKey("key1"));
    }

    @Test
    public void testClearPropertyMultiple() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        config.clearProperty("key1");
        Assert.assertFalse((String)"property not cleared", (boolean)config.containsKey("key1"));
    }

    @Test
    public void testClearPropertyMultipleOtherConfig() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        DatabaseConfiguration config2 = this.helper.setUpMultiConfig(DatabaseConfiguration.class, CONFIG_NAME2);
        config2.addProperty("key1", (Object)"some test");
        config.clearProperty("key1");
        Assert.assertFalse((String)"property not cleared", (boolean)config.containsKey("key1"));
        Assert.assertTrue((String)"Property cleared in other config", (boolean)config2.containsKey("key1"));
    }

    @Test
    public void testClearPropertyCommit() throws ConfigurationException {
        this.helper.setAutoCommit(false);
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.clearProperty("key1");
        Assert.assertFalse((String)"property not cleared", (boolean)config.containsKey("key1"));
    }

    @Test
    public void testClearSingle() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.clear();
        Assert.assertTrue((String)"configuration is not cleared", (boolean)config.isEmpty());
    }

    @Test
    public void testClearMultiple() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        config.clear();
        Assert.assertTrue((String)"configuration is not cleared", (boolean)config.isEmpty());
    }

    @Test
    public void testClearCommit() throws ConfigurationException {
        this.helper.setAutoCommit(false);
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.clear();
        Assert.assertTrue((String)"configuration is not cleared", (boolean)config.isEmpty());
    }

    @Test
    public void testGetKeysSingle() throws ConfigurationException {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        Iterator it = config.getKeys();
        Assert.assertEquals((String)"1st key", (Object)"key1", it.next());
        Assert.assertEquals((String)"2nd key", (Object)"key2", it.next());
    }

    @Test
    public void testGetKeysMultiple() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        Iterator it = config.getKeys();
        Assert.assertEquals((String)"1st key", (Object)"key1", it.next());
        Assert.assertEquals((String)"2nd key", (Object)"key2", it.next());
    }

    @Test
    public void testContainsKeySingle() throws ConfigurationException {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        Assert.assertTrue((String)"missing key1", (boolean)config.containsKey("key1"));
        Assert.assertTrue((String)"missing key2", (boolean)config.containsKey("key2"));
    }

    @Test
    public void testContainsKeyMultiple() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        Assert.assertTrue((String)"missing key1", (boolean)config.containsKey("key1"));
        Assert.assertTrue((String)"missing key2", (boolean)config.containsKey("key2"));
    }

    @Test
    public void testIsEmptySingle() throws ConfigurationException {
        PotentialErrorDatabaseConfiguration config1 = this.setUpConfig();
        Assert.assertFalse((String)"The configuration is empty", (boolean)config1.isEmpty());
    }

    @Test
    public void testIsEmptyMultiple() throws ConfigurationException {
        DatabaseConfiguration config1 = this.helper.setUpMultiConfig();
        Assert.assertFalse((String)"The configuration named 'test' is empty", (boolean)config1.isEmpty());
        DatabaseConfiguration config2 = this.helper.setUpMultiConfig(DatabaseConfiguration.class, "testIsEmpty");
        Assert.assertTrue((String)"The configuration named 'testIsEmpty' is not empty", (boolean)config2.isEmpty());
    }

    @Test
    public void testGetList() throws ConfigurationException {
        DatabaseBuilderParameters params = (DatabaseBuilderParameters)this.helper.setUpDefaultParameters().setTable("configurationList");
        DatabaseConfiguration config1 = this.helper.createConfig(DatabaseConfiguration.class, params);
        List list = config1.getList("key3");
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testGetKeys() throws ConfigurationException {
        DatabaseBuilderParameters params = (DatabaseBuilderParameters)this.helper.setUpDefaultParameters().setTable("configurationList");
        DatabaseConfiguration config1 = this.helper.createConfig(DatabaseConfiguration.class, params);
        Iterator i = config1.getKeys();
        Assert.assertTrue((boolean)i.hasNext());
        Object key = i.next();
        Assert.assertEquals((Object)"key3", (Object)key.toString());
        Assert.assertFalse((boolean)i.hasNext());
    }

    @Test
    public void testClearSubset() throws ConfigurationException {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        Configuration subset = config.subset("key1");
        subset.clear();
        Assert.assertTrue((String)"the subset is not empty", (boolean)subset.isEmpty());
        Assert.assertFalse((String)"the parent configuration is empty", (boolean)config.isEmpty());
    }

    @Test
    public void testLogErrorListener() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpConfig();
        Assert.assertEquals((String)"No error listener registered", (long)1L, (long)config.getEventListeners(ConfigurationErrorEvent.ANY).size());
    }

    @Test
    public void testGetPropertyError() throws ConfigurationException {
        this.setUpErrorConfig().getProperty("key1");
        this.checkErrorListener((EventType<? extends ConfigurationErrorEvent>)ConfigurationErrorEvent.READ, ConfigurationErrorEvent.READ, "key1", null);
    }

    @Test
    public void testAddPropertyError() throws ConfigurationException {
        this.setUpErrorConfig().addProperty("key1", "value");
        this.checkErrorListener((EventType<? extends ConfigurationErrorEvent>)ConfigurationErrorEvent.WRITE, ConfigurationEvent.ADD_PROPERTY, "key1", "value");
    }

    @Test
    public void testIsEmptyError() throws ConfigurationException {
        Assert.assertTrue((String)"Wrong return value for failure", (boolean)this.setUpErrorConfig().isEmpty());
        this.checkErrorListener((EventType<? extends ConfigurationErrorEvent>)ConfigurationErrorEvent.READ, ConfigurationErrorEvent.READ, null, null);
    }

    @Test
    public void testContainsKeyError() throws ConfigurationException {
        Assert.assertFalse((String)"Wrong return value for failure", (boolean)this.setUpErrorConfig().containsKey("key1"));
        this.checkErrorListener((EventType<? extends ConfigurationErrorEvent>)ConfigurationErrorEvent.READ, ConfigurationErrorEvent.READ, "key1", null);
    }

    @Test
    public void testClearPropertyError() throws ConfigurationException {
        this.setUpErrorConfig().clearProperty("key1");
        this.checkErrorListener((EventType<? extends ConfigurationErrorEvent>)ConfigurationErrorEvent.WRITE, ConfigurationEvent.CLEAR_PROPERTY, "key1", null);
    }

    @Test
    public void testClearError() throws ConfigurationException {
        this.setUpErrorConfig().clear();
        this.checkErrorListener((EventType<? extends ConfigurationErrorEvent>)ConfigurationErrorEvent.WRITE, ConfigurationEvent.CLEAR, null, null);
    }

    @Test
    public void testGetKeysError() throws ConfigurationException {
        Iterator it = this.setUpErrorConfig().getKeys();
        this.checkErrorListener((EventType<? extends ConfigurationErrorEvent>)ConfigurationErrorEvent.READ, ConfigurationErrorEvent.READ, null, null);
        Assert.assertFalse((String)"Iteration is not empty", (boolean)it.hasNext());
    }

    @Test
    public void testGetListWithDelimiter() throws ConfigurationException {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(';'));
        List values = config.getList("keyMulti");
        Assert.assertEquals((String)"Wrong number of list elements", (long)3L, (long)values.size());
        Assert.assertEquals((String)"Wrong list element 0", (Object)"a", values.get(0));
        Assert.assertEquals((String)"Wrong list element 2", (Object)"c", values.get(2));
    }

    @Test
    public void testGetListWithDelimiterParsingDisabled() throws ConfigurationException {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        Assert.assertEquals((String)"Wrong value of property", (Object)"a;b;c", (Object)config.getString("keyMulti"));
    }

    @Test
    public void testAddWithDelimiter() throws ConfigurationException {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(';'));
        config.addProperty("keyList", "1;2;3");
        String[] values = config.getStringArray("keyList");
        Assert.assertEquals((String)"Wrong number of property values", (long)3L, (long)values.length);
        Assert.assertEquals((String)"Wrong value at index 1", (Object)"2", (Object)values[1]);
    }

    @Test
    public void testSetPropertyWithDelimiter() throws ConfigurationException {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(';'));
        config.setProperty("keyList", (Object)"1;2;3");
        String[] values = config.getStringArray("keyList");
        Assert.assertEquals((String)"Wrong number of property values", (long)3L, (long)values.length);
        Assert.assertEquals((String)"Wrong value at index 1", (Object)"2", (Object)values[1]);
    }

    @Test
    public void testExtractPropertyValueCLOB() throws ConfigurationException, SQLException {
        ResultSet rs = (ResultSet)EasyMock.createMock(ResultSet.class);
        Clob clob = (Clob)EasyMock.createMock(Clob.class);
        String content = "This is the content of the test CLOB!";
        EasyMock.expect((Object)rs.getObject("value")).andReturn((Object)clob);
        EasyMock.expect((Object)clob.length()).andReturn((Object)"This is the content of the test CLOB!".length());
        EasyMock.expect((Object)clob.getSubString(1L, "This is the content of the test CLOB!".length())).andReturn((Object)"This is the content of the test CLOB!");
        EasyMock.replay((Object[])new Object[]{rs, clob});
        DatabaseConfiguration config = this.helper.setUpConfig();
        Assert.assertEquals((String)"Wrong extracted value", (Object)"This is the content of the test CLOB!", (Object)config.extractPropertyValue(rs));
        EasyMock.verify((Object[])new Object[]{rs, clob});
    }

    @Test
    public void testExtractPropertyValueCLOBEmpty() throws ConfigurationException, SQLException {
        ResultSet rs = (ResultSet)EasyMock.createMock(ResultSet.class);
        Clob clob = (Clob)EasyMock.createMock(Clob.class);
        EasyMock.expect((Object)rs.getObject("value")).andReturn((Object)clob);
        EasyMock.expect((Object)clob.length()).andReturn((Object)0L);
        EasyMock.replay((Object[])new Object[]{rs, clob});
        DatabaseConfiguration config = this.helper.setUpConfig();
        Assert.assertEquals((String)"Wrong extracted value", (Object)"", (Object)config.extractPropertyValue(rs));
        EasyMock.verify((Object[])new Object[]{rs, clob});
    }

    public static class PotentialErrorDatabaseConfiguration
    extends DatabaseConfiguration {
        boolean failOnConnect;

        public DataSource getDatasource() {
            if (this.failOnConnect) {
                DataSource ds = (DataSource)EasyMock.createMock(DataSource.class);
                try {
                    EasyMock.expect((Object)ds.getConnection()).andThrow((Throwable)new SQLException("Simulated DB error"));
                }
                catch (SQLException e) {
                    throw new AssertionError((Object)"Unexpected exception!");
                }
                EasyMock.replay((Object[])new Object[]{ds});
                return ds;
            }
            return super.getDatasource();
        }
    }
}

