/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.JNDIConfiguration;
import org.apache.commons.configuration2.MockInitialContextFactory;
import org.apache.commons.configuration2.NonStringTestHolder;
import org.apache.commons.configuration2.event.ConfigurationErrorEvent;
import org.apache.commons.configuration2.event.ErrorListenerTestImpl;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestJNDIConfiguration {
    public static final String CONTEXT_FACTORY = MockInitialContextFactory.class.getName();
    private PotentialErrorJNDIConfiguration conf;
    private NonStringTestHolder nonStringTestHolder;
    private ErrorListenerTestImpl listener;

    @Before
    public void setUp() throws Exception {
        System.setProperty("java.naming.factory.initial", CONTEXT_FACTORY);
        Properties props = new Properties();
        props.put("java.naming.factory.initial", CONTEXT_FACTORY);
        InitialContext ctx = new InitialContext(props);
        this.conf = new PotentialErrorJNDIConfiguration(ctx);
        this.nonStringTestHolder = new NonStringTestHolder();
        this.nonStringTestHolder.setConfiguration((Configuration)this.conf);
        this.listener = new ErrorListenerTestImpl((Object)this.conf);
        this.conf.addEventListener(ConfigurationErrorEvent.ANY, this.listener);
    }

    @After
    public void tearDown() throws Exception {
        if (this.listener != null) {
            this.listener.done();
        }
    }

    @Test
    public void testBoolean() throws Exception {
        this.nonStringTestHolder.testBoolean();
    }

    @Test
    public void testBooleanDefaultValue() throws Exception {
        this.nonStringTestHolder.testBooleanDefaultValue();
    }

    @Test
    public void testByte() throws Exception {
        this.nonStringTestHolder.testByte();
    }

    @Test
    public void testDouble() throws Exception {
        this.nonStringTestHolder.testDouble();
    }

    @Test
    public void testDoubleDefaultValue() throws Exception {
        this.nonStringTestHolder.testDoubleDefaultValue();
    }

    @Test
    public void testFloat() throws Exception {
        this.nonStringTestHolder.testFloat();
    }

    @Test
    public void testFloatDefaultValue() throws Exception {
        this.nonStringTestHolder.testFloatDefaultValue();
    }

    @Test
    public void testInteger() throws Exception {
        this.nonStringTestHolder.testInteger();
    }

    @Test
    public void testIntegerDefaultValue() throws Exception {
        this.nonStringTestHolder.testIntegerDefaultValue();
    }

    @Test
    public void testLong() throws Exception {
        this.nonStringTestHolder.testLong();
    }

    @Test
    public void testLongDefaultValue() throws Exception {
        this.nonStringTestHolder.testLongDefaultValue();
    }

    @Test
    public void testShort() throws Exception {
        this.nonStringTestHolder.testShort();
    }

    @Test
    public void testShortDefaultValue() throws Exception {
        this.nonStringTestHolder.testShortDefaultValue();
    }

    @Test
    public void testListMissing() throws Exception {
        this.nonStringTestHolder.testListMissing();
    }

    @Test
    public void testSubset() throws Exception {
        this.nonStringTestHolder.testSubset();
    }

    @Test
    public void testProperties() throws Exception {
        Object o = this.conf.getProperty("test.boolean");
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)"true", (Object)o.toString());
    }

    @Test
    public void testContainsKey() {
        String key = "test.boolean";
        Assert.assertTrue((String)("'" + key + "' not found"), (boolean)this.conf.containsKey(key));
        this.conf.clearProperty(key);
        Assert.assertFalse((String)("'" + key + "' still found"), (boolean)this.conf.containsKey(key));
    }

    @Test
    public void testChangePrefix() {
        Assert.assertEquals((String)"'test.boolean' property", (Object)"true", (Object)this.conf.getString("test.boolean"));
        Assert.assertEquals((String)"'boolean' property", null, (Object)this.conf.getString("boolean"));
        this.conf.setPrefix("test");
        Assert.assertEquals((String)"'test.boolean' property", null, (Object)this.conf.getString("test.boolean"));
        Assert.assertEquals((String)"'boolean' property", (Object)"true", (Object)this.conf.getString("boolean"));
    }

    @Test
    public void testResetRemovedProperties() throws Exception {
        Assert.assertEquals((String)"'test.boolean' property", (Object)"true", (Object)this.conf.getString("test.boolean"));
        this.conf.clearProperty("test.boolean");
        Assert.assertEquals((String)"'test.boolean' property", null, (Object)this.conf.getString("test.boolean"));
        this.conf.setContext(new InitialContext());
        Assert.assertEquals((String)"'test.boolean' property", (Object)"true", (Object)this.conf.getString("test.boolean"));
    }

    @Test
    public void testConstructor() throws Exception {
        JNDIConfiguration c = new JNDIConfiguration((Context)new InitialContext());
        Assert.assertEquals((String)"'test.boolean' property", (Object)"true", (Object)c.getString("test.boolean"));
        c = new JNDIConfiguration((Context)new InitialContext(), "test");
        Assert.assertEquals((String)"'boolean' property", (Object)"true", (Object)c.getString("boolean"));
    }

    private PotentialErrorJNDIConfiguration setUpErrorConfig() {
        this.conf.installException();
        Iterator iterator = this.conf.getEventListeners(ConfigurationErrorEvent.ANY).iterator();
        this.conf.removeEventListener(ConfigurationErrorEvent.ANY, (EventListener)iterator.next());
        return this.conf;
    }

    private void checkErrorListener(EventType<? extends ConfigurationErrorEvent> type, EventType<?> opEventType, String propName, Object propValue) {
        Throwable exception = this.listener.checkEvent(type, opEventType, propName, propValue);
        Assert.assertTrue((String)"Wrong exception class", (boolean)(exception instanceof NamingException));
        this.listener = null;
    }

    @Test
    public void testLogListener() throws NamingException {
        JNDIConfiguration c = new JNDIConfiguration();
        Assert.assertEquals((String)"No error log listener registered", (long)1L, (long)c.getEventListeners(ConfigurationErrorEvent.ANY).size());
    }

    @Test
    public void testGetKeysError() {
        Assert.assertFalse((String)"Iteration not empty", (boolean)this.setUpErrorConfig().getKeys().hasNext());
        this.checkErrorListener((EventType<? extends ConfigurationErrorEvent>)ConfigurationErrorEvent.READ, ConfigurationErrorEvent.READ, null, null);
    }

    @Test
    public void testIsEmptyError() throws Exception {
        Assert.assertTrue((String)"Error config not empty", (boolean)this.setUpErrorConfig().isEmpty());
        this.checkErrorListener((EventType<? extends ConfigurationErrorEvent>)ConfigurationErrorEvent.READ, ConfigurationErrorEvent.READ, null, null);
    }

    @Test
    public void testContainsKeyError() {
        Assert.assertFalse((String)"Key contained after error", (boolean)this.setUpErrorConfig().containsKey("key"));
        this.checkErrorListener((EventType<? extends ConfigurationErrorEvent>)ConfigurationErrorEvent.READ, ConfigurationErrorEvent.READ, "key", null);
    }

    @Test
    public void testGetPropertyError() {
        Assert.assertNull((String)"Wrong property value after error", (Object)this.setUpErrorConfig().getProperty("key"));
        this.checkErrorListener((EventType<? extends ConfigurationErrorEvent>)ConfigurationErrorEvent.READ, ConfigurationErrorEvent.READ, "key", null);
    }

    @Test
    public void testGetKeysWithCycles() throws NamingException {
        Hashtable<String, Boolean> env = new Hashtable<String, Boolean>();
        env.put("useCycles", Boolean.TRUE);
        InitialContext initCtx = new InitialContext(env);
        JNDIConfiguration c = new JNDIConfiguration((Context)initCtx);
        c.getKeys("cycle");
    }

    @Test
    public void testGetKeysNoData() {
        this.conf.installException(new NameNotFoundException("Test exception"));
        Assert.assertFalse((String)"Got keys", (boolean)this.conf.getKeys().hasNext());
        this.listener.done();
    }

    public static class PotentialErrorJNDIConfiguration
    extends JNDIConfiguration {
        private NamingException exception;

        public PotentialErrorJNDIConfiguration(Context ctx) throws NamingException {
            super(ctx);
        }

        public void installException(NamingException nex) {
            this.exception = nex;
        }

        public void installException() {
            this.installException(new NamingException("Simulated JNDI exception!"));
        }

        public Context getBaseContext() throws NamingException {
            if (this.exception != null) {
                throw this.exception;
            }
            return super.getBaseContext();
        }
    }
}

