/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import org.apache.commons.configuration2.builder.BuilderEventListenerImpl;
import org.apache.commons.configuration2.builder.ConfigurationBuilder;
import org.apache.commons.configuration2.builder.ConfigurationBuilderEvent;
import org.apache.commons.configuration2.builder.ConfigurationBuilderResultCreatedEvent;
import org.apache.commons.configuration2.event.Event;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventType;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicConfigurationBuilderEvents {
    @Test
    public void testBuilderEventType() {
        EventType builderEventType = ConfigurationBuilderEvent.ANY;
        Assert.assertEquals((String)"Wrong super type", (Object)Event.ANY, (Object)builderEventType.getSuperType());
    }

    @Test
    public void testBuilderResetEventType() {
        EventType builderResetType = ConfigurationBuilderEvent.RESET;
        Assert.assertEquals((String)"Wrong super type", (Object)ConfigurationBuilderEvent.ANY, (Object)builderResetType.getSuperType());
    }

    @Test
    public void testBuilderResetEvent() {
        BuilderEventListenerImpl listener = new BuilderEventListenerImpl();
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        builder.addEventListener(ConfigurationBuilderEvent.RESET, (EventListener)listener);
        builder.reset();
        builder.resetResult();
        Object event = listener.nextEvent(ConfigurationBuilderEvent.RESET);
        Assert.assertSame((String)"Wrong builder (1)", (Object)builder, (Object)event.getSource());
        event = listener.nextEvent(ConfigurationBuilderEvent.RESET);
        Assert.assertSame((String)"Wrong builder (2)", (Object)builder, (Object)event.getSource());
        listener.assertNoMoreEvents();
    }

    @Test
    public void testRemoveEventListener() {
        BuilderEventListenerImpl listener = new BuilderEventListenerImpl();
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        builder.addEventListener(ConfigurationBuilderEvent.RESET, (EventListener)listener);
        builder.reset();
        Assert.assertTrue((String)"Wrong result", (boolean)builder.removeEventListener(ConfigurationBuilderEvent.RESET, (EventListener)listener));
        builder.resetResult();
        listener.nextEvent(ConfigurationBuilderEvent.RESET);
        listener.assertNoMoreEvents();
    }

    @Test
    public void testRemoveEventListenerNotExisting() {
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        BuilderEventListenerImpl listener = new BuilderEventListenerImpl();
        builder.addEventListener(ConfigurationBuilderEvent.RESET, (EventListener)listener);
        Assert.assertFalse((String)"Wrong result", (boolean)builder.removeEventListener(ConfigurationBuilderEvent.CONFIGURATION_REQUEST, (EventListener)listener));
    }

    @Test
    public void testConfigurationRequestEventType() {
        EventType eventType = ConfigurationBuilderEvent.CONFIGURATION_REQUEST;
        Assert.assertEquals((String)"Wrong super type", (Object)ConfigurationBuilderEvent.ANY, (Object)eventType.getSuperType());
    }

    @Test
    public void testConfigurationRequestEvent() throws ConfigurationException {
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        builder.getConfiguration();
        BuilderEventListenerImpl listener = new BuilderEventListenerImpl();
        builder.addEventListener(ConfigurationBuilderEvent.ANY, (EventListener)listener);
        builder.getConfiguration();
        Object event = listener.nextEvent(ConfigurationBuilderEvent.CONFIGURATION_REQUEST);
        Assert.assertSame((String)"Wrong builder", (Object)builder, (Object)event.getSource());
        listener.assertNoMoreEvents();
    }

    @Test
    public void testResetOnConfigurationRequestEvent() throws ConfigurationException {
        final BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        PropertiesConfiguration configuration = (PropertiesConfiguration)builder.getConfiguration();
        BuilderEventListenerImpl listener = new BuilderEventListenerImpl();
        builder.addEventListener(ConfigurationBuilderEvent.RESET, (EventListener)listener);
        builder.addEventListener(ConfigurationBuilderEvent.CONFIGURATION_REQUEST, (EventListener)new EventListener<ConfigurationBuilderEvent>(){

            public void onEvent(ConfigurationBuilderEvent event) {
                builder.resetResult();
            }
        });
        PropertiesConfiguration configuration2 = (PropertiesConfiguration)builder.getConfiguration();
        Assert.assertNotSame((String)"Configuration not reset", (Object)configuration, (Object)configuration2);
        listener.nextEvent(ConfigurationBuilderEvent.RESET);
        listener.assertNoMoreEvents();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testResultCreatedEventNoConfiguration() {
        new ConfigurationBuilderResultCreatedEvent((ConfigurationBuilder)new BasicConfigurationBuilder(Configuration.class), ConfigurationBuilderResultCreatedEvent.RESULT_CREATED, null);
    }

    @Test
    public void testResultCreatedEventType() {
        Assert.assertEquals((String)"Wrong super type", (Object)ConfigurationBuilderEvent.ANY, (Object)ConfigurationBuilderResultCreatedEvent.RESULT_CREATED.getSuperType());
    }

    @Test
    public void testResultCreatedEvent() throws ConfigurationException {
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        BuilderEventListenerImpl listener = new BuilderEventListenerImpl();
        builder.addEventListener(ConfigurationBuilderEvent.ANY, (EventListener)listener);
        PropertiesConfiguration configuration = (PropertiesConfiguration)builder.getConfiguration();
        listener.nextEvent(ConfigurationBuilderEvent.CONFIGURATION_REQUEST);
        ConfigurationBuilderResultCreatedEvent event = (ConfigurationBuilderResultCreatedEvent)listener.nextEvent(ConfigurationBuilderResultCreatedEvent.RESULT_CREATED);
        Assert.assertSame((String)"Wrong builder", (Object)builder, (Object)event.getSource());
        Assert.assertSame((String)"Wrong configuration", (Object)configuration, (Object)event.getConfiguration());
    }
}

