/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.fluent;

import java.io.File;
import java.net.URL;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.combined.CombinedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.plist.PropertyListConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestConfigurations {
    private static final String TEST_PROPERTIES = "test.properties";
    private static final String TEST_XML = "test.xml";
    private static final String TEST_INI = "test.ini";
    private static final String TEST_COMBINED = "testDigesterConfiguration.xml";
    private static final String TEST_PLIST = "test.plist";

    private static String filePath(String name) {
        return ConfigurationAssert.getTestFile(name).getAbsolutePath();
    }

    @Test
    public void testDefaultParameters() {
        Configurations configs = new Configurations();
        Assert.assertNotNull((String)"No parameters", (Object)configs.getParameters());
    }

    @Test
    public void testInitWithParameters() {
        Parameters params = new Parameters();
        Configurations configs = new Configurations(params);
        Assert.assertSame((String)"Wrong parameters", (Object)params, (Object)configs.getParameters());
    }

    @Test
    public void testFileBasedBuilderWithFile() {
        Configurations configs = new Configurations();
        File file = ConfigurationAssert.getTestFile(TEST_PROPERTIES);
        FileBasedConfigurationBuilder builder = configs.fileBasedBuilder(PropertiesConfiguration.class, file);
        Assert.assertEquals((String)"Wrong file", (Object)file.toURI(), (Object)builder.getFileHandler().getFile().toURI());
    }

    @Test
    public void testFileBasedBuilderWithURL() {
        Configurations configs = new Configurations();
        URL url = ConfigurationAssert.getTestURL(TEST_PROPERTIES);
        FileBasedConfigurationBuilder builder = configs.fileBasedBuilder(PropertiesConfiguration.class, url);
        Assert.assertEquals((String)"Wrong URL", (Object)url, (Object)builder.getFileHandler().getURL());
    }

    @Test
    public void testFileBasedBuilderWithPath() {
        Configurations configs = new Configurations();
        String filePath = TestConfigurations.filePath(TEST_PROPERTIES);
        FileBasedConfigurationBuilder builder = configs.fileBasedBuilder(PropertiesConfiguration.class, filePath);
        Assert.assertEquals((String)"Wrong path", (Object)filePath, (Object)builder.getFileHandler().getFileName());
    }

    private static void checkPList(Configuration config) {
        Assert.assertEquals((Object)"string1", (Object)config.getProperty("simple-string"));
    }

    @Test
    public void testFileBasedFile() throws ConfigurationException {
        Configurations configs = new Configurations();
        PropertyListConfiguration config = (PropertyListConfiguration)configs.fileBased(PropertyListConfiguration.class, ConfigurationAssert.getTestFile(TEST_PLIST));
        TestConfigurations.checkPList((Configuration)config);
    }

    @Test
    public void testFileBasedURL() throws ConfigurationException {
        Configurations configs = new Configurations();
        PropertyListConfiguration config = (PropertyListConfiguration)configs.fileBased(PropertyListConfiguration.class, ConfigurationAssert.getTestURL(TEST_PLIST));
        TestConfigurations.checkPList((Configuration)config);
    }

    @Test
    public void testFileBasedPath() throws ConfigurationException {
        Configurations configs = new Configurations();
        PropertyListConfiguration config = (PropertyListConfiguration)configs.fileBased(PropertyListConfiguration.class, TestConfigurations.filePath(TEST_PLIST));
        TestConfigurations.checkPList((Configuration)config);
    }

    private static void checkProperties(Configuration config) {
        Assert.assertEquals((Object)"true", (Object)config.getString("configuration.loaded"));
    }

    @Test
    public void testPropertiesBuilderFromFile() throws ConfigurationException {
        Configurations configs = new Configurations();
        FileBasedConfigurationBuilder builder = configs.propertiesBuilder(ConfigurationAssert.getTestFile(TEST_PROPERTIES));
        TestConfigurations.checkProperties((Configuration)builder.getConfiguration());
    }

    @Test
    public void testPropertiesFromFile() throws ConfigurationException {
        Configurations configs = new Configurations();
        PropertiesConfiguration config = configs.properties(ConfigurationAssert.getTestFile(TEST_PROPERTIES));
        TestConfigurations.checkProperties((Configuration)config);
    }

    @Test
    public void testPropertiesBuilderFromURL() throws ConfigurationException {
        Configurations configs = new Configurations();
        FileBasedConfigurationBuilder builder = configs.propertiesBuilder(ConfigurationAssert.getTestURL(TEST_PROPERTIES));
        TestConfigurations.checkProperties((Configuration)builder.getConfiguration());
    }

    @Test
    public void testPropertiesFromURL() throws ConfigurationException {
        Configurations configs = new Configurations();
        PropertiesConfiguration config = configs.properties(ConfigurationAssert.getTestURL(TEST_PROPERTIES));
        TestConfigurations.checkProperties((Configuration)config);
    }

    @Test
    public void testPropertiesBuilderFromPath() throws ConfigurationException {
        Configurations configs = new Configurations();
        FileBasedConfigurationBuilder builder = configs.propertiesBuilder(TestConfigurations.filePath(TEST_PROPERTIES));
        TestConfigurations.checkProperties((Configuration)builder.getConfiguration());
    }

    @Test
    public void testPropertiesFromPath() throws ConfigurationException {
        Configurations configs = new Configurations();
        PropertiesConfiguration config = configs.properties(TestConfigurations.filePath(TEST_PROPERTIES));
        TestConfigurations.checkProperties((Configuration)config);
    }

    private static void checkXML(Configuration config) {
        Assert.assertEquals((Object)"value", (Object)config.getProperty("element"));
    }

    @Test
    public void testXMLBuilderFromFile() throws ConfigurationException {
        Configurations configs = new Configurations();
        FileBasedConfigurationBuilder builder = configs.xmlBuilder(ConfigurationAssert.getTestFile(TEST_XML));
        TestConfigurations.checkXML((Configuration)builder.getConfiguration());
    }

    @Test
    public void testXMLFromFile() throws ConfigurationException {
        Configurations configs = new Configurations();
        XMLConfiguration config = configs.xml(ConfigurationAssert.getTestFile(TEST_XML));
        TestConfigurations.checkXML((Configuration)config);
    }

    @Test
    public void testXMLBuilderFromURL() throws ConfigurationException {
        Configurations configs = new Configurations();
        FileBasedConfigurationBuilder builder = configs.xmlBuilder(ConfigurationAssert.getTestURL(TEST_XML));
        TestConfigurations.checkXML((Configuration)builder.getConfiguration());
    }

    @Test
    public void testXMLFromURL() throws ConfigurationException {
        Configurations configs = new Configurations();
        XMLConfiguration config = configs.xml(ConfigurationAssert.getTestURL(TEST_XML));
        TestConfigurations.checkXML((Configuration)config);
    }

    @Test
    public void testXMLBuilderFromPath() throws ConfigurationException {
        Configurations configs = new Configurations();
        FileBasedConfigurationBuilder builder = configs.xmlBuilder(TestConfigurations.filePath(TEST_XML));
        TestConfigurations.checkXML((Configuration)builder.getConfiguration());
    }

    @Test
    public void testXMLFromPath() throws ConfigurationException {
        Configurations configs = new Configurations();
        XMLConfiguration config = configs.xml(TestConfigurations.filePath(TEST_XML));
        TestConfigurations.checkXML((Configuration)config);
    }

    private static void checkINI(INIConfiguration config) {
        Assert.assertEquals((Object)"yes", (Object)config.getProperty("testini.loaded"));
    }

    @Test
    public void testINIBuilderFromFile() throws ConfigurationException {
        Configurations configs = new Configurations();
        FileBasedConfigurationBuilder builder = configs.iniBuilder(ConfigurationAssert.getTestFile(TEST_INI));
        TestConfigurations.checkINI((INIConfiguration)builder.getConfiguration());
    }

    @Test
    public void testINIFromFile() throws ConfigurationException {
        Configurations configs = new Configurations();
        INIConfiguration config = configs.ini(ConfigurationAssert.getTestFile(TEST_INI));
        TestConfigurations.checkINI(config);
    }

    @Test
    public void testINIBuilderFromURL() throws ConfigurationException {
        Configurations configs = new Configurations();
        FileBasedConfigurationBuilder builder = configs.iniBuilder(ConfigurationAssert.getTestURL(TEST_INI));
        TestConfigurations.checkINI((INIConfiguration)builder.getConfiguration());
    }

    @Test
    public void testINIFromURL() throws ConfigurationException {
        Configurations configs = new Configurations();
        INIConfiguration config = configs.ini(ConfigurationAssert.getTestURL(TEST_INI));
        TestConfigurations.checkINI(config);
    }

    @Test
    public void testINIBuilderFromPath() throws ConfigurationException {
        Configurations configs = new Configurations();
        FileBasedConfigurationBuilder builder = configs.iniBuilder(TestConfigurations.filePath(TEST_INI));
        TestConfigurations.checkINI((INIConfiguration)builder.getConfiguration());
    }

    @Test
    public void testINIFromPath() throws ConfigurationException {
        Configurations configs = new Configurations();
        INIConfiguration config = configs.ini(TestConfigurations.filePath(TEST_INI));
        TestConfigurations.checkINI(config);
    }

    private static void checkCombined(Configuration config) {
        TestConfigurations.checkProperties(config);
        TestConfigurations.checkXML(config);
    }

    @Test
    public void testCombinedBuilderFromFile() throws ConfigurationException {
        Configurations configs = new Configurations();
        CombinedConfigurationBuilder builder = configs.combinedBuilder(ConfigurationAssert.getTestFile(TEST_COMBINED));
        TestConfigurations.checkCombined((Configuration)builder.getConfiguration());
    }

    @Test
    public void testCombinedFromFile() throws ConfigurationException {
        Configurations configs = new Configurations();
        CombinedConfiguration config = configs.combined(ConfigurationAssert.getTestFile(TEST_COMBINED));
        TestConfigurations.checkCombined((Configuration)config);
    }

    @Test
    public void testCombinedBuilderFromURL() throws ConfigurationException {
        Configurations configs = new Configurations();
        CombinedConfigurationBuilder builder = configs.combinedBuilder(ConfigurationAssert.getTestURL(TEST_COMBINED));
        TestConfigurations.checkCombined((Configuration)builder.getConfiguration());
    }

    @Test
    public void testCombinedFromURL() throws ConfigurationException {
        Configurations configs = new Configurations();
        CombinedConfiguration config = configs.combined(ConfigurationAssert.getTestURL(TEST_COMBINED));
        TestConfigurations.checkCombined((Configuration)config);
    }

    @Test
    public void testCombinedBuilderFromPath() throws ConfigurationException {
        Configurations configs = new Configurations();
        CombinedConfigurationBuilder builder = configs.combinedBuilder(TestConfigurations.filePath(TEST_COMBINED));
        TestConfigurations.checkCombined((Configuration)builder.getConfiguration());
    }

    @Test
    public void testCombinedFromPath() throws ConfigurationException {
        Configurations configs = new Configurations();
        CombinedConfiguration config = configs.combined(TestConfigurations.filePath(TEST_COMBINED));
        TestConfigurations.checkCombined((Configuration)config);
    }
}

