/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.interpol;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.interpol.InterpolatorSpecification;
import org.apache.commons.configuration2.interpol.Lookup;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestInterpolatorSpecification {
    private static final String PREFIX1 = "p1";
    private static final String PREFIX2 = "p2";
    private InterpolatorSpecification.Builder builder;

    @Before
    public void setUp() throws Exception {
        this.builder = new InterpolatorSpecification.Builder();
    }

    private static <T> T createMock(Class<T> cls) {
        Object mock = EasyMock.createMock(cls);
        EasyMock.replay((Object[])new Object[]{mock});
        return (T)mock;
    }

    private static Lookup createLookup() {
        return TestInterpolatorSpecification.createMock(Lookup.class);
    }

    private static void checkPrefixLookups(InterpolatorSpecification spec, Lookup prefLook1, Lookup prefLook2) {
        Assert.assertEquals((String)"Wrong number of prefix lookups", (long)2L, (long)spec.getPrefixLookups().size());
        Assert.assertSame((String)"Wrong prefix lookup 1", (Object)prefLook1, spec.getPrefixLookups().get(PREFIX1));
        Assert.assertSame((String)"Wrong prefix lookup 2", (Object)prefLook2, spec.getPrefixLookups().get(PREFIX2));
    }

    private static void checkDefaultLookups(InterpolatorSpecification spec, Lookup defLook1, Lookup defLook2) {
        Assert.assertEquals((String)"Wrong number of default lookups", (long)2L, (long)spec.getDefaultLookups().size());
        Assert.assertTrue((String)"Wrong default lookups", (boolean)spec.getDefaultLookups().containsAll(Arrays.asList(defLook1, defLook2)));
    }

    @Test
    public void testCreateInstance() {
        Lookup prefLook1 = TestInterpolatorSpecification.createLookup();
        Lookup prefLook2 = TestInterpolatorSpecification.createLookup();
        Lookup defLook1 = TestInterpolatorSpecification.createLookup();
        Lookup defLook2 = TestInterpolatorSpecification.createLookup();
        ConfigurationInterpolator interpolator = TestInterpolatorSpecification.createMock(ConfigurationInterpolator.class);
        ConfigurationInterpolator parent = TestInterpolatorSpecification.createMock(ConfigurationInterpolator.class);
        InterpolatorSpecification spec = this.builder.withPrefixLookup(PREFIX1, prefLook1).withDefaultLookup(defLook1).withPrefixLookup(PREFIX2, prefLook2).withParentInterpolator(parent).withDefaultLookup(defLook2).withInterpolator(interpolator).create();
        Assert.assertSame((String)"Wrong interpolator", (Object)interpolator, (Object)spec.getInterpolator());
        Assert.assertSame((String)"Wrong parent interpolator", (Object)parent, (Object)spec.getParentInterpolator());
        TestInterpolatorSpecification.checkPrefixLookups(spec, prefLook1, prefLook2);
        TestInterpolatorSpecification.checkDefaultLookups(spec, defLook1, defLook2);
    }

    @Test
    public void testCreateInstanceCollections() {
        Lookup prefLook1 = TestInterpolatorSpecification.createLookup();
        Lookup prefLook2 = TestInterpolatorSpecification.createLookup();
        Lookup defLook1 = TestInterpolatorSpecification.createLookup();
        Lookup defLook2 = TestInterpolatorSpecification.createLookup();
        HashMap<String, Lookup> prefixLookups = new HashMap<String, Lookup>();
        prefixLookups.put(PREFIX1, prefLook1);
        prefixLookups.put(PREFIX2, prefLook2);
        InterpolatorSpecification spec = this.builder.withPrefixLookups(prefixLookups).withDefaultLookups(Arrays.asList(defLook1, defLook2)).create();
        TestInterpolatorSpecification.checkPrefixLookups(spec, prefLook1, prefLook2);
        TestInterpolatorSpecification.checkDefaultLookups(spec, defLook1, defLook2);
    }

    @Test
    public void testWithPrefixLookupsNull() {
        InterpolatorSpecification spec = this.builder.withPrefixLookups(null).create();
        Assert.assertTrue((String)"No empty map with prefix lookups", (boolean)spec.getPrefixLookups().isEmpty());
    }

    @Test
    public void testWithDefaultLookupsNull() {
        InterpolatorSpecification spec = this.builder.withDefaultLookups(null).create();
        Assert.assertTrue((String)"No empty default lookups collection", (boolean)spec.getDefaultLookups().isEmpty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithPrefixLookupNoPrefix() {
        this.builder.withPrefixLookup(null, TestInterpolatorSpecification.createLookup());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithPrefixLookupNoLookup() {
        this.builder.withPrefixLookup(PREFIX1, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithDefaultLookupNull() {
        this.builder.withDefaultLookup(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetPrefixLookupsModify() {
        InterpolatorSpecification spec = this.builder.withPrefixLookup(PREFIX1, TestInterpolatorSpecification.createLookup()).create();
        spec.getPrefixLookups().put(PREFIX1, TestInterpolatorSpecification.createLookup());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetDefaultLookupsModify() {
        InterpolatorSpecification spec = this.builder.withDefaultLookup(TestInterpolatorSpecification.createLookup()).create();
        spec.getDefaultLookups().add(TestInterpolatorSpecification.createLookup());
    }

    @Test
    public void testBuilderReuse() {
        this.builder.withDefaultLookup(TestInterpolatorSpecification.createLookup()).withInterpolator(TestInterpolatorSpecification.createMock(ConfigurationInterpolator.class)).withPrefixLookup("test", TestInterpolatorSpecification.createLookup()).withParentInterpolator(TestInterpolatorSpecification.createMock(ConfigurationInterpolator.class)).create();
        Lookup prefLook1 = TestInterpolatorSpecification.createLookup();
        Lookup prefLook2 = TestInterpolatorSpecification.createLookup();
        Lookup defLook1 = TestInterpolatorSpecification.createLookup();
        Lookup defLook2 = TestInterpolatorSpecification.createLookup();
        ConfigurationInterpolator parent = TestInterpolatorSpecification.createMock(ConfigurationInterpolator.class);
        InterpolatorSpecification spec = this.builder.withPrefixLookup(PREFIX1, prefLook1).withPrefixLookup(PREFIX2, prefLook2).withDefaultLookups(Arrays.asList(defLook1, defLook2)).withParentInterpolator(parent).create();
        Assert.assertNull((String)"Got an interpolator", (Object)spec.getInterpolator());
        Assert.assertSame((String)"Wrong parent interpolator", (Object)parent, (Object)spec.getParentInterpolator());
        TestInterpolatorSpecification.checkPrefixLookups(spec, prefLook1, prefLook2);
        TestInterpolatorSpecification.checkDefaultLookups(spec, defLook1, defLook2);
    }
}

