/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SynchronizerTestImpl;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.DefaultFileSystem;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.io.FileHandlerListener;
import org.apache.commons.configuration2.io.FileHandlerListenerAdapter;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorAware;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.configuration2.io.InputStreamSupport;
import org.apache.commons.configuration2.io.ProvidedURLLocationStrategy;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestFileHandler {
    private static final String TEST_FILENAME = "test.properties";
    private static final String CONTENT = "TestFileHandler: This is test content.";
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTestFile(File f) {
        FileWriter out = null;
        File file = f;
        try {
            if (file == null) {
                file = this.folder.newFile();
            }
            out = new FileWriter(file);
            out.write(CONTENT);
        }
        catch (IOException ioex) {
            Assert.fail((String)("Could not create test file: " + ioex));
            File file2 = null;
            return file2;
        }
        finally {
            if (out != null) {
                try {
                    ((Writer)out).close();
                }
                catch (IOException iOException) {}
            }
        }
        return file;
    }

    private File createTestFile() {
        return this.createTestFile(null);
    }

    private static String readReader(Reader in) throws IOException {
        int c;
        StringBuilder buf = new StringBuilder();
        while ((c = in.read()) != -1) {
            buf.append((char)c);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File f) {
        FileReader in = null;
        try {
            in = new FileReader(f);
            String string = TestFileHandler.readReader(in);
            return string;
        }
        catch (IOException ioex) {
            Assert.fail((String)("Could not read file: " + ioex));
            String string = null;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    ((Reader)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Test
    public void testGetFileSystemDefault() {
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        Assert.assertEquals((String)"Wrong default file system", (Object)FileLocatorUtils.DEFAULT_FILE_SYSTEM, (Object)handler.getFileSystem());
    }

    @Test
    public void testSetFileSystemNull() {
        FileSystem sys = (FileSystem)EasyMock.createMock(FileSystem.class);
        EasyMock.replay((Object[])new Object[]{sys});
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.setFileSystem(sys);
        Assert.assertSame((String)"File system not set", (Object)sys, (Object)handler.getFileSystem());
        handler.setFileSystem(null);
        Assert.assertEquals((String)"Not default file system", (Object)FileLocatorUtils.DEFAULT_FILE_SYSTEM, (Object)handler.getFileSystem());
    }

    @Test
    public void testResetFileSystem() {
        FileSystem sys = (FileSystem)EasyMock.createMock(FileSystem.class);
        EasyMock.replay((Object[])new Object[]{sys});
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.setFileSystem(sys);
        handler.resetFileSystem();
        Assert.assertEquals((String)"Not default file system", (Object)FileLocatorUtils.DEFAULT_FILE_SYSTEM, (Object)handler.getFileSystem());
    }

    @Test
    public void testGetLocationStrategyDefault() {
        FileHandler handler = new FileHandler();
        Assert.assertNull((String)"Strategy in locator", (Object)handler.getFileLocator().getLocationStrategy());
        Assert.assertSame((String)"Wrong default strategy", (Object)FileLocatorUtils.DEFAULT_LOCATION_STRATEGY, (Object)handler.getLocationStrategy());
    }

    @Test
    public void testSetLocationStrategy() {
        FileLocationStrategy strategy = (FileLocationStrategy)EasyMock.createMock(FileLocationStrategy.class);
        EasyMock.replay((Object[])new Object[]{strategy});
        FileHandler handler = new FileHandler();
        handler.setLocationStrategy(strategy);
        Assert.assertSame((String)"Wrong strategy in locator", (Object)strategy, (Object)handler.getFileLocator().getLocationStrategy());
        Assert.assertSame((String)"Wrong strategy", (Object)strategy, (Object)handler.getLocationStrategy());
    }

    @Test
    public void testSetURL() throws Exception {
        FileHandler handler = new FileHandler();
        handler.setURL(new URL("http://commons.apache.org/configuration/index.html"));
        Assert.assertEquals((String)"base path", (Object)"http://commons.apache.org/configuration/", (Object)handler.getBasePath());
        Assert.assertEquals((String)"file name", (Object)"index.html", (Object)handler.getFileName());
        Assert.assertNull((String)"Got a file name in locator", (Object)handler.getFileLocator().getFileName());
    }

    @Test
    public void testSetURLFileScheme() throws MalformedURLException {
        FileHandler handler = new FileHandler();
        handler.setURL(new URL("file:/temp/test.properties"));
        Assert.assertEquals((String)"base path", (Object)"file:///temp/", (Object)handler.getBasePath());
        Assert.assertEquals((String)"file name", (Object)TEST_FILENAME, (Object)handler.getFileName());
    }

    @Test
    public void testSetURLWithParams() throws Exception {
        FileHandler handler = new FileHandler();
        URL url = new URL("http://issues.apache.org/bugzilla/show_bug.cgi?id=37886");
        handler.setURL(url);
        Assert.assertEquals((String)"Base path incorrect", (Object)"http://issues.apache.org/bugzilla/", (Object)handler.getBasePath());
        Assert.assertEquals((String)"File name incorrect", (Object)"show_bug.cgi", (Object)handler.getFileName());
        Assert.assertEquals((String)"URL was not correctly stored", (Object)url, (Object)handler.getURL());
    }

    @Test
    public void testSetURLNull() {
        FileHandler handler = new FileHandler();
        handler.setURL(ConfigurationAssert.getTestURL(TEST_FILENAME));
        handler.setURL(null);
        FileLocator locator = handler.getFileLocator();
        Assert.assertNull((String)"Got a base path", (Object)locator.getBasePath());
        Assert.assertNull((String)"Got a file name", (Object)locator.getFileName());
        Assert.assertNull((String)"Got a URL", (Object)locator.getSourceURL());
    }

    @Test
    public void testSetFile() {
        FileHandler handler = new FileHandler();
        File directory = ConfigurationAssert.TEST_DIR;
        File file = ConfigurationAssert.getTestFile(TEST_FILENAME);
        handler.setFile(file);
        Assert.assertEquals((String)"Wrong base path", (Object)directory.getAbsolutePath(), (Object)handler.getBasePath());
        Assert.assertEquals((String)"Wrong file name", (Object)TEST_FILENAME, (Object)handler.getFileName());
        Assert.assertEquals((String)"Wrong path", (Object)file.getAbsolutePath(), (Object)handler.getPath());
    }

    @Test
    public void testSetPath() throws MalformedURLException {
        FileHandler handler = new FileHandler();
        handler.setPath("target/test-classes" + File.separator + TEST_FILENAME);
        Assert.assertEquals((String)"Wrong file name", (Object)TEST_FILENAME, (Object)handler.getFileName());
        Assert.assertEquals((String)"Wrong base path", (Object)ConfigurationAssert.TEST_DIR.getAbsolutePath(), (Object)handler.getBasePath());
        File file = ConfigurationAssert.getTestFile(TEST_FILENAME);
        Assert.assertEquals((String)"Wrong path", (Object)file.getAbsolutePath(), (Object)handler.getPath());
        Assert.assertEquals((String)"Wrong URL", (Object)file.toURI().toURL(), (Object)handler.getURL());
        Assert.assertNull((String)"Got a URL", (Object)handler.getFileLocator().getSourceURL());
    }

    @Test
    public void testSetFileName() {
        FileHandler handler = new FileHandler();
        handler.setURL(ConfigurationAssert.getTestURL(TEST_FILENAME));
        handler.setFileName(TEST_FILENAME);
        Assert.assertNull((String)"Got a base path", (Object)handler.getBasePath());
        Assert.assertEquals((String)"Wrong file name", (Object)TEST_FILENAME, (Object)handler.getFileName());
        Assert.assertEquals((String)"Wrong file name in locator", (Object)TEST_FILENAME, (Object)handler.getFileLocator().getFileName());
        Assert.assertNull((String)"Got a URL", (Object)handler.getFileLocator().getSourceURL());
    }

    @Test
    public void testSetFileNameFileScheme() {
        FileHandler handler = new FileHandler();
        handler.setFileName("file:/test/path/test.txt");
        Assert.assertEquals((String)"Wrong file name", (Object)"file:///test/path/test.txt", (Object)handler.getFileLocator().getFileName());
    }

    @Test
    public void testGetFileNameUndefined() {
        Assert.assertNull((String)"Got a file name", (Object)new FileHandler().getFileName());
    }

    @Test
    public void testSetBasePath() {
        FileHandler handler = new FileHandler();
        handler.setURL(ConfigurationAssert.getTestURL(TEST_FILENAME));
        String basePath = "target/test-classes";
        handler.setBasePath(basePath);
        FileLocator locator = handler.getFileLocator();
        Assert.assertEquals((String)"Wrong base path", (Object)basePath, (Object)locator.getBasePath());
        Assert.assertNull((String)"Got a URL", (Object)locator.getSourceURL());
        Assert.assertNull((String)"Got a file name", (Object)locator.getFileName());
    }

    @Test
    public void testSetBasePathFileScheme() {
        FileHandler handler = new FileHandler();
        handler.setBasePath("file:/test/path/");
        Assert.assertEquals((String)"Wrong base path", (Object)"file:///test/path/", (Object)handler.getFileLocator().getBasePath());
    }

    @Test
    public void testGetBasePathUndefined() {
        Assert.assertNull((String)"Got a base path", (Object)new FileHandler().getBasePath());
    }

    @Test
    public void testSettingFileNames() {
        String testProperties = ConfigurationAssert.getTestFile("test.xml").getAbsolutePath();
        String testBasePath = ConfigurationAssert.TEST_DIR.getAbsolutePath();
        FileHandler handler = new FileHandler();
        handler.setFileName(testProperties);
        Assert.assertEquals((Object)testProperties.toString(), (Object)handler.getFileName());
        handler.setBasePath(testBasePath);
        handler.setFileName("hello.xml");
        Assert.assertEquals((Object)"hello.xml", (Object)handler.getFileName());
        Assert.assertEquals((Object)testBasePath.toString(), (Object)handler.getBasePath());
        Assert.assertEquals((Object)new File(testBasePath, "hello.xml"), (Object)handler.getFile());
        handler.setBasePath(testBasePath);
        handler.setFileName("subdir/hello.xml");
        Assert.assertEquals((Object)"subdir/hello.xml", (Object)handler.getFileName());
        Assert.assertEquals((Object)testBasePath.toString(), (Object)handler.getBasePath());
        Assert.assertEquals((Object)new File(testBasePath, "subdir/hello.xml"), (Object)handler.getFile());
    }

    @Test(expected=ConfigurationException.class)
    public void testLoadNoContent() throws ConfigurationException {
        FileHandler handler = new FileHandler();
        StringReader reader = new StringReader(CONTENT);
        handler.load((Reader)reader);
    }

    @Test
    public void testLoadFromReaderIOException() throws IOException, ConfigurationException {
        FileBased content = (FileBased)EasyMock.createMock(FileBased.class);
        StringReader in = new StringReader(CONTENT);
        IOException ioex = new IOException("Test exception");
        content.read((Reader)in);
        EasyMock.expectLastCall().andThrow((Throwable)ioex);
        EasyMock.replay((Object[])new Object[]{content});
        FileHandler handler = new FileHandler(content);
        try {
            handler.load((Reader)in);
            Assert.fail((String)"IOException not detected!");
        }
        catch (ConfigurationException cex) {
            Assert.assertEquals((String)"Wrong root cause", (Object)ioex, (Object)cex.getCause());
        }
        EasyMock.verify((Object[])new Object[]{content});
    }

    @Test
    public void testLoadFromFile() throws ConfigurationException {
        FileBasedTestImpl content = new FileBasedTestImpl();
        File file = this.createTestFile();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.load(file);
        Assert.assertEquals((String)"Wrong content", (Object)CONTENT, (Object)content.getContent());
    }

    @Test
    public void testLoadFromFileNoContent() throws ConfigurationException {
        FileHandler handler = new FileHandler();
        File file = this.createTestFile();
        try {
            handler.load(file);
            Assert.fail((String)"Missing content not detected!");
        }
        catch (ConfigurationException cex) {
            Assert.assertEquals((String)"Wrong message", (Object)"No content available!", (Object)cex.getMessage());
        }
    }

    @Test(expected=ConfigurationException.class)
    public void testLoadDirectoryString() throws ConfigurationException {
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.load(ConfigurationAssert.TEST_DIR.getAbsolutePath());
    }

    @Test(expected=ConfigurationException.class)
    public void testLoadDirectoryFile() throws ConfigurationException {
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.load(ConfigurationAssert.TEST_DIR);
    }

    @Test
    public void testLoadFromClassPath() throws ConfigurationException {
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler config1 = new FileHandler((FileBased)content);
        config1.setFileName("config/deep/deeptest.properties");
        config1.load();
        Assert.assertTrue((String)"No data loaded", (content.getContent().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadFromURL() throws Exception {
        File file = this.createTestFile();
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.load(file.toURI().toURL());
        Assert.assertEquals((String)"Wrong content", (Object)CONTENT, (Object)content.getContent());
    }

    @Test
    public void testLoadFromFilePath() throws ConfigurationException {
        File file = this.createTestFile();
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.load(file.getAbsolutePath());
        Assert.assertEquals((String)"Wrong content", (Object)CONTENT, (Object)content.getContent());
    }

    @Test
    public void testLoadFromFilePathWithURLDefined() throws ConfigurationException {
        File file = this.createTestFile();
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.setURL(ConfigurationAssert.getTestURL("test.xml"));
        handler.load(file.getAbsolutePath());
        Assert.assertEquals((String)"Wrong content", (Object)CONTENT, (Object)content.getContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadFromStream() throws Exception {
        File file = this.createTestFile();
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        try (FileInputStream in = new FileInputStream(file);){
            handler.load((InputStream)in);
        }
        Assert.assertEquals((String)"Wrong content", (Object)CONTENT, (Object)content.getContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadFromReader() throws Exception {
        File file = this.createTestFile();
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        try (FileReader in = new FileReader(file);){
            handler.load((Reader)in);
        }
        Assert.assertEquals((String)"Wrong content", (Object)CONTENT, (Object)content.getContent());
    }

    @Test
    public void testLoadFromURLLocation() throws Exception {
        File file = this.createTestFile();
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.setURL(file.toURI().toURL());
        handler.load();
        Assert.assertEquals((String)"Wrong content", (Object)CONTENT, (Object)content.getContent());
    }

    @Test
    public void testLoadFromFileNameLocation() throws ConfigurationException {
        File file = this.createTestFile();
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.setBasePath(file.getParentFile().getAbsolutePath());
        handler.setFileName(file.getName());
        handler.load();
        Assert.assertEquals((String)"Wrong content", (Object)CONTENT, (Object)content.getContent());
    }

    @Test(expected=ConfigurationException.class)
    public void testLoadNoLocation() throws ConfigurationException {
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.load();
    }

    @Test
    public void testSaveToWriter() throws ConfigurationException {
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        StringWriter out = new StringWriter();
        handler.save((Writer)out);
        Assert.assertEquals((String)"Wrong content", (Object)CONTENT, (Object)out.toString());
    }

    @Test
    public void testSaveToWriterIOException() throws ConfigurationException, IOException {
        FileBased content = (FileBased)EasyMock.createMock(FileBased.class);
        StringWriter out = new StringWriter();
        IOException ioex = new IOException("Test exception!");
        content.write((Writer)out);
        EasyMock.expectLastCall().andThrow((Throwable)ioex);
        EasyMock.replay((Object[])new Object[]{content});
        FileHandler handler = new FileHandler(content);
        try {
            handler.save((Writer)out);
            Assert.fail((String)"IOException not detected!");
        }
        catch (ConfigurationException cex) {
            Assert.assertEquals((String)"Wrong cause", (Object)ioex, (Object)cex.getCause());
        }
        EasyMock.verify((Object[])new Object[]{content});
    }

    @Test(expected=ConfigurationException.class)
    public void testSaveToWriterNoContent() throws ConfigurationException {
        FileHandler handler = new FileHandler();
        handler.save((Writer)new StringWriter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveToStream() throws ConfigurationException, IOException {
        File file = this.folder.newFile();
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        try (FileOutputStream out = new FileOutputStream(file);){
            handler.save((OutputStream)out);
        }
        Assert.assertEquals((String)"Wrong content", (Object)CONTENT, (Object)TestFileHandler.readFile(file));
    }

    @Test
    public void testSaveToFile() throws ConfigurationException, IOException {
        File file = this.folder.newFile();
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.save(file);
        Assert.assertEquals((String)"Wrong content", (Object)CONTENT, (Object)TestFileHandler.readFile(file));
    }

    @Test
    public void testSaveToURL() throws Exception {
        File file = this.folder.newFile();
        URL url = file.toURI().toURL();
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.save(url);
        Assert.assertEquals((String)"Wrong content", (Object)CONTENT, (Object)TestFileHandler.readFile(file));
    }

    @Test
    public void testSaveToFileName() throws ConfigurationException, IOException {
        File file = this.folder.newFile();
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.save(file.getAbsolutePath());
        Assert.assertEquals((String)"Wrong content", (Object)CONTENT, (Object)TestFileHandler.readFile(file));
    }

    @Test
    public void testSaveToFileNameURLException() throws ConfigurationException, IOException {
        FileSystem fs = (FileSystem)EasyMock.createMock(FileSystem.class);
        File file = this.folder.newFile();
        String basePath = "some base path";
        MalformedURLException urlex = new MalformedURLException("Test exception");
        EasyMock.expect((Object)fs.getURL(basePath, file.getName())).andThrow((Throwable)urlex);
        EasyMock.replay((Object[])new Object[]{fs});
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.setBasePath(basePath);
        handler.setFileSystem(fs);
        try {
            handler.save(file.getName());
            Assert.fail((String)"URL exception not detected!");
        }
        catch (ConfigurationException cex) {
            Assert.assertEquals((String)"Wrong cause", (Object)urlex, (Object)cex.getCause());
        }
        EasyMock.verify((Object[])new Object[]{fs});
    }

    @Test
    public void testSaveToFileNameURLNotResolved() throws ConfigurationException, IOException {
        FileSystem fs = (FileSystem)EasyMock.createMock(FileSystem.class);
        File file = this.folder.newFile();
        EasyMock.expect((Object)fs.getURL(null, file.getName())).andReturn(null);
        EasyMock.replay((Object[])new Object[]{fs});
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.setFileSystem(fs);
        try {
            handler.save(file.getName());
            Assert.fail((String)"Unresolved URL not detected!");
        }
        catch (ConfigurationException cex) {
            EasyMock.verify((Object[])new Object[]{fs});
        }
    }

    @Test
    public void testSaveToFileNameLocation() throws ConfigurationException, IOException {
        File file = this.folder.newFile();
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.setFileName(file.getAbsolutePath());
        handler.save();
        Assert.assertEquals((String)"Wrong content", (Object)CONTENT, (Object)TestFileHandler.readFile(file));
    }

    @Test
    public void testSaveToURLLocation() throws ConfigurationException, IOException {
        File file = this.folder.newFile();
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.setURL(file.toURI().toURL());
        handler.save();
        Assert.assertEquals((String)"Wrong content", (Object)CONTENT, (Object)TestFileHandler.readFile(file));
    }

    @Test(expected=ConfigurationException.class)
    public void testSaveNoLocation() throws ConfigurationException {
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.save();
    }

    @Test
    public void testPathWithSpaces() throws ConfigurationException, IOException {
        File path = this.folder.newFolder("path with spaces");
        File confFile = new File(path, "config-test.properties");
        File testFile = this.createTestFile(confFile);
        URL url = testFile.toURI().toURL();
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.setURL(url);
        handler.load();
        Assert.assertEquals((String)"Wrong data read", (Object)CONTENT, (Object)content.getContent());
        File out = new File(path, "out.txt");
        handler.save(out);
        Assert.assertEquals((String)"Wrong data written", (Object)CONTENT, (Object)TestFileHandler.readFile(out));
    }

    @Test
    public void testPathWithPlus() throws ConfigurationException, IOException {
        File saveFile = this.folder.newFile("test+config.properties");
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        handler.setFile(saveFile);
        handler.save();
        Assert.assertEquals((String)"Wrong content", (Object)CONTENT, (Object)TestFileHandler.readFile(saveFile));
    }

    @Test
    public void testAssignWithFileBased() {
        FileHandler h1 = new FileHandler();
        File f = new File("testfile.txt");
        h1.setFile(f);
        FileBasedTestImpl content = new FileBasedTestImpl();
        FileHandler h2 = new FileHandler((FileBased)content, h1);
        h1.setFileName("someOtherFile.txt");
        Assert.assertSame((String)"Content not set", (Object)content, (Object)h2.getContent());
        Assert.assertEquals((String)"Wrong location", (Object)f, (Object)h2.getFile());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAssignNullHandler() {
        new FileHandler((FileBased)new FileBasedTestImpl(), null);
    }

    @Test
    public void testIsLocationDefinedFile() {
        FileHandler handler = new FileHandler();
        handler.setFile(this.createTestFile());
        Assert.assertTrue((String)"Location not defined", (boolean)handler.isLocationDefined());
    }

    @Test
    public void testIsLocationDefinedURL() throws IOException {
        FileHandler handler = new FileHandler();
        handler.setURL(this.createTestFile().toURI().toURL());
        Assert.assertTrue((String)"Location not defined", (boolean)handler.isLocationDefined());
    }

    @Test
    public void testIsLocationDefinedPath() {
        FileHandler handler = new FileHandler();
        handler.setPath(this.createTestFile().getAbsolutePath());
        Assert.assertTrue((String)"Location not defined", (boolean)handler.isLocationDefined());
    }

    @Test
    public void testIsLocationDefinedFileName() {
        FileHandler handler = new FileHandler();
        handler.setFileName(this.createTestFile().getName());
        Assert.assertTrue((String)"Location not defined", (boolean)handler.isLocationDefined());
    }

    @Test
    public void testIsLocationDefinedFalse() {
        FileHandler handler = new FileHandler();
        Assert.assertFalse((String)"Location defined", (boolean)handler.isLocationDefined());
    }

    @Test
    public void testIsLocationDefinedBasePathOnly() {
        FileHandler handler = new FileHandler();
        handler.setBasePath(this.createTestFile().getParent());
        Assert.assertFalse((String)"Location defined", (boolean)handler.isLocationDefined());
    }

    @Test
    public void testClearLocation() {
        FileHandler handler = new FileHandler();
        handler.setFile(this.createTestFile());
        handler.clearLocation();
        Assert.assertFalse((String)"Location defined", (boolean)handler.isLocationDefined());
        Assert.assertNull((String)"Got a file", (Object)handler.getFile());
        Assert.assertNull((String)"Got a URL", (Object)handler.getURL());
        Assert.assertNull((String)"Got a base path", (Object)handler.getBasePath());
        Assert.assertNull((String)"Got a path", (Object)handler.getPath());
    }

    @Test
    public void testLoadFileLocatorAware() throws IOException, ConfigurationException {
        File file = this.createTestFile();
        FileBasedFileLocatorAwareTestImpl content = new FileBasedFileLocatorAwareTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.setFile(file);
        handler.load();
        Assert.assertEquals((String)"Wrong result", (Object)(file.toURI().toURL().toString() + ": " + CONTENT), (Object)content.getContent());
    }

    private static void checkEmptyLocator(FileBasedFileLocatorAwareTestImpl content) {
        Assert.assertNull((String)"Got a URL", (Object)content.getLocator().getSourceURL());
        Assert.assertNull((String)"Got a base path", (Object)content.getLocator().getBasePath());
        Assert.assertNull((String)"Got a file name", (Object)content.getLocator().getFileName());
    }

    @Test
    public void testLoadFileLocatorAwareStream() throws ConfigurationException, IOException {
        FileBasedFileLocatorAwareTestImpl content = new FileBasedFileLocatorAwareTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        ByteArrayInputStream bos = new ByteArrayInputStream(CONTENT.getBytes());
        handler.load((InputStream)bos);
        TestFileHandler.checkEmptyLocator(content);
    }

    @Test
    public void testLoadFileLocatorAwareReader() throws ConfigurationException, IOException {
        FileBasedFileLocatorAwareTestImpl content = new FileBasedFileLocatorAwareTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.load((Reader)new StringReader(CONTENT));
        TestFileHandler.checkEmptyLocator(content);
    }

    @Test
    public void testSaveFileLocatorAware() throws ConfigurationException, IOException {
        File file = this.folder.newFile();
        FileBasedFileLocatorAwareTestImpl content = new FileBasedFileLocatorAwareTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.save(file);
        Assert.assertEquals((String)"Wrong file content", (Object)(file.toURI().toURL() + ": " + CONTENT), (Object)TestFileHandler.readFile(file));
    }

    @Test
    public void testSaveFileLocatorAwareToStream() throws ConfigurationException, IOException {
        FileBasedFileLocatorAwareTestImpl content = new FileBasedFileLocatorAwareTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.save((OutputStream)new ByteArrayOutputStream());
        TestFileHandler.checkEmptyLocator(content);
    }

    @Test
    public void testSaveFileLocatorAwareToWriter() throws ConfigurationException, IOException {
        FileBasedFileLocatorAwareTestImpl content = new FileBasedFileLocatorAwareTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        handler.save((Writer)new StringWriter());
        TestFileHandler.checkEmptyLocator(content);
    }

    @Test
    public void testLocatorAwareEncoding() throws ConfigurationException {
        FileBasedFileLocatorAwareTestImpl content = new FileBasedFileLocatorAwareTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        String encoding = "testEncoding";
        handler.setEncoding(encoding);
        handler.save((Writer)new StringWriter());
        Assert.assertEquals((String)"Encoding not set", (Object)encoding, (Object)content.getLocator().getEncoding());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddFileHandlerListenerNull() {
        new FileHandler().addFileHandlerListener(null);
    }

    @Test
    public void testLoadEvents() throws ConfigurationException {
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        FileHandlerListenerTestImpl listener = new FileHandlerListenerTestImpl(handler);
        handler.addFileHandlerListener((FileHandlerListener)listener);
        handler.load(this.createTestFile());
        listener.checkMethods("loadingloaded");
    }

    @Test
    public void testSaveEvents() throws IOException, ConfigurationException {
        FileHandler handler = new FileHandler((FileBased)new FileBasedTestImpl());
        FileHandlerListenerTestImpl listener = new FileHandlerListenerTestImpl(handler);
        handler.addFileHandlerListener((FileHandlerListener)listener);
        File f = this.folder.newFile();
        handler.save(f);
        listener.checkMethods("savingsaved");
    }

    @Test
    public void testLocationChangedFileName() {
        FileHandler handler = new FileHandler();
        FileHandlerListenerTestImpl listener = new FileHandlerListenerTestImpl(handler);
        handler.addFileHandlerListener((FileHandlerListener)listener);
        handler.setFileName(TEST_FILENAME);
        listener.checkMethods("locationChanged");
    }

    @Test
    public void testLocationChangedBasePath() {
        FileHandler handler = new FileHandler();
        FileHandlerListenerTestImpl listener = new FileHandlerListenerTestImpl(handler);
        handler.addFileHandlerListener((FileHandlerListener)listener);
        handler.setBasePath(TEST_FILENAME);
        listener.checkMethods("locationChanged");
    }

    @Test
    public void testLocationChangedFile() throws IOException {
        FileHandler handler = new FileHandler();
        FileHandlerListenerTestImpl listener = new FileHandlerListenerTestImpl(handler);
        handler.addFileHandlerListener((FileHandlerListener)listener);
        handler.setFile(this.folder.newFile());
        listener.checkMethods("locationChanged");
    }

    @Test
    public void testLocationChangedPath() {
        FileHandler handler = new FileHandler();
        FileHandlerListenerTestImpl listener = new FileHandlerListenerTestImpl(handler);
        handler.addFileHandlerListener((FileHandlerListener)listener);
        handler.setPath(TEST_FILENAME);
        listener.checkMethods("locationChanged");
    }

    @Test
    public void testLocationChangedFileSystem() {
        FileSystem fs = (FileSystem)EasyMock.createMock(FileSystem.class);
        FileHandler handler = new FileHandler();
        FileHandlerListenerTestImpl listener = new FileHandlerListenerTestImpl(handler);
        handler.addFileHandlerListener((FileHandlerListener)listener);
        handler.setFileSystem(fs);
        listener.checkMethods("locationChanged");
    }

    @Test
    public void testLocationChangedURL() throws IOException {
        FileHandler handler = new FileHandler();
        FileHandlerListenerTestImpl listener = new FileHandlerListenerTestImpl(handler);
        handler.addFileHandlerListener((FileHandlerListener)listener);
        URL url = this.folder.newFile().toURI().toURL();
        handler.setURL(url);
        listener.checkMethods("locationChanged");
    }

    @Test
    public void testLocationChangedEncoding() {
        FileHandler handler = new FileHandler();
        FileHandlerListenerTestImpl listener = new FileHandlerListenerTestImpl(handler);
        handler.addFileHandlerListener((FileHandlerListener)listener);
        handler.setEncoding("UTF-8");
        listener.checkMethods("locationChanged");
    }

    @Test
    public void testLocationChangedLocator() {
        FileHandler handler = new FileHandler();
        FileHandlerListenerTestImpl listener = new FileHandlerListenerTestImpl(handler);
        handler.addFileHandlerListener((FileHandlerListener)listener);
        handler.setFileLocator(FileLocatorUtils.fileLocator().fileName(TEST_FILENAME).create());
        listener.checkMethods("locationChanged");
    }

    @Test
    public void testLoadInputStreamSupport() throws ConfigurationException {
        FileBasedInputStreamSupportTestImpl content = new FileBasedInputStreamSupportTestImpl();
        FileHandler handler = new FileHandler((FileBased)content);
        ByteArrayInputStream bin = new ByteArrayInputStream(CONTENT.getBytes());
        handler.load((InputStream)bin);
        Assert.assertEquals((String)"Wrong content", (Object)"InputStream = TestFileHandler: This is test content.", (Object)content.getContent());
    }

    @Test
    public void testLoadInputStreamSupportIOException() throws ConfigurationException, IOException {
        FileBasedInputStreamSupportTestImpl content = (FileBasedInputStreamSupportTestImpl)EasyMock.createMock(FileBasedInputStreamSupportTestImpl.class);
        ByteArrayInputStream bin = new ByteArrayInputStream(CONTENT.getBytes());
        IOException ioex = new IOException();
        content.read(bin);
        EasyMock.expectLastCall().andThrow((Throwable)ioex);
        EasyMock.replay((Object[])new Object[]{content});
        FileHandler handler = new FileHandler((FileBased)content);
        try {
            handler.load((InputStream)bin);
            Assert.fail((String)"IOException not detected!");
        }
        catch (ConfigurationException cex) {
            Assert.assertEquals((String)"Wrong cause", (Object)ioex, (Object)cex.getCause());
        }
        EasyMock.verify((Object[])new Object[]{content});
    }

    @Test
    public void testLoadSynchronized() throws ConfigurationException {
        PropertiesConfiguration config = new PropertiesConfiguration();
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        config.setSynchronizer((Synchronizer)sync);
        FileHandler handler = new FileHandler((FileBased)config);
        handler.load(ConfigurationAssert.getTestFile(TEST_FILENAME));
        sync.verifyStart(SynchronizerTestImpl.Methods.BEGIN_WRITE);
        sync.verifyEnd(SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testSaveSynchronized() throws ConfigurationException, IOException {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty("test.synchronized", (Object)Boolean.TRUE);
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        config.setSynchronizer((Synchronizer)sync);
        FileHandler handler = new FileHandler((FileBased)config);
        File f = this.folder.newFile();
        handler.save(f);
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testInitPropertiesMultiThreaded() throws InterruptedException {
        String encoding = "TestEncoding";
        DefaultFileSystem fileSystem = new DefaultFileSystem();
        ProvidedURLLocationStrategy locationStrategy = new ProvidedURLLocationStrategy();
        int loops = 8;
        for (int i = 0; i < 8; ++i) {
            final FileHandler handler = new FileHandler();
            Thread t1 = new Thread((FileSystem)fileSystem){
                final /* synthetic */ FileSystem val$fileSystem;
                {
                    this.val$fileSystem = fileSystem;
                }

                @Override
                public void run() {
                    handler.setFileSystem(this.val$fileSystem);
                }
            };
            Thread t2 = new Thread(){

                @Override
                public void run() {
                    handler.setFileName(TestFileHandler.TEST_FILENAME);
                }
            };
            Thread t3 = new Thread(){

                @Override
                public void run() {
                    handler.setEncoding("TestEncoding");
                }
            };
            Thread t4 = new Thread((FileLocationStrategy)locationStrategy){
                final /* synthetic */ FileLocationStrategy val$locationStrategy;
                {
                    this.val$locationStrategy = fileLocationStrategy;
                }

                @Override
                public void run() {
                    handler.setLocationStrategy(this.val$locationStrategy);
                }
            };
            List<Thread> threads = Arrays.asList(t1, t2, t3, t4);
            for (Thread t : threads) {
                t.start();
            }
            for (Thread t : threads) {
                t.join();
            }
            FileLocator locator = handler.getFileLocator();
            Assert.assertEquals((String)"Wrong file name", (Object)TEST_FILENAME, (Object)locator.getFileName());
            Assert.assertNull((String)"Got a URL", (Object)locator.getSourceURL());
            Assert.assertEquals((String)"Wrong encoding", (Object)"TestEncoding", (Object)locator.getEncoding());
            Assert.assertSame((String)"Wrong file system", (Object)fileSystem, (Object)locator.getFileSystem());
            Assert.assertSame((String)"Wrong location strategy", (Object)locationStrategy, (Object)locator.getLocationStrategy());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetFileLocatorNull() {
        FileHandler handler = new FileHandler();
        handler.setFileLocator(null);
    }

    @Test
    public void testSetFileLocator() {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName(TEST_FILENAME).create();
        FileHandler handler = new FileHandler();
        handler.setFileLocator(locator);
        Assert.assertEquals((String)"Handler not initialized", (Object)TEST_FILENAME, (Object)handler.getFileName());
    }

    @Test
    public void testLocateSuccess() throws ConfigurationException {
        FileHandler handler = new FileHandler();
        handler.setFileName(TEST_FILENAME);
        Assert.assertTrue((String)"Wrong result", (boolean)handler.locate());
        FileLocator locator = handler.getFileLocator();
        Assert.assertNotNull((String)"URL not filled", (Object)locator.getSourceURL());
        Assert.assertNotNull((String)"Base path not filled", (Object)locator.getBasePath());
        Assert.assertEquals((String)"Wrong file name", (Object)TEST_FILENAME, (Object)locator.getFileName());
        PropertiesConfiguration config = new PropertiesConfiguration();
        FileHandler h2 = new FileHandler((FileBased)config);
        h2.setURL(locator.getSourceURL());
        h2.load();
        Assert.assertTrue((String)"Configuration not loaded", (boolean)config.getBoolean("configuration.loaded"));
    }

    @Test
    public void testLocateUnknownFile() {
        FileHandler handler = new FileHandler();
        handler.setFileName("unknown file");
        FileLocator locator = handler.getFileLocator();
        Assert.assertFalse((String)"Wrong result", (boolean)handler.locate());
        Assert.assertSame((String)"Locator was changed", (Object)locator, (Object)handler.getFileLocator());
    }

    @Test
    public void testLocateUndefinedLocator() {
        FileHandler handler = new FileHandler();
        handler.setBasePath("only/a/base/path");
        FileLocator locator = handler.getFileLocator();
        Assert.assertFalse((String)"Wrong result", (boolean)handler.locate());
        Assert.assertSame((String)"Locator was changed", (Object)locator, (Object)handler.getFileLocator());
    }

    @Test
    public void testInitFromMap() {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName(TEST_FILENAME).basePath("someBasePath").encoding("someEncoding").create();
        HashMap map = new HashMap();
        FileLocatorUtils.put((FileLocator)locator, map);
        FileHandler handler = FileHandler.fromMap(map);
        Assert.assertEquals((String)"Wrong locator", (Object)locator, (Object)handler.getFileLocator());
    }

    private static class FileHandlerListenerTestImpl
    extends FileHandlerListenerAdapter {
        private final FileHandler expHandler;
        private final StringBuilder methods;

        public FileHandlerListenerTestImpl(FileHandler fh) {
            this.expHandler = fh;
            this.methods = new StringBuilder();
        }

        public void checkMethods(String expMethods) {
            Assert.assertEquals((String)"Wrong listener methods", (Object)expMethods, (Object)this.methods.toString());
        }

        public void loading(FileHandler handler) {
            super.loading(handler);
            this.methodCalled(handler, "loading");
        }

        public void loaded(FileHandler handler) {
            super.loaded(handler);
            this.methodCalled(handler, "loaded");
        }

        public void saving(FileHandler handler) {
            super.saving(handler);
            this.methodCalled(handler, "saving");
        }

        public void saved(FileHandler handler) {
            super.saved(handler);
            this.methodCalled(handler, "saved");
        }

        public void locationChanged(FileHandler handler) {
            super.locationChanged(handler);
            this.methodCalled(handler, "locationChanged");
        }

        private void methodCalled(FileHandler handler, String method) {
            Assert.assertEquals((String)"Wrong file handler", (Object)this.expHandler, (Object)handler);
            this.methods.append(method);
        }
    }

    private static final class FileBasedFileLocatorAwareTestImpl
    extends FileBasedTestImpl
    implements FileLocatorAware {
        private FileLocator locator;

        private FileBasedFileLocatorAwareTestImpl() {
        }

        public FileLocator getLocator() {
            return this.locator;
        }

        public void initFileLocator(FileLocator loc) {
            this.locator = loc;
        }

        @Override
        public void read(Reader in) throws ConfigurationException, IOException {
            super.read(in);
            this.setContent(String.valueOf(this.locator.getSourceURL()) + ": " + this.getContent());
        }

        @Override
        public void write(Writer out) throws ConfigurationException, IOException {
            out.write(String.valueOf(this.locator.getSourceURL()) + ": ");
            super.write(out);
        }
    }

    private static class FileBasedInputStreamSupportTestImpl
    extends FileBasedTestImpl
    implements InputStreamSupport {
        private FileBasedInputStreamSupportTestImpl() {
        }

        public void read(InputStream in) throws ConfigurationException, IOException {
            int c;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((c = in.read()) != -1) {
                bos.write(c);
            }
            this.setContent("InputStream = " + bos.toString());
        }
    }

    private static class FileBasedTestImpl
    implements FileBased {
        private String content = "TestFileHandler: This is test content.";

        private FileBasedTestImpl() {
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void read(Reader in) throws ConfigurationException, IOException {
            this.content = TestFileHandler.readReader(in);
        }

        public void write(Writer out) throws ConfigurationException, IOException {
            out.write(this.getContent());
            out.flush();
        }
    }
}

