/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.reloading;

import java.io.File;
import java.net.URL;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.reloading.FileHandlerReloadingDetector;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TestFileHandlerReloadingDetector {
    private static final long LAST_MODIFIED = 20121008215654L;

    @Test
    public void testInitWithFileHandler() {
        FileHandler handler = new FileHandler();
        FileHandlerReloadingDetector detector = new FileHandlerReloadingDetector(handler);
        Assert.assertSame((String)"Different file handler", (Object)handler, (Object)detector.getFileHandler());
    }

    @Test
    public void testDefaultRefreshDelay() {
        FileHandlerReloadingDetector detector = new FileHandlerReloadingDetector();
        Assert.assertEquals((String)"Wrong delay", (long)5000L, (long)detector.getRefreshDelay());
    }

    @Test
    public void testLocationAfterInit() {
        FileHandlerReloadingDetector detector = new FileHandlerReloadingDetector();
        Assert.assertFalse((String)"Got a location", (boolean)detector.getFileHandler().isLocationDefined());
    }

    @Test
    public void testIsReloadingRequiredNoLocation() {
        FileHandlerReloadingDetector detector = new FileHandlerReloadingDetector();
        Assert.assertFalse((String)"Reloading", (boolean)detector.isReloadingRequired());
    }

    @Test
    public void testIsReloadingRequiredTrue() throws Exception {
        File f = (File)EasyMock.createMock(File.class);
        EasyMock.expect((Object)f.exists()).andReturn((Object)Boolean.TRUE).anyTimes();
        EasyMock.expect((Object)f.lastModified()).andReturn((Object)20121008215654L);
        EasyMock.expect((Object)f.lastModified()).andReturn((Object)20121008215655L);
        EasyMock.replay((Object[])new Object[]{f});
        FileHandlerReloadingDetectorTestImpl detector = new FileHandlerReloadingDetectorTestImpl(f);
        Assert.assertFalse((String)"Reloading required", (boolean)detector.isReloadingRequired());
        Assert.assertTrue((String)"Reloading not detected", (boolean)detector.isReloadingRequired());
    }

    @Test
    public void testReloadingAndReset() throws Exception {
        File f = (File)EasyMock.createMock(File.class);
        EasyMock.expect((Object)f.exists()).andReturn((Object)Boolean.TRUE).anyTimes();
        EasyMock.expect((Object)f.lastModified()).andReturn((Object)20121008215654L);
        EasyMock.expect((Object)f.lastModified()).andReturn((Object)20121008215655L).times(3);
        EasyMock.expect((Object)f.lastModified()).andReturn((Object)20121008215656L);
        EasyMock.replay((Object[])new Object[]{f});
        FileHandlerReloadingDetectorTestImpl detector = new FileHandlerReloadingDetectorTestImpl(f);
        Assert.assertFalse((String)"Reloading required", (boolean)detector.isReloadingRequired());
        Assert.assertTrue((String)"Reloading not detected", (boolean)detector.isReloadingRequired());
        detector.reloadingPerformed();
        Assert.assertFalse((String)"Still reloading required", (boolean)detector.isReloadingRequired());
        Assert.assertTrue((String)"Next reloading not detected", (boolean)detector.isReloadingRequired());
    }

    @Test
    public void testRefreshDelay() throws Exception {
        File f = (File)EasyMock.createMock(File.class);
        EasyMock.expect((Object)f.exists()).andReturn((Object)Boolean.TRUE).anyTimes();
        EasyMock.expect((Object)f.lastModified()).andReturn((Object)20121008215654L).times(2);
        EasyMock.replay((Object[])new Object[]{f});
        FileHandlerReloadingDetectorTestImpl detector = new FileHandlerReloadingDetectorTestImpl(f, 3600000L);
        detector.reloadingPerformed();
        Assert.assertFalse((String)"Reloading initially required", (boolean)detector.isReloadingRequired());
        Assert.assertFalse((String)"Reloading required", (boolean)detector.isReloadingRequired());
    }

    @Test
    public void testIsReloadingRequiredFileDoesNotExist() {
        FileHandlerReloadingDetector detector = new FileHandlerReloadingDetector();
        detector.getFileHandler().setFile(new File("NonExistingFile.txt"));
        detector.reloadingPerformed();
        Assert.assertFalse((String)"Reloading required", (boolean)detector.isReloadingRequired());
    }

    @Test
    public void testGetFileJarURL() throws Exception {
        FileHandlerReloadingDetector detector = new FileHandlerReloadingDetector();
        URL url = new URL("jar:" + new File("conf/resources.jar").getAbsoluteFile().toURI().toURL() + "!/test-jar.xml");
        detector.getFileHandler().setURL(url);
        File file = detector.getFile();
        Assert.assertNotNull((String)"Detector's file is null", (Object)file);
        Assert.assertEquals((String)"Detector does not monitor the jar file", (Object)"resources.jar", (Object)file.getName());
    }

    private static class FileHandlerReloadingDetectorTestImpl
    extends FileHandlerReloadingDetector {
        private final File mockFile;

        public FileHandlerReloadingDetectorTestImpl(File file) {
            this(file, 0L);
        }

        public FileHandlerReloadingDetectorTestImpl(File file, long delay) {
            super(null, delay);
            this.mockFile = file;
        }

        protected File getFile() {
            return this.mockFile;
        }
    }
}

