/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.reloading;

import org.apache.commons.configuration2.event.Event;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.reloading.ReloadingController;
import org.apache.commons.configuration2.reloading.ReloadingDetector;
import org.apache.commons.configuration2.reloading.ReloadingEvent;
import org.apache.commons.lang3.mutable.MutableObject;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestReloadingController {
    private ReloadingDetector detector;

    @Before
    public void setUp() throws Exception {
        this.detector = (ReloadingDetector)EasyMock.createMock(ReloadingDetector.class);
    }

    private ReloadingController createController() {
        return new ReloadingController(this.detector);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitNoDetector() {
        new ReloadingController(null);
    }

    @Test
    public void testReloadingStateAfterInit() {
        Assert.assertFalse((String)"In reloading state", (boolean)this.createController().isInReloadingState());
    }

    private static EventListener<ReloadingEvent> createListenerMock() {
        EventListener listener = (EventListener)EasyMock.createMock(EventListener.class);
        return listener;
    }

    private void expectEvent(EventListener<ReloadingEvent> l, final MutableObject<ReloadingEvent> evRef) {
        l.onEvent((Event)EasyMock.anyObject(ReloadingEvent.class));
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                evRef.setValue((Object)((ReloadingEvent)EasyMock.getCurrentArguments()[0]));
                return null;
            }
        });
    }

    @Test
    public void testCheckForReloadingTrue() {
        EventListener<ReloadingEvent> l = TestReloadingController.createListenerMock();
        EventListener<ReloadingEvent> lRemoved = TestReloadingController.createListenerMock();
        MutableObject evRef = new MutableObject();
        this.expectEvent(l, (MutableObject<ReloadingEvent>)evRef);
        EasyMock.expect((Object)this.detector.isReloadingRequired()).andReturn((Object)Boolean.TRUE);
        EasyMock.replay((Object[])new Object[]{this.detector, l, lRemoved});
        ReloadingController ctrl = this.createController();
        ctrl.addEventListener(ReloadingEvent.ANY, lRemoved);
        ctrl.addEventListener(ReloadingEvent.ANY, l);
        Assert.assertTrue((String)"Wrong result", (boolean)ctrl.removeEventListener(ReloadingEvent.ANY, lRemoved));
        String testData = "Some test data";
        Assert.assertTrue((String)"Wrong result", (boolean)ctrl.checkForReloading((Object)testData));
        Assert.assertTrue((String)"Not in reloading state", (boolean)ctrl.isInReloadingState());
        Assert.assertSame((String)"Wrong event source", (Object)ctrl, (Object)((ReloadingEvent)evRef.getValue()).getSource());
        Assert.assertSame((String)"Wrong controller", (Object)ctrl, (Object)((ReloadingEvent)evRef.getValue()).getController());
        Assert.assertEquals((String)"Wrong event data", (Object)testData, (Object)((ReloadingEvent)evRef.getValue()).getData());
        EasyMock.verify((Object[])new Object[]{l, lRemoved, this.detector});
    }

    @Test
    public void testCheckForReloadingFalse() {
        EventListener<ReloadingEvent> l = TestReloadingController.createListenerMock();
        EasyMock.expect((Object)this.detector.isReloadingRequired()).andReturn((Object)Boolean.FALSE);
        EasyMock.replay((Object[])new Object[]{this.detector, l});
        ReloadingController ctrl = this.createController();
        ctrl.addEventListener(ReloadingEvent.ANY, l);
        Assert.assertFalse((String)"Wrong result", (boolean)ctrl.checkForReloading(null));
        Assert.assertFalse((String)"In reloading state", (boolean)ctrl.isInReloadingState());
        EasyMock.verify((Object[])new Object[]{this.detector, l});
    }

    @Test
    public void testCheckForReloadingInReloadingState() {
        EventListener<ReloadingEvent> l = TestReloadingController.createListenerMock();
        EasyMock.expect((Object)this.detector.isReloadingRequired()).andReturn((Object)Boolean.TRUE);
        this.expectEvent(l, (MutableObject<ReloadingEvent>)new MutableObject());
        EasyMock.replay((Object[])new Object[]{this.detector, l});
        ReloadingController ctrl = this.createController();
        ctrl.addEventListener(ReloadingEvent.ANY, l);
        Assert.assertTrue((String)"Wrong result (1)", (boolean)ctrl.checkForReloading((Object)1));
        Assert.assertTrue((String)"Wrong result (2)", (boolean)ctrl.checkForReloading((Object)2));
        EasyMock.verify((Object[])new Object[]{this.detector, l});
    }

    @Test
    public void testResetReloadingState() {
        EasyMock.expect((Object)this.detector.isReloadingRequired()).andReturn((Object)Boolean.TRUE);
        this.detector.reloadingPerformed();
        EasyMock.replay((Object[])new Object[]{this.detector});
        ReloadingController ctrl = this.createController();
        ctrl.checkForReloading(null);
        ctrl.resetReloadingState();
        Assert.assertFalse((String)"In reloading state", (boolean)ctrl.isInReloadingState());
        EasyMock.verify((Object[])new Object[]{this.detector});
    }

    @Test
    public void testResetReloadingNotInReloadingState() {
        EasyMock.replay((Object[])new Object[]{this.detector});
        this.createController().resetReloadingState();
    }

    @Test
    public void testReloadingEventType() {
        Assert.assertEquals((String)"Wrong super event type", (Object)Event.ANY, (Object)ReloadingEvent.ANY.getSuperType());
    }
}

