/*
 * Copyright 2001-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License")
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.commons.configuration;

import java.io.File;

/**
 * Test if non-string properties are handled correctly.
 *
 * @version $Id: TestCompositeConfigurationNonStringProperties.java 155408 2005-02-26 12:56:39Z dirkv $
 */
public class TestCompositeConfigurationNonStringProperties extends BaseNonStringProperties
{
    /** The File that we test with */
    private String testProperties = new File("conf/test.properties").getAbsolutePath();

    public void setUp() throws Exception
    {
        CompositeConfiguration cc = new CompositeConfiguration();
        cc.addConfiguration(new PropertiesConfiguration(testProperties));
        conf = cc;
        nonStringTestHolder.setConfiguration(conf);
    }

}
