/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.TesterClassLoader;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestParallelCreationWithNoIdle {
    private static final String CATALOG = "test catalog";
    protected BasicDataSource ds;

    @BeforeAll
    public static void setUpClass() {
        LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", (Object)"org.apache.commons.dbcp2.StackMessageLog");
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.ds = new BasicDataSource();
        this.ds.setDriverClassName("org.apache.commons.dbcp2.TesterConnectionDelayDriver");
        this.ds.setUrl("jdbc:apache:commons:testerConnectionDelayDriver:50");
        this.ds.setMaxTotal(10);
        this.ds.setMaxIdle(0);
        this.ds.setMaxWait(Duration.ofMinutes(1L));
        this.ds.setDefaultAutoCommit(Boolean.TRUE);
        this.ds.setDefaultReadOnly(Boolean.FALSE);
        this.ds.setDefaultTransactionIsolation(2);
        this.ds.setDefaultCatalog(CATALOG);
        this.ds.setUsername("userName");
        this.ds.setPassword("password");
        this.ds.setValidationQuery("SELECT DUMMY FROM DUAL");
        this.ds.setConnectionInitSqls(Arrays.asList("SELECT 1", "SELECT 2"));
        this.ds.setDriverClassLoader((ClassLoader)new TesterClassLoader());
        this.ds.setJmxName("org.apache.commons.dbcp2:name=test");
    }

    @Test
    public void testMassiveConcurrentInitBorrow() throws Exception {
        int i;
        int numThreads = 200;
        this.ds.setDriverClassName("org.apache.commons.dbcp2.TesterConnectionDelayDriver");
        this.ds.setUrl("jdbc:apache:commons:testerConnectionDelayDriver:20");
        this.ds.setInitialSize(8);
        List errors = Collections.synchronizedList(new ArrayList());
        Thread[] threads = new Thread[200];
        for (i = 0; i < 200; ++i) {
            threads[i] = new TestThread(2, 0, 50);
            threads[i].setUncaughtExceptionHandler((t, e) -> errors.add(e));
        }
        for (i = 0; i < 200; ++i) {
            threads[i].start();
            if (i % 4 != 0) continue;
            Thread.sleep(20L);
        }
        for (i = 0; i < 200; ++i) {
            threads[i].join();
        }
        Assertions.assertEquals((int)0, (int)errors.size());
        this.ds.close();
    }

    class TestThread
    extends Thread {
        final Random _random = new Random();
        final int iter;
        final int delay;
        final int delayAfter;

        public TestThread(int iter, int delay, int delayAfter) {
            this.iter = iter;
            this.delay = delay;
            this.delayAfter = delayAfter;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.iter; ++i) {
                this.sleepMax(this.delay);
                try (Connection conn = TestParallelCreationWithNoIdle.this.ds.getConnection();
                     PreparedStatement stmt = conn.prepareStatement("select 'literal', SYSDATE from dual");){
                    ResultSet rset = stmt.executeQuery();
                    rset.next();
                    this.sleepMax(this.delayAfter);
                    rset.close();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        }

        private void sleepMax(int timeMax) {
            if (timeMax == 0) {
                return;
            }
            try {
                Thread.sleep(this._random.nextInt(timeMax));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

